/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CosNaming.tnaming;

import java.util.Map;
import java.util.Properties;
import org.apache.yoko.orb.CORBA.ORB;
import org.apache.yoko.orb.CosNaming.tnaming.TransientNamingContext;
import org.apache.yoko.orb.CosNaming.tnaming.TransientServiceException;
import org.apache.yoko.orb.OB.BootManager;
import org.apache.yoko.orb.OB.BootManagerHelper;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class TransientNameService
implements AutoCloseable {
    public static final String DEFAULT_SERVICE_NAME = "TNameService";
    public static final int DEFAULT_SERVICE_PORT = 900;
    public static final String DEFAULT_SERVICE_HOST = "localhost";
    protected TransientNamingContext initialContext;
    protected int port;
    protected String host;
    protected String serviceName;
    protected org.omg.CORBA.ORB createdOrb;

    public TransientNameService() {
        this(DEFAULT_SERVICE_HOST, 900, DEFAULT_SERVICE_NAME);
    }

    public TransientNameService(String host, int port) {
        this(host, port, DEFAULT_SERVICE_NAME);
    }

    public TransientNameService(String host, int port, String name) {
        this.port = port;
        this.host = host;
        this.serviceName = name;
    }

    public void run() throws TransientServiceException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        props.put("org.omg.CORBA.ORBServerId", "1000000");
        props.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        props.put("yoko.orb.oa.endpoint", "iiop --host " + this.host + " --port " + this.port);
        this.createdOrb = org.omg.CORBA.ORB.init((String[])null, (Properties)props);
        this.initialize(this.createdOrb);
    }

    public void initialize(org.omg.CORBA.ORB orb) throws TransientServiceException {
        try {
            POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
            rootPOA.the_POAManager().activate();
            Policy[] policy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN)};
            POA nameServicePOA = rootPOA.create_POA(DEFAULT_SERVICE_NAME, null, policy);
            nameServicePOA.the_POAManager().activate();
            this.initialContext = new TransientNamingContext(orb, nameServicePOA);
            BootManager bootManager = BootManagerHelper.narrow(orb.resolve_initial_references("BootManager"));
            byte[] objectId = this.serviceName.getBytes();
            bootManager.add_binding(objectId, this.initialContext.getRootContext());
            ((ORB)orb).register_initial_reference("NameService", this.initialContext.getRootContext());
        }
        catch (Exception e) {
            throw new TransientServiceException("Unable to initialize name service", e);
        }
    }

    public void destroy() {
        if (this.createdOrb != null) {
            this.createdOrb.destroy();
            this.createdOrb = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.destroy();
    }
}

