/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.helpers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.filetransfer.FileServiceMXBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.filetransfer.util.FileServiceUtil;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferRoutingHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.ServerPath;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.handler.helper.ServletRESTRequestWithParams;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.management.JMX;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={FileTransferHelper.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class FileTransferHelper {
    private static final TraceComponent tc = Tr.register(FileTransferHelper.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    private static final String RANDOM_FILE_ACCESS_READ_MODE = "r";
    private static final String RANDOM_FILE_ACCESS_READ_WRITE_MODE = "rw";
    private static final int FILE_TRANSFER_DEFAULT_BUFFER_SIZE = 8192;
    public static final String HTTP_ACCEPT = "Accept";
    public static final String HTTP_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HTTP_CONTENT_ENCODING = "Content-Encoding";
    private static final String FILE_TRANSFER_GZIP_MIME = "application/gzip";
    private static final String FILE_TRANSFER_ZIP_MIME = "application/zip";
    private static final String FILE_TRANSFER_PAX_MIME = "application/pax";
    private static final String FILE_TRANSFER_TAR_MIME = "application/x-tar";
    private static final String FILE_TRANSFER_TEXT_MIME = "text/plain";
    private static final String FILE_TRANSFER_HTML_MIME = "text/html";
    private static final String FILE_TRANSFER_XML_MIME = "text/xml";
    private static final String FILE_TRANSFER_BINARY_MIME = "application/octet-stream";
    private final String KEY_LOCATION_ADMIN = "wsLocationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> wsLocationAdminRef = new AtomicServiceReference("wsLocationAdmin");
    private final String KEY_ROUTING_HELPER = "routingHelper";
    private final AtomicServiceReference<FileTransferRoutingHelper> routingHelperRef = new AtomicServiceReference("routingHelper");
    private volatile FileServiceMXBean fileService;
    static final long serialVersionUID = 2064913023744476969L;

    @Activate
    protected void activate(ComponentContext cc) {
        this.wsLocationAdminRef.activate(cc);
        this.routingHelperRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.wsLocationAdminRef.deactivate(cc);
        this.routingHelperRef.deactivate(cc);
    }

    @Reference(name="wsLocationAdmin", service=WsLocationAdmin.class)
    protected void setWsLocationAdminRef(ServiceReference<WsLocationAdmin> ref) {
        this.wsLocationAdminRef.setReference(ref);
    }

    protected void unsetWsLocationAdminRef(ServiceReference<WsLocationAdmin> ref) {
        this.wsLocationAdminRef.unsetReference(ref);
    }

    @Reference(service=FileTransferRoutingHelper.class, name="routingHelper", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRoutingHelper(ServiceReference<FileTransferRoutingHelper> routingHelper) {
        this.routingHelperRef.setReference(routingHelper);
    }

    protected void unsetRoutingHelper(ServiceReference<FileTransferRoutingHelper> routingHelper) {
        this.routingHelperRef.unsetReference(routingHelper);
    }

    private FileTransferRoutingHelper getRoutingHelper() {
        FileTransferRoutingHelper routingHelper = (FileTransferRoutingHelper)this.routingHelperRef.getService();
        if (routingHelper == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"FileTransferRoutingHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return routingHelper;
    }

    private String getMIMEType(String path) {
        String extension = FileTransferHelper.getFileExtension(path);
        if (extension == null) {
            return FILE_TRANSFER_BINARY_MIME;
        }
        if ("zip".equals(extension) || "ear".equals(extension) || "war".equals(extension) || "jar".equals(extension) || "eba".equals(extension)) {
            return FILE_TRANSFER_ZIP_MIME;
        }
        if ("pax".equals(extension)) {
            return FILE_TRANSFER_PAX_MIME;
        }
        if ("gz".equals(extension) || "gzip".equals(extension)) {
            return FILE_TRANSFER_GZIP_MIME;
        }
        if ("tar".equals(extension)) {
            return FILE_TRANSFER_TAR_MIME;
        }
        if ("txt".equals(extension) || "log".equals(extension) || "trace".equals(extension) || "properties".equals(extension)) {
            return FILE_TRANSFER_TEXT_MIME;
        }
        if ("xml".equals(extension) || "xslt".equals(extension) || "xsl".equals(extension)) {
            return FILE_TRANSFER_XML_MIME;
        }
        if ("html".equals(extension) || "htm".equals(extension)) {
            return FILE_TRANSFER_HTML_MIME;
        }
        return FILE_TRANSFER_BINARY_MIME;
    }

    private static String getFileExtension(String path) {
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return path.substring(index + 1).toLowerCase(Locale.ENGLISH);
    }

    public static String getParentDir(String filePath) {
        String parentDir = filePath.substring(0, filePath.lastIndexOf("/"));
        if (!parentDir.contains("/")) {
            parentDir = parentDir + "/";
        }
        return parentDir;
    }

    public static String removeTrailingSlash(String file) {
        if (file.charAt(file.length() - 1) == '/') {
            file = file.substring(0, file.length() - 1);
        }
        return file;
    }

    public static String appendFilename(String directory, String filename) {
        if (directory.endsWith("/")) {
            return directory + filename;
        }
        return directory + "/" + filename;
    }

    @FFDCIgnore(value={UnsupportedEncodingException.class})
    public static String decodeFilePath(String filePath) {
        try {
            return URLDecoder.decode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
    }

    private String processAndValidateFilePath(String filePath, boolean readOnly) {
        String processedPath = this.getWsLocationAdmin().resolveString(FileTransferHelper.decodeFilePath(filePath));
        if (!this.checkAccess(processedPath, readOnly)) {
            Object[] params = new String[]{processedPath};
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"SERVER_ACCESS_DENIED_ERROR", (Object[])params, (String)("CWWKX0121E: Access denied to the " + processedPath + " path.")));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 400);
        }
        return processedPath;
    }

    public static boolean deleteLocalFile(String filePath) {
        File deleteFile = new File(filePath);
        if (FileUtils.fileExists((File)deleteFile)) {
            return FileUtils.fileDelete((File)deleteFile);
        }
        return true;
    }

    public static boolean deleteLocalFileAndParentDir(String filePath) {
        return FileTransferHelper.deleteLocalFile(filePath) && FileTransferHelper.deleteLocalFile(FileTransferHelper.getParentDir(filePath));
    }

    public static void recursiveDelete(File dir) {
        if (FileUtils.fileExists((File)dir)) {
            for (File f : FileUtils.listFiles((File)dir)) {
                if (FileUtils.fileIsDirectory((File)f)) {
                    FileTransferHelper.recursiveDelete(f);
                    continue;
                }
                FileUtils.fileDelete((File)f);
            }
            FileUtils.fileDelete((File)dir);
        }
    }

    public boolean checkAccess(String path, boolean readOnly) {
        FileServiceMXBean fileService = this.getFileService();
        if (readOnly) {
            return FileServiceUtil.isPathContained((List)fileService.getReadList(), (String)path) || FileServiceUtil.isPathContained((List)fileService.getWriteList(), (String)path);
        }
        return FileServiceUtil.isPathContained((List)fileService.getWriteList(), (String)path);
    }

    private boolean expandArchive(String sourcePath, String targetPath) {
        FileServiceMXBean fileService = this.getFileService();
        return fileService.expandArchive(sourcePath, targetPath);
    }

    public static String getTempArchiveName(RESTRequest request, String path) {
        String archiveName = FileTransferHelper.getTempArchiveName(path);
        if (archiveName.endsWith("_original")) {
            String contentType = request.getContentType();
            archiveName = contentType != null && contentType.contains(FILE_TRANSFER_PAX_MIME) ? archiveName + ".pax" : archiveName + ".zip";
        }
        return archiveName;
    }

    protected static String getTempArchiveName(String path) {
        int indexDot = path.lastIndexOf(".");
        int indexFSlash = path.lastIndexOf("/");
        int indexBSlash = path.lastIndexOf("\\");
        if (indexDot == -1 || indexBSlash > indexDot || indexFSlash > indexDot) {
            return path + "_original";
        }
        return path.substring(0, indexDot) + "_original" + path.substring(indexDot);
    }

    public void writeResponseFromFile(String processedPath, RESTRequest request, RESTResponse response, boolean legacyFileTransfer) {
        this.writeResponseFromFile(processedPath, 0L, -1L, request, response, legacyFileTransfer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={FileNotFoundException.class})
    protected void writeResponseFromFile(String processedPath, long startOffset, long endOffset, RESTRequest request, RESTResponse response, boolean legacyFileTransfer) {
        OutputStream outStream = null;
        RandomAccessFile downloadFile = null;
        try {
            downloadFile = new RandomAccessFile(processedPath, RANDOM_FILE_ACCESS_READ_MODE);
            outStream = response.getOutputStream();
            if (legacyFileTransfer) {
                response.setContentType(FILE_TRANSFER_GZIP_MIME);
                outStream = new GZIPOutputStream(outStream, 8192);
            } else {
                String acceptEncoding = request.getHeader(HTTP_ACCEPT_ENCODING);
                String accept = request.getHeader(HTTP_ACCEPT);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Accept-Encoding: " + acceptEncoding + " | Accept: " + accept), (Object[])new Object[0]);
                }
                if (accept != null && !accept.contains("*/*") && !accept.contains(",")) {
                    response.setContentType(accept);
                } else {
                    response.setContentType(this.getMIMEType(processedPath));
                }
                if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                    response.setResponseHeader(HTTP_CONTENT_ENCODING, "gzip");
                    outStream = new GZIPOutputStream(outStream, 8192);
                }
            }
            if (startOffset < 0L) {
                startOffset = 0L;
            }
            downloadFile.seek(startOffset);
            byte[] buf = new byte[8192];
            if (endOffset <= -1L) {
                int bytesRead;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Transfer until the end of file is reached.", (Object[])new Object[0]);
                }
                while ((bytesRead = downloadFile.read(buf)) > 0) {
                    outStream.write(buf, 0, bytesRead);
                }
            } else {
                int bytesRead;
                int length;
                int bytesToRead = startOffset > endOffset ? 0 : (int)(endOffset - startOffset) + 1;
                int n = length = bytesToRead > 8192 ? 8192 : bytesToRead;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("initial : bytesToRead=" + bytesToRead + " : length=" + length), (Object[])new Object[0]);
                }
                while ((bytesRead = downloadFile.read(buf, 0, length)) > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("bytesToRead=" + bytesToRead + " : length=" + length + " : bytesRead=" + bytesRead), (Object[])new Object[0]);
                    }
                    outStream.write(buf, 0, bytesRead);
                    if ((bytesToRead -= bytesRead) > 0) {
                        if (bytesToRead >= 8192) continue;
                        length = bytesToRead;
                        continue;
                    }
                    break;
                }
            }
            outStream.flush();
        }
        catch (FileNotFoundException e2222222) {
            try {
                throw ErrorHelper.createRESTHandlerJsonException(e2222222, null, 400);
                catch (IOException e2222222) {
                    FFDCFilter.processException((Throwable)e2222222, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper", (String)"424", (Object)this, (Object[])new Object[]{processedPath, startOffset, endOffset, request, response, legacyFileTransfer});
                    throw ErrorHelper.createRESTHandlerJsonException(e2222222, null, 500);
                }
            }
            catch (Throwable throwable) {
                FileUtils.tryToClose(outStream);
                FileUtils.tryToClose((Closeable)downloadFile);
                throw throwable;
            }
        }
        FileUtils.tryToClose((Closeable)outStream);
        FileUtils.tryToClose((Closeable)downloadFile);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={FileNotFoundException.class})
    public void readRequestIntoFile(String processedPath, RESTRequest request, boolean legacyFileTransfer) {
        ServletRESTRequestWithParams req;
        String deployType;
        InputStream is = null;
        RandomAccessFile uploadFile = null;
        boolean nodeDeployment = false;
        if (request instanceof ServletRESTRequestWithParams && (deployType = (req = (ServletRESTRequestWithParams)request).getParam("deployService")) != null && "node.js".equals(deployType.trim())) {
            nodeDeployment = true;
        }
        try {
            int bytesRead;
            File parentFolder;
            String actionHeader = request.getHeader("com.ibm.websphere.jmx.connector.rest.postTransferAction");
            if ("com.ibm.websphere.jmx.connector.rest.postTransferAction.findServerName".equals(actionHeader) || nodeDeployment) {
                is = request.getPart("file");
                if (is == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"******************* Error InputStream is NULL **************************", (Object[])new Object[0]);
                }
            } else {
                is = request.getInputStream();
            }
            if (legacyFileTransfer) {
                is = new GZIPInputStream(is, 8192);
            }
            if (!FileUtils.fileExists((File)(parentFolder = new File(FileTransferHelper.getParentDir(processedPath))))) {
                FileUtils.fileMkDirs((File)parentFolder);
            }
            uploadFile = new RandomAccessFile(processedPath, RANDOM_FILE_ACCESS_READ_WRITE_MODE);
            byte[] buf = new byte[8192];
            long totalBytesRead = 0L;
            while ((bytesRead = is.read(buf)) > 0) {
                uploadFile.write(buf, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
            }
            uploadFile.setLength(totalBytesRead);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Size of new file [" + processedPath + "] = " + uploadFile.length()), (Object[])new Object[0]);
            }
        }
        catch (FileNotFoundException e2222222) {
            try {
                throw ErrorHelper.createRESTHandlerJsonException(e2222222, null, 400);
                catch (IOException e2222222) {
                    FFDCFilter.processException((Throwable)e2222222, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper", (String)"491", (Object)this, (Object[])new Object[]{processedPath, request, legacyFileTransfer});
                    throw ErrorHelper.createRESTHandlerJsonException(e2222222, null, 500);
                }
            }
            catch (Throwable throwable) {
                FileUtils.tryToClose(is);
                FileUtils.tryToClose(uploadFile);
                throw throwable;
            }
        }
        FileUtils.tryToClose((Closeable)is);
        FileUtils.tryToClose((Closeable)uploadFile);
    }

    public WsLocationAdmin getWsLocationAdmin() {
        WsLocationAdmin wsLocationAdmin = (WsLocationAdmin)this.wsLocationAdminRef.getService();
        if (wsLocationAdmin == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"WsLocationAdmin"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return wsLocationAdmin;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized FileServiceMXBean getFileService() {
        if (this.fileService == null) {
            try {
                this.fileService = JMX.newMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), new ObjectName("WebSphere:feature=restConnector,type=FileService,name=FileService"), FileServiceMXBean.class);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                void e;
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper", (String)"519", (Object)this, (Object[])new Object[0]);
                throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
            }
            catch (NullPointerException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper", (String)"521", (Object)this, (Object[])new Object[0]);
                throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
            }
        }
        return this.fileService;
    }

    public String getWritableLocation() {
        String writableLocation = this.getWsLocationAdmin().resolveString("${server.output.dir}/workarea/" + UUID.randomUUID() + "/");
        if (writableLocation == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"NO_WRITE_LOCATION", null, (String)"CWWKX0128E: There are no configured writable locations on the routing server."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 400);
        }
        return writableLocation;
    }

    public static String getFilename(String path) {
        int index;
        int n = index = path != null ? path.lastIndexOf("/") : -1;
        if (index == -1) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(FileTransferHelper.class, (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"PATH_NOT_VALID", (Object[])new String[]{path}, (String)("CWWKX0127E: The path " + path + " is not valid.")));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 400);
        }
        return path.substring(index + 1);
    }

    public static String processRoutingPathLight(String originalPath) {
        originalPath = FileTransferHelper.decodeFilePath(originalPath);
        return PathUtils.normalize((String)originalPath);
    }

    public String processRoutingPath(String originalPath, String targetHost, String targetServer, String targetUserDir) {
        String path = FileTransferHelper.processRoutingPathLight(originalPath);
        if (path == null || path.isEmpty() || !path.contains("$")) {
            return path;
        }
        if (path.charAt(path.length() - 1) == '}') {
            path = path + '/';
        }
        ServerPath symbolToResolve = null;
        if (path.contains(ServerPath.INSTALL_DIR.getSymbol())) {
            symbolToResolve = ServerPath.INSTALL_DIR;
        } else if (path.contains(ServerPath.USER_DIR.getSymbol())) {
            symbolToResolve = ServerPath.USER_DIR;
        } else if (path.contains(ServerPath.OUTPUT_DIR.getSymbol())) {
            symbolToResolve = ServerPath.OUTPUT_DIR;
        } else if (path.contains(ServerPath.CONFIG_DIR.getSymbol())) {
            symbolToResolve = ServerPath.CONFIG_DIR;
        } else if (path.contains(ServerPath.SHARED_CONFIG_DIR.getSymbol())) {
            symbolToResolve = ServerPath.SHARED_CONFIG_DIR;
        } else if (path.contains(ServerPath.SHARED_APPS_DIR.getSymbol())) {
            symbolToResolve = ServerPath.SHARED_APPS_DIR;
        } else if (path.contains(ServerPath.SHARED_RESC_DIR.getSymbol())) {
            symbolToResolve = ServerPath.SHARED_RESC_DIR;
        } else {
            return null;
        }
        return this.getRoutingHelper().processSymbolicRoutingPath(path, targetHost, targetServer, targetUserDir, symbolToResolve);
    }

    public void deleteInternal(String filePath, boolean recursive) {
        boolean deleted;
        String processedPath = this.processAndValidateFilePath(filePath, false);
        if (recursive) {
            File fileToDelete = new File(processedPath);
            if (FileUtils.fileIsDirectory((File)fileToDelete)) {
                FileTransferHelper.recursiveDelete(fileToDelete);
            } else {
                FileUtils.fileDelete((File)fileToDelete);
            }
            deleted = !FileUtils.fileExists((File)fileToDelete);
        } else {
            deleted = FileTransferHelper.deleteLocalFile(processedPath);
        }
        if (!deleted) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"DELETE_REQUEST_ERROR", null, (String)("CWWKX0126E: Delete request for file " + processedPath + " could not be completed.")));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 400);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"DELETE_REQUEST_COMPLETE_INFO", (Object[])new Object[]{processedPath});
        }
    }

    public void uploadInternal(RESTRequest request, String filePath, boolean expansion, boolean legacyFileTransfer) {
        String processedPath = this.processAndValidateFilePath(filePath, false);
        if (expansion) {
            String archivePath = FileTransferHelper.getTempArchiveName(request, processedPath);
            archivePath = FileTransferHelper.appendFilename(processedPath, FileTransferHelper.getFilename(archivePath));
            this.readRequestIntoFile(archivePath, request, legacyFileTransfer);
            if (!this.expandArchive(archivePath, processedPath)) {
                IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"UPLOAD_EXPANSION_ERROR", (Object[])new Object[]{processedPath}, (String)"CWWKX0129E: Uploaded archive could not be expanded."));
                throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
            }
            if (!FileTransferHelper.deleteLocalFile(archivePath) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Could not delete temporary file: " + archivePath), (Object[])new Object[0]);
            }
        } else {
            this.readRequestIntoFile(processedPath, request, legacyFileTransfer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"UPLOAD_REQUEST_COMPLETE_INFO", (Object[])new Object[]{processedPath});
        }
    }

    public void downloadInternal(RESTRequest request, RESTResponse response, String filePath, boolean legacyFileTransfer) {
        this.downloadInternal(request, response, filePath, 0L, -1L, legacyFileTransfer);
    }

    public void downloadInternal(RESTRequest request, RESTResponse response, String filePath, long startOffset, long endOffset, boolean legacyFileTransfer) {
        String processedPath = this.processAndValidateFilePath(filePath, true);
        this.writeResponseFromFile(processedPath, startOffset, endOffset, request, response, legacyFileTransfer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
            Tr.info((TraceComponent)tc, (String)"DOWNLOAD_REQUEST_COMPLETE_INFO", (Object[])new Object[]{processedPath});
        }
    }

    public void routedDeleteInternal(RESTRequest request, String filePath, boolean recursiveDelete) {
        this.getRoutingHelper().routedDeleteInternal(this, request, filePath, recursiveDelete);
    }

    public void routedUploadInternal(RESTRequest request, String filePath, boolean expansion, boolean legacyFileTransfer) {
        this.getRoutingHelper().routedUploadInternal(this, request, filePath, expansion, legacyFileTransfer);
    }

    public void routedDownloadInternal(RESTRequest request, RESTResponse response, String filePath, boolean legacyFileTransfer) {
        this.getRoutingHelper().routedDownloadInternal(this, request, response, filePath, legacyFileTransfer);
    }
}

