/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, service={VirtualHostListener.class}, property={"service.vendor=IBM"})
public class RESTAppListener
implements VirtualHostListener {
    private static final TraceComponent tc = Tr.register(RESTAppListener.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.RESTServerMessages");
    private static final String JMX_REST_ADDRESS = "com.ibm.ws.jmx.rest.address";
    private volatile BundleContext bContext = null;
    private volatile String appURL = null;
    private volatile WsLocationAdmin locationService;
    private volatile WsResource restJMXAddressWorkareaFile;
    private volatile WsResource restJMXAddressStateFile;
    private volatile String registeredContextRoot = null;
    private volatile VirtualHost secureVirtualHost = null;
    private volatile String secureAlias = null;
    private volatile ServiceRegistration<Object> jmxEndpointRegistration = null;
    static final long serialVersionUID = 7319694429706154405L;

    @Activate
    protected void activate(BundleContext bc) {
        this.bContext = bc;
    }

    @Deactivate
    protected void deactivate() {
        this.removeJMXAddressResource(this.restJMXAddressStateFile);
        this.removeJMXAddressResource(this.restJMXAddressWorkareaFile);
        if (this.jmxEndpointRegistration != null) {
            this.jmxEndpointRegistration.unregister();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeJMXAddressResource(WsResource remoteJMXAddressFile) {
        block6: {
            if (remoteJMXAddressFile != null) {
                try {
                    if (!remoteJMXAddressFile.delete()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Could not delete the JMX rest connector address file.", (Object[])new Object[0]);
                        }
                        return;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Successfully deleted the JMX rest connector address file.", (Object[])new Object[0]);
                    }
                }
                catch (SecurityException securityException) {
                    void se;
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.jmx.connector.server.rest.RESTAppListener", (String)"86", (Object)this, (Object[])new Object[]{remoteJMXAddressFile});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    Tr.event((TraceComponent)tc, (String)"Received a SecurityException while attemping to delete the JMX rest connector address file: ", (Object[])new Object[]{se});
                }
            }
        }
    }

    public void contextRootAdded(String contextRoot, VirtualHost virtualHost) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Added contextRoot {0} to virtual host {1}", (Object[])new Object[]{contextRoot, virtualHost.getName()});
        }
        if (contextRoot != null && contextRoot.contains("/IBMJMXConnectorREST") && "default_host".equals(virtualHost.getName())) {
            this.registeredContextRoot = contextRoot;
            if (this.secureVirtualHost == virtualHost) {
                this.createJMXWorkAreaResourceIfChanged(virtualHost);
            }
        }
    }

    public void contextRootRemoved(String contextRoot, VirtualHost virtualHost) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Removed contextRoot {0} from virtual host {1}", (Object[])new Object[]{contextRoot, virtualHost.getName()});
        }
        if (contextRoot != null && contextRoot.contains("/IBMJMXConnectorREST")) {
            this.registeredContextRoot = null;
        }
    }

    @Reference(service=VirtualHost.class, target="(&(enabled=true)(id=default_host)(httpsAlias=*))", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Set vhost: ", (Object[])new Object[]{vhost});
        }
        this.secureVirtualHost = vhost;
        this.secureAlias = props.get("httpsAlias").toString();
        this.createJMXWorkAreaResourceIfChanged(vhost);
    }

    protected void updatedVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Update vhost: ", (Object[])new Object[]{vhost});
        }
        this.secureAlias = props.get("httpsAlias").toString();
        this.createJMXWorkAreaResourceIfChanged(vhost);
    }

    protected void unsetVirtualHost(VirtualHost vhost) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Unset vhost: ", (Object[])new Object[]{vhost});
        }
        this.secureVirtualHost = null;
    }

    private synchronized void createJMXWorkAreaResourceIfChanged(VirtualHost vhost) {
        String newAppURLString;
        String contextRoot = this.registeredContextRoot;
        if (contextRoot != null && (newAppURLString = vhost.getUrlString(contextRoot, true)).startsWith("https")) {
            String oldAppURL = this.appURL;
            String newAppURL = RESTAppListener.processContextRootURL(newAppURLString);
            if (oldAppURL == null || !oldAppURL.equals(newAppURL)) {
                this.appURL = newAppURL;
                if (this.restJMXAddressWorkareaFile == null) {
                    this.restJMXAddressWorkareaFile = this.createJMXWorkAreaResource(this.locationService);
                } else {
                    this.createJmxAddressResource(this.restJMXAddressWorkareaFile);
                }
                if (this.restJMXAddressStateFile == null) {
                    this.restJMXAddressStateFile = this.createJMXStateResource(this.locationService);
                } else {
                    this.createJmxAddressResource(this.restJMXAddressStateFile);
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("name", "JMXConnectorEndpoint");
                props.put("jmxHost", vhost.getHostName(this.secureAlias));
                props.put("jmxPort", vhost.getSecureHttpPort(this.secureAlias));
                props.put("jmxAlias", this.secureAlias);
                if (this.jmxEndpointRegistration == null) {
                    this.jmxEndpointRegistration = this.bContext.registerService(Object.class, (Object)this, props);
                } else {
                    this.jmxEndpointRegistration.setProperties(props);
                }
            }
        }
    }

    private static String processContextRootURL(String contextRootURL) {
        StringBuilder b = new StringBuilder(contextRootURL);
        if (contextRootURL.endsWith("/*")) {
            b.delete(b.length() - 2, b.length());
        } else if (contextRootURL.endsWith("/")) {
            b.deleteCharAt(b.length() - 1);
        }
        if (contextRootURL.startsWith("https")) {
            b.replace(0, "https".length(), "service:jmx:rest");
        } else if (contextRootURL.startsWith("http")) {
            b.replace(0, "http".length(), "service:jmx:rest");
        } else {
            b.insert(0, "service:jmx:rest://");
        }
        return b.toString();
    }

    @Reference(service=WsLocationAdmin.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setLocationService(WsLocationAdmin locationService) {
        this.locationService = locationService;
        if (this.restJMXAddressWorkareaFile == null) {
            this.restJMXAddressWorkareaFile = this.createJMXWorkAreaResource(locationService);
        }
        if (this.restJMXAddressStateFile == null) {
            this.restJMXAddressStateFile = this.createJMXStateResource(locationService);
        }
    }

    protected void unsetLocationService(WsLocationAdmin locationService) {
        if (this.locationService == locationService) {
            this.locationService = null;
        }
    }

    private synchronized WsResource createJMXStateResource(WsLocationAdmin locationAdmin) {
        WsResource resource = locationAdmin.resolveResource("${server.state.dir}/com.ibm.ws.jmx.rest.address");
        return this.createJmxAddressResource(resource);
    }

    private synchronized WsResource createJMXWorkAreaResource(WsLocationAdmin locationAdmin) {
        WsResource resource = locationAdmin.getServerWorkareaResource(JMX_REST_ADDRESS);
        return this.createJmxAddressResource(resource);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized WsResource createJmxAddressResource(WsResource resource) {
        if (this.appURL != null && this.locationService != null) {
            try {
                if (!resource.exists()) {
                    resource.create();
                }
                OutputStream os = resource.putStream();
                os.write(this.appURL.getBytes("UTF-8"));
                os.flush();
                os.close();
                Tr.info((TraceComponent)tc, (String)"JMX_REST_ADDRESS", (Object[])new Object[]{this.appURL});
                return resource;
            }
            catch (IOException os) {
                void ioe;
                FFDCFilter.processException((Throwable)os, (String)"com.ibm.ws.jmx.connector.server.rest.RESTAppListener", (String)"285", (Object)this, (Object[])new Object[]{resource});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received IOException while writting address to file: ", (Object[])new Object[]{ioe});
                }
                FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"createJMXWorkAreaResourceIO");
            }
            catch (SecurityException ioe) {
                void se;
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.jmx.connector.server.rest.RESTAppListener", (String)"291", (Object)this, (Object[])new Object[]{resource});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received SecurityException while writting address to file: ", (Object[])new Object[]{se});
                }
                FFDCFilter.processException((Throwable)se, (String)this.getClass().getName(), (String)"createJMXWorkAreaResourceSec");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Connector address was null, so we can't write the address to a file.", (Object[])new Object[0]);
        }
        return null;
    }
}

