/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.async.osgi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ejbcontainer.async.osgi.internal.RemoteAsyncResultImpl;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public final class RemoteAsyncResultReaper
implements Runnable {
    private static final TraceComponent tc = Tr.register(RemoteAsyncResultReaper.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final ScheduledExecutorService ivScheduledExecutor;
    private final LinkedHashSet<RemoteAsyncResultImpl> ivAllRemoteAsyncResults;
    private int ivMaxUnclaimedResults;
    private int ivNearMaxResultsThreshold;
    private int ivSafeResultsThreshold;
    private long ivFutureObjectTimeoutMillis;
    private boolean ivWarnedNearMax;
    private boolean ivWarnedExceededMax;
    private static final long MINIMUM_ALARM_INTERVAL_MILLIS = 1000L;
    private long ivAlarmIntervalMillis;
    private boolean ivIsCanceled = false;
    private Future<?> ivFuture;
    static final long serialVersionUID = -4385564368455654575L;

    public RemoteAsyncResultReaper(ScheduledExecutorService scheduledExecutor) {
        this.ivScheduledExecutor = scheduledExecutor;
        this.ivAllRemoteAsyncResults = new LinkedHashSet();
    }

    public synchronized void configure(long unclaimedResultTimeoutMillis, int maxUnclaimedResults) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("configure: unclaimedResultTimeoutMillis=" + unclaimedResultTimeoutMillis + ", maxUnclaimedResults=" + maxUnclaimedResults), (Object[])new Object[0]);
        }
        this.ivFutureObjectTimeoutMillis = unclaimedResultTimeoutMillis;
        this.ivAlarmIntervalMillis = Math.max(1000L, this.ivFutureObjectTimeoutMillis);
        this.ivMaxUnclaimedResults = maxUnclaimedResults;
        this.ivNearMaxResultsThreshold = maxUnclaimedResults / 2 + maxUnclaimedResults / 4;
        this.ivSafeResultsThreshold = maxUnclaimedResults / 2;
        int size = this.ivAllRemoteAsyncResults.size();
        if (size > maxUnclaimedResults) {
            int excess = size - maxUnclaimedResults;
            Iterator iterator = this.ivAllRemoteAsyncResults.iterator();
            for (int i = 0; i < excess; ++i) {
                RemoteAsyncResultImpl oldest = (RemoteAsyncResultImpl)((Object)iterator.next());
                this.releaseResources(oldest);
                iterator.remove();
            }
            this.ivWarnedNearMax = false;
            this.ivWarnedExceededMax = false;
        }
    }

    @Override
    @ManualTrace
    public synchronized void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("run: size=" + this.ivAllRemoteAsyncResults.size()), (Object[])new Object[0]);
        }
        if (this.ivIsCanceled) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run: cancelled");
            }
            return;
        }
        this.ivFuture = null;
        int numRemoved = 0;
        if (!this.ivAllRemoteAsyncResults.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            Iterator iterator = this.ivAllRemoteAsyncResults.iterator();
            while (iterator.hasNext()) {
                RemoteAsyncResultImpl asyncResult = (RemoteAsyncResultImpl)((Object)iterator.next());
                long staleDuration = currentTime - asyncResult.getTimeoutStartTime();
                if (staleDuration >= this.ivFutureObjectTimeoutMillis) {
                    this.releaseResources(asyncResult);
                    iterator.remove();
                    ++numRemoved;
                    continue;
                }
                long alarmTime = Math.max(this.ivFutureObjectTimeoutMillis - staleDuration, 1000L);
                this.ivFuture = this.ivScheduledExecutor.schedule(this, alarmTime, TimeUnit.MILLISECONDS);
                if (!isTraceOn || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("next " + (Object)((Object)asyncResult) + "; alarm=" + alarmTime), (Object[])new Object[0]);
                break;
            }
            if (this.ivWarnedNearMax) {
                int size = this.ivAllRemoteAsyncResults.size();
                this.ivWarnedNearMax &= size >= this.ivSafeResultsThreshold;
                this.ivWarnedExceededMax &= size >= this.ivNearMaxResultsThreshold;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("run: size=" + this.ivAllRemoteAsyncResults.size() + ", removed=" + numRemoved));
        }
    }

    @ManualTrace
    public synchronized void finalReap() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("finalReap : Remote Async Results = " + this.ivAllRemoteAsyncResults.size()), (Object[])new Object[0]);
        }
        if (this.ivFuture != null) {
            this.ivIsCanceled = true;
            this.ivFuture.cancel(false);
            this.ivFuture = null;
        }
        Iterator iterator = this.ivAllRemoteAsyncResults.iterator();
        while (iterator.hasNext()) {
            RemoteAsyncResultImpl asyncResult = (RemoteAsyncResultImpl)((Object)iterator.next());
            this.releaseResources(asyncResult);
            iterator.remove();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finalReap : Remote Async Results = " + this.ivAllRemoteAsyncResults.size()));
        }
    }

    public synchronized void add(RemoteAsyncResultImpl asyncResult) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        this.ivAllRemoteAsyncResults.add(asyncResult);
        if (asyncResult.ivPmiBean != null) {
            asyncResult.ivPmiBean.asyncFutureObjectIncrement();
        }
        int size = this.ivAllRemoteAsyncResults.size();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add " + (Object)((Object)asyncResult) + "; size=" + size), (Object[])new Object[0]);
        }
        if (size == 1) {
            this.ivFuture = this.ivScheduledExecutor.schedule(this, this.ivAlarmIntervalMillis, TimeUnit.MILLISECONDS);
        } else if (size >= this.ivNearMaxResultsThreshold) {
            boolean warn = false;
            if (size > this.ivMaxUnclaimedResults) {
                if (!this.ivWarnedExceededMax) {
                    this.ivWarnedExceededMax = true;
                    warn = true;
                }
                Iterator iterator = this.ivAllRemoteAsyncResults.iterator();
                RemoteAsyncResultImpl oldest = (RemoteAsyncResultImpl)((Object)iterator.next());
                this.releaseResources(oldest);
                iterator.remove();
            } else if (!this.ivWarnedNearMax) {
                this.ivWarnedNearMax = true;
                warn = true;
            }
            if (warn) {
                Tr.warning((TraceComponent)tc, (String)"MAXIMUM_UNCLAIMED_ASYNC_RESULTS_CNTR0328W", (Object[])new Object[]{size, this.ivMaxUnclaimedResults});
            }
        }
    }

    public synchronized void remove(RemoteAsyncResultImpl asyncResult) {
        this.ivAllRemoteAsyncResults.remove((Object)asyncResult);
        this.releaseResources(asyncResult);
        if (this.ivAllRemoteAsyncResults.isEmpty() && this.ivFuture != null) {
            this.ivFuture.cancel(false);
            this.ivFuture = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("remove " + (Object)((Object)asyncResult) + "; size=" + this.ivAllRemoteAsyncResults.size()), (Object[])new Object[0]);
        }
    }

    private void releaseResources(RemoteAsyncResultImpl asyncResult) {
        asyncResult.unexportObject();
        if (asyncResult.ivPmiBean != null) {
            asyncResult.ivPmiBean.asyncFutureObjectDecrement();
        }
    }
}

