/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.concurrent.persistent.PersistentExecutor;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.internal.ApplicationTracker;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.security.AccessController;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class PersistentExecutorIntrospector
implements Introspector {
    static final long serialVersionUID = 8830294504352955642L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public String getIntrospectorName() {
        return "PersistentExecutorIntrospector";
    }

    @Trivial
    public String getIntrospectorDescription() {
        return "Persistent timers/tasks diagnostics";
    }

    public void introspect(PrintWriter out) throws Exception {
        SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
        BundleContext bundleContext = priv.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
        for (ServiceReference ref : priv.getServiceReferences(bundleContext, PersistentExecutor.class, "(!(com.ibm.wsspi.resource.ResourceFactory=true))")) {
            PersistentExecutorImpl executor = (PersistentExecutorImpl)priv.getService(bundleContext, ref);
            if (executor == null) {
                String name;
                String displayId = (String)ref.getProperty("config.displayId");
                String string = name = displayId.contains("]/persistentExecutor[") ? displayId : (String)ref.getProperty("id");
                if (name == null) {
                    name = (String)ref.getProperty("jndiName");
                }
                out.println("PersistentExecutor " + name + " is not available");
                out.println("Properties: " + ref.getProperties());
                out.println();
                continue;
            }
            executor.introspect(out);
        }
        ServiceReference appTrackerRef = bundleContext.getServiceReference(ApplicationTracker.class);
        bundleContext.getService(appTrackerRef);
        ApplicationTracker appTracker = (ApplicationTracker)priv.getService(bundleContext, ApplicationTracker.class);
        appTracker.introspect(out);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.persistent.internal.PersistentExecutorIntrospector", PersistentExecutorIntrospector.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
    }
}

