/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.lumberjack;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.lumberjack.LumberjackEvent;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LumberjackClient {
    private static final TraceComponent tc = Tr.register(LumberjackClient.class, null, null);
    private static TraceNLS nls = TraceNLS.getTraceNLS(LumberjackClient.class, (String)"com.ibm.ws.collector.internal.resources.LoggingMessages");
    protected final String UTF_8 = "UTF-8";
    private static final String PROTOCOL_VERSION = "1";
    private static final String DATA_FRAME_TYPE = "D";
    private static final String COMPRESS_FRAME_TYPE = "C";
    private static final String WINDOW_SIZE_FRAME_TYPE = "W";
    private final SSLHelper sslHelper;
    private static final long MAX_KEEPALIVE = 10000L;
    private long lastUsedTime;
    private int seqNumber;
    private final Deflater deflater;
    protected BufferedInputStream in;
    protected BufferedOutputStream out;
    static final long serialVersionUID = 6103721744716829979L;

    public LumberjackClient(String sslConfig, SSLSupport sslSupport) throws SSLException {
        this.sslHelper = new SSLHelper(sslSupport, sslConfig);
        this.seqNumber = 1;
        this.deflater = new Deflater(6);
    }

    public void connect(String hostName, int port) throws UnknownHostException, IOException {
        if (!this.sslHelper.isSocketAvailable()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("creating/recreating socket connection to " + hostName + ":" + port), (Object[])new Object[0]);
            }
            SSLSocket socket = this.sslHelper.createSocket(hostName, port);
            this.in = new BufferedInputStream(socket.getInputStream());
            this.out = new BufferedOutputStream(socket.getOutputStream());
            this.seqNumber = 1;
            this.lastUsedTime = System.currentTimeMillis();
        }
    }

    public boolean isConnectionStale() {
        if (this.lastUsedTime == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long timeSinceLastUse = currentTime - this.lastUsedTime;
        return timeSinceLastUse > 10000L;
    }

    public boolean isSocketAvailable() {
        return this.sslHelper.isSocketAvailable();
    }

    public void close() throws IOException {
        if (this.sslHelper.isSocketAvailable()) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            finally {
                this.sslHelper.closeSocket();
            }
        }
    }

    public void writeWindowFrame(int windowSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(PROTOCOL_VERSION.getBytes("UTF-8"));
        output.write(WINDOW_SIZE_FRAME_TYPE.getBytes("UTF-8"));
        output.write(ByteBuffer.allocate(4).putInt(windowSize).array());
        this.lastUsedTime = System.currentTimeMillis();
        this.out.write(output.toByteArray());
        this.out.flush();
    }

    public void writeFrame(byte[] frame) throws IOException {
        this.lastUsedTime = System.currentTimeMillis();
        this.out.write(frame);
        this.out.flush();
    }

    public void readAckFrame() throws IOException {
        byte[] buffer = new byte[6];
        int bytesReceived = 0;
        while ((bytesReceived += this.in.read(buffer, bytesReceived, buffer.length - bytesReceived)) != -1) {
            String frameType;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Ack - total bytes received = " + bytesReceived), (Object[])new Object[0]);
            }
            if (bytesReceived != 6) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ack - buffer = ", (Object[])new Object[]{buffer});
            }
            if ((frameType = new String(Arrays.copyOfRange(buffer, 1, 2), "UTF-8")).equals("A")) {
                int sequenceNumber = ByteBuffer.wrap(Arrays.copyOfRange(buffer, 2, 6)).getInt();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Ack - received sequence number = " + sequenceNumber + " expecting sequence number = " + (this.seqNumber - 1)), (Object[])new Object[0]);
                }
                if (sequenceNumber >= this.seqNumber - 1) {
                    break;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Ack - unknown frame type " + frameType), (Object[])new Object[0]);
            }
            bytesReceived = 0;
            buffer = new byte[6];
        }
    }

    public byte[] createDataFrames(List<Object> dataObjects) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (int i = 0; i < dataObjects.size(); ++i) {
            ByteArrayOutputStream dataObjectStream = new ByteArrayOutputStream();
            LumberjackEvent dataObject = (LumberjackEvent)dataObjects.get(i);
            dataObjectStream.write(PROTOCOL_VERSION.getBytes("UTF-8"));
            dataObjectStream.write(DATA_FRAME_TYPE.getBytes("UTF-8"));
            dataObjectStream.write(ByteBuffer.allocate(4).putInt(this.seqNumber++).array());
            dataObjectStream.write(ByteBuffer.allocate(4).putInt(dataObject.size()).array());
            for (int j = 0; j < dataObject.size(); ++j) {
                LumberjackEvent.Entry entry = dataObject.get(j);
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                byte[] keyBytes = key.getBytes("UTF-8");
                byte[] valueBytes = value.getBytes("UTF-8");
                dataObjectStream.write(ByteBuffer.allocate(4).putInt(keyBytes.length).array());
                dataObjectStream.write(keyBytes);
                dataObjectStream.write(ByteBuffer.allocate(4).putInt(valueBytes.length).array());
                dataObjectStream.write(valueBytes);
            }
            output.write(dataObjectStream.toByteArray());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("created data frame for " + dataObjects.size() + " events - last sequence number used = " + (this.seqNumber - 1)), (Object[])new Object[0]);
        }
        return output.toByteArray();
    }

    public byte[] createCompressedFrame(byte[] dataFrames) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(dataFrames);
        byte[] cBytes = new byte[output.size()];
        this.deflater.setInput(output.toByteArray());
        this.deflater.finish();
        int compressedLength = this.deflater.deflate(cBytes);
        this.deflater.reset();
        output.reset();
        output.write(PROTOCOL_VERSION.getBytes("UTF-8"));
        output.write(COMPRESS_FRAME_TYPE.getBytes("UTF-8"));
        output.write(ByteBuffer.allocate(4).putInt(compressedLength).array());
        output.write(Arrays.copyOf(cBytes, compressedLength));
        return output.toByteArray();
    }

    @InjectedFFDC
    public static class SSLHelper {
        private static final TraceComponent tc = Tr.register(SSLHelper.class);
        private final SSLSocketFactory sslSocketFactory;
        private SSLSocket socket;
        private static final int SOCKET_CONNECT_TIMEOUT = 5000;
        static final long serialVersionUID = 7199402167220364078L;

        public SSLHelper(SSLSupport sslSupport, String sslConfigName) throws SSLException {
            JSSEHelper jsseHelper = sslSupport.getJSSEHelper();
            if (!(sslConfigName != null && jsseHelper.doesSSLConfigExist(sslConfigName) || jsseHelper.doesSSLConfigExist("defaultSSLConfig"))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSL config doesnt exist, no default config to fall back on", (Object[])new Object[]{this, sslConfigName});
                }
                throw new SSLException(nls.getString("SSLREF_NOTFOUND"));
            }
            SSLContext sslContext = jsseHelper.getSSLContext(sslConfigName, null, null);
            this.sslSocketFactory = sslContext.getSocketFactory();
        }

        public SSLSocket createSocket(String host, int port) throws UnknownHostException, IOException {
            this.socket = (SSLSocket)this.sslSocketFactory.createSocket();
            this.socket.connect(new InetSocketAddress(host, port), 5000);
            this.socket.startHandshake();
            return this.socket;
        }

        public boolean isSocketAvailable() {
            return this.socket != null && !this.socket.isClosed();
        }

        public void closeSocket() throws IOException {
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }
}

