/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.openid20.OpenidClientConfig;
import com.ibm.ws.security.openid20.tai.ClientAuthnData;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.ws.webcontainer.security.openid20.OpenidClientService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenidTAI
implements TrustAssociationInterceptor {
    private static final TraceComponent tc = Tr.register(OpenidTAI.class, null, null);
    static final String openid_identifier = "openid_identifier";
    public static final String KEY_OPENID_CLIENT_CONFIG = "openidClientConfig";
    public static final String KEY_OPENID_CLIENT_SERVICE = "openidClientService";
    public static final String KEY_SECURITY_SERVICE = "securityService";
    public static final String KEY_FILTER = "authenticationFilter";
    protected final AtomicServiceReference<OpenidClientConfig> openidClientConfigRef = new AtomicServiceReference("openidClientConfig");
    private final AtomicServiceReference<OpenidClientService> openIdClientServiceRef = new AtomicServiceReference("openidClientService");
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    protected final ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef = new ConcurrentServiceReferenceMap("authenticationFilter");
    private WebProviderAuthenticatorHelper authHelper;
    static final long serialVersionUID = 302308549612212877L;

    protected void activate(ComponentContext componentContext, Map<String, Object> newProperties) {
        this.openidClientConfigRef.activate(componentContext);
        this.openIdClientServiceRef.activate(componentContext);
        this.securityServiceRef.activate(componentContext);
        this.authFilterServiceRef.activate(componentContext);
        this.authHelper = new WebProviderAuthenticatorHelper(this.securityServiceRef);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("authHelper:" + this.authHelper), (Object[])new Object[0]);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.openidClientConfigRef.deactivate(componentContext);
        this.openIdClientServiceRef.deactivate(componentContext);
        this.securityServiceRef.deactivate(componentContext);
        this.authFilterServiceRef.deactivate(componentContext);
    }

    protected void setOpenidClientConfig(ServiceReference<OpenidClientConfig> ref) {
        this.openidClientConfigRef.setReference(ref);
    }

    protected void updatedOpenidClientConfig(ServiceReference<OpenidClientConfig> ref) {
        this.openidClientConfigRef.setReference(ref);
    }

    protected void unsetOpenidClientConfig(ServiceReference<OpenidClientConfig> ref) {
        this.openidClientConfigRef.unsetReference(ref);
    }

    protected void setOpenidClientService(ServiceReference<OpenidClientService> ref) {
        this.openIdClientServiceRef.setReference(ref);
    }

    protected void unsetOpenidClientService(ServiceReference<OpenidClientService> ref) {
        this.openIdClientServiceRef.unsetReference(ref);
    }

    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.unsetReference(ref);
    }

    protected void setAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAuthenticationFilter id:" + ref.getProperty("id")), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.putReference((Object)((String)ref.getProperty("id")), ref);
    }

    protected void updatedAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatedAuthenticationFilter id:" + ref.getProperty("id")), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.putReference((Object)((String)ref.getProperty("id")), ref);
    }

    protected void unsetAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetAuthenticationFilter id:" + ref.getProperty("id")), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.removeReference((Object)((String)ref.getProperty("id")), ref);
    }

    public void cleanup() {
    }

    public String getType() {
        return "OpenidTAI";
    }

    public String getVersion() {
        return "1.0";
    }

    public int initialize(Properties props) throws WebTrustAssociationFailedException {
        return 0;
    }

    public boolean isTargetInterceptor(HttpServletRequest req) throws WebTrustAssociationException {
        OpenidClientConfig openidClientConfig = (OpenidClientConfig)this.openidClientConfigRef.getService();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("openidClientConfig:(" + openidClientConfig + ")"), (Object[])new Object[0]);
        }
        if (openidClientConfig == null) {
            return false;
        }
        String authFilterId = openidClientConfig.getAuthFilterId();
        if (authFilterId != null && authFilterId.length() > 0) {
            AuthenticationFilter authFilter = (AuthenticationFilter)this.authFilterServiceRef.getService((Object)authFilterId);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authFilter id:" + authFilterId + " authFilter:" + authFilter), (Object[])new Object[0]);
            }
            if (authFilter != null && !authFilter.isAccepted(req)) {
                return false;
            }
        }
        String providerIdentifier = openidClientConfig.getProviderIdentifier();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("providerIdentifier(openid_identifier):(" + providerIdentifier + ")"), (Object[])new Object[0]);
        }
        return providerIdentifier != null && !providerIdentifier.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest request, HttpServletResponse response) throws WebTrustAssociationFailedException {
        OpenidClientConfig openidClientConfig = (OpenidClientConfig)this.openidClientConfigRef.getService();
        String providerIdentifier = openidClientConfig.getProviderIdentifier();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("negotiateValidate...(" + providerIdentifier + ")"), (Object[])new Object[0]);
        }
        OpenidClientService openIdClientService = (OpenidClientService)this.openIdClientServiceRef.getService();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("openIdClientService:" + openIdClientService), (Object[])new Object[0]);
        }
        try {
            if (openIdClientService != null) {
                if (openIdClientService.getRpRequestIdentifier(request, response) != null) {
                    ProviderAuthenticationResult result = openIdClientService.verifyOpResponse(request, response);
                    if (result.getStatus() != AuthResult.SUCCESS) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("verify failed:" + result), (Object[])new Object[0]);
                        }
                        return TAIResult.create((int)403);
                    }
                    AuthenticationResult authResult = this.authHelper.loginWithUserName(request, response, result.getUserName(), result.getSubject(), result.getCustomProperties(), openIdClientService.isMapIdentityToRegistryUser());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("authHelper authResult:" + authResult), (Object[])new Object[0]);
                    }
                    if (authResult.getStatus() == AuthResult.SUCCESS) {
                        Subject subject = authResult.getSubject();
                        return TAIResult.create((int)200, (String)this.getUserName(subject), (Subject)subject);
                    }
                    return TAIResult.create((int)403);
                }
                TAIResult basicAuthResult = this.basicAuthorizationHeader(request, response);
                if (basicAuthResult.getStatus() == 100) {
                    request.setAttribute(openid_identifier, (Object)providerIdentifier);
                    openIdClientService.createAuthRequest(request, response);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"... expect to be redirected by the browser", (Object[])new Object[0]);
                    }
                    return TAIResult.create((int)403);
                }
                return basicAuthResult;
            }
        }
        catch (Exception basicAuthResult) {
            FFDCFilter.processException((Throwable)basicAuthResult, (String)"com.ibm.ws.security.openid20.tai.OpenidTAI", (String)"251", (Object)this, (Object[])new Object[]{request, response});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"negotiateValidateandEstablishTrust() get Exception", (Object[])new Object[]{e});
            }
            return TAIResult.create((int)500);
        }
        return TAIResult.create((int)100);
    }

    /*
     * WARNING - void declaration
     */
    protected TAIResult basicAuthorizationHeader(HttpServletRequest request, HttpServletResponse response) throws WebTrustAssociationFailedException {
        ClientAuthnData authData;
        OpenidClientConfig openidClientConfig = (OpenidClientConfig)this.openidClientConfigRef.getService();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("basicAuthorizationHeader:(" + openidClientConfig + ")"), (Object[])new Object[0]);
        }
        if (openidClientConfig != null && openidClientConfig.allowBasicAuthentication() && (authData = new ClientAuthnData(request, response)).hasAuthnData()) {
            String error;
            block7: {
                error = "Username and password do not match";
                try {
                    WebAuthenticator basicAuthenticator = this.getBasicAuthenticator();
                    AuthenticationResult authResult = basicAuthenticator.authenticate(request, response, null);
                    AuthResult result = authResult.getStatus();
                    if (result.equals((Object)AuthResult.SUCCESS)) {
                        return TAIResult.create((int)200, (String)authResult.getUserName(), (Subject)authResult.getSubject());
                    }
                }
                catch (Exception basicAuthenticator) {
                    void e;
                    FFDCFilter.processException((Throwable)basicAuthenticator, (String)"com.ibm.ws.security.openid20.tai.OpenidTAI", (String)"281", (Object)this, (Object[])new Object[]{request, response});
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("Failed to authenticate using basic auth token " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            if (!openidClientConfig.isTryOpenIDIfBasicAuthFails()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("user authentication for " + authData.getUserName() + " failed... No attemping openid"), (Object[])new Object[0]);
                }
                response.addHeader("WWW-Authenticate", "Basic error=" + error);
                return TAIResult.create((int)403);
            }
        }
        return TAIResult.create((int)100);
    }

    public WebAuthenticator getBasicAuthenticator() {
        WebAppSecurityConfig webAppSecurityConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        WebAuthenticatorProxy authenticatorProxy = webAppSecurityConfig.createWebAuthenticatorProxy();
        return authenticatorProxy.getBasicAuthAuthenticator();
    }

    public String getUserName(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Principal> principals = subject.getPrincipals();
        Iterator<Principal> principalsIterator = principals.iterator();
        if (principalsIterator.hasNext()) {
            Principal principal = principalsIterator.next();
            return principal.getName();
        }
        return null;
    }
}

