/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Version
implements Comparable<Version>,
Externalizable,
Cloneable {
    private static final long serialVersionUID = 918567830801402389L;
    private int[] _components;
    private boolean _readOnly = true;

    public Version(String ver) {
        String quote = "\"";
        ver = ver.replace(quote, "");
        String[] componentsOfVersion = ver.trim().split("\\.");
        this._components = new int[componentsOfVersion.length];
        for (int i = 0; i < componentsOfVersion.length; ++i) {
            this._components[i] = Integer.parseInt(componentsOfVersion[i]);
        }
    }

    public Version(int[] ver) {
        this._components = new int[ver.length];
        System.arraycopy(ver, 0, this._components, 0, ver.length);
    }

    public Version() {
        this._readOnly = false;
    }

    @Override
    public int compareTo(Version ver) {
        block6: {
            int j;
            int mylen = this._components.length;
            int[] otherComponents = ver._components;
            int otherlen = otherComponents.length;
            boolean longer = mylen < otherlen;
            int minLen = longer ? mylen : otherlen;
            int i = 0;
            for (i = 0; i < minLen; ++i) {
                int firstVal = this._components[i];
                int secondVal = otherComponents[i];
                if (firstVal < secondVal) {
                    return -1;
                }
                if (firstVal <= secondVal) continue;
                return 1;
            }
            if (mylen == otherlen) break block6;
            if (longer) {
                for (j = i + 1; j < otherlen; ++j) {
                    if (otherComponents[j] == 0) continue;
                    return -1;
                }
            } else {
                for (j = i + 1; j < mylen; ++j) {
                    if (this._components[j] == 0) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    public int hashCode() {
        int result = 0;
        for (int i : this._components) {
            result += i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Version) {
            return this.compareTo((Version)obj) == 0;
        }
        return false;
    }

    public int getMajorVersion() {
        return this._components[0];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i : this._components) {
            builder.append(i);
            builder.append('.');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public int[] toComponents() {
        int[] ver = new int[this._components.length];
        System.arraycopy(this._components, 0, ver, 0, this._components.length);
        return ver;
    }

    public Version clone() {
        return new Version(this._components);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(918567830801402389L);
        out.writeInt(this._components.length);
        for (int i : this._components) {
            out.writeInt(i);
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this._readOnly) {
            throw new IOException();
        }
        this._readOnly = true;
        in.readLong();
        int length = in.readInt();
        int[] components = new int[length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = in.readInt();
        }
        this._components = components;
    }
}

