/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.artifact.zip.cache.ZipCachingProperties;
import com.ibm.ws.artifact.zip.cache.ZipCachingService;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.cache.internal.ZipFileHandleImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipCachingServiceImpl
implements ZipCachingService {
    private static final Integer zipFileHandlesLock;
    private static final LinkedHashMap<String, ZipFileHandle> zipFileHandles;
    private static final DateFormat INTROSPECT_STAMP_FORMAT;
    static final long serialVersionUID = 4342330900837834943L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    @Trivial
    public ZipFileHandle openZipFile(String path) throws IOException {
        return ZipCachingServiceImpl.getZipFileHandle(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ZipFileHandle getZipFileHandle(String path) throws IOException {
        Integer n = zipFileHandlesLock;
        synchronized (n) {
            ZipFileHandle handle = zipFileHandles.get(path);
            if (handle == null) {
                handle = new ZipFileHandleImpl(path);
                zipFileHandles.put(path, handle);
            }
            return handle;
        }
    }

    public void introspect(PrintWriter output) {
        long introspectAt = System.nanoTime();
        Date currentTime = new Date();
        output.println("Zip Caching Service:");
        output.println("  [ " + INTROSPECT_STAMP_FORMAT.format(currentTime) + " ]");
        ZipCachingServiceImpl.introspectProperties(output);
        ZipCachingServiceImpl.introspectHandles(output);
        ZipFileHandleImpl.introspectZipReaper(output, introspectAt);
        output.println();
        output.println("------------------------------------------------------------");
    }

    protected static void introspectProperties(PrintWriter output) {
        output.println();
        output.println("Format:");
        output.println("  [ Property name ] [ Value ] [[ Default value ]] (units)");
        output.println();
        output.println("Entry Cache Settings:");
        output.println();
        ZipCachingServiceImpl.introspectProperty(output, "Maximum Handles", "zip.cache.handle.max", ZipCachingProperties.ZIP_CACHE_HANDLE_MAX, 255, "handles");
        ZipCachingServiceImpl.introspectProperty(output, "Maximum Entries", "zip.cache.entry.limit", ZipCachingProperties.ZIP_CACHE_ENTRY_LIMIT, 8192, "cached entries");
        ZipCachingServiceImpl.introspectProperty(output, "Maximum Entry Size", "zip.cache.entry.max", ZipCachingProperties.ZIP_CACHE_ENTRY_MAX, 16, "cached entry bytes");
        output.println();
        output.println("Zip Reaper Settings:");
        output.println();
        ZipCachingServiceImpl.introspectProperty(output, "Maximum pending closes", "zip.reaper.max.pending", ZipCachingProperties.ZIP_CACHE_REAPER_MAX_PENDING, 255, "pending closes");
        ZipCachingServiceImpl.introspectProperty(output, "Fast pending minimum", "zip.reaper.quick.pend.min", ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MIN, 10000000L, "ns");
        ZipCachingServiceImpl.introspectProperty(output, "Fast pending maximum", "zip.reaper.quick.pend.max", ZipCachingProperties.ZIP_CACHE_REAPER_QUICK_PEND_MAX, 20000000L, "ns");
        ZipCachingServiceImpl.introspectProperty(output, "Slow pending minimum", "zip.reaper.slow.pend.min", ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MIN, 100000000L, "ns");
        ZipCachingServiceImpl.introspectProperty(output, "Slow pending maximum", "zip.reaper.slow.pend.max", ZipCachingProperties.ZIP_CACHE_REAPER_SLOW_PEND_MAX, 200000000L, "ns");
        ZipCachingServiceImpl.introspectProperty(output, "State debugging", "zip.reaper.debug.state", ZipCachingProperties.ZIP_REAPER_DEBUG_STATE ? "enabled" : "disabled", "disabled", "enabled/disabled");
        ZipCachingServiceImpl.introspectProperty(output, "Collect timings", "zip.reaper.collect.timings", ZipCachingProperties.ZIP_REAPER_COLLECT_TIMINGS, false, "true/false");
    }

    protected static void introspectProperty(PrintWriter output, String propertyDescription, String propertyName, Object propertyValue, Object propertyDefaultValue, String propertyUnits) {
        output.println("  " + propertyDescription);
        output.println("    [ " + propertyName + " ] [ " + propertyValue + " ] [[ " + propertyDefaultValue + " ]] (" + propertyUnits + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void introspectHandles(PrintWriter output) {
        output.println();
        output.println("Active and Cached ZipFile Handles:");
        Integer n = zipFileHandlesLock;
        synchronized (n) {
            if (zipFileHandles.isEmpty()) {
                output.println("  ** NONE **");
            } else {
                for (Map.Entry<String, ZipFileHandle> handleEntry : zipFileHandles.entrySet()) {
                    ZipFileHandle handle = handleEntry.getValue();
                    if (handle instanceof ZipFileHandleImpl) {
                        ZipFileHandleImpl handleImpl = (ZipFileHandleImpl)handle;
                        handleImpl.introspect(output);
                        continue;
                    }
                    output.println("  " + handle);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipCachingServiceImpl", ZipCachingServiceImpl.class, (String)"archive.artifact", null);
        zipFileHandlesLock = new Integer(0);
        final int handleMax = ZipCachingProperties.ZIP_CACHE_HANDLE_MAX;
        int initialAllocation = handleMax == -1 ? 16 : handleMax;
        zipFileHandles = new LinkedHashMap<String, ZipFileHandle>(initialAllocation, 0.75f, true){
            private static final long serialVersionUID = 1L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ZipFileHandle> eldest) {
                return handleMax != -1 && this.size() > handleMax;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.artifact.zip.cache.internal.ZipCachingServiceImpl$1", 1.class, (String)"archive.artifact", null);
            }
        };
        INTROSPECT_STAMP_FORMAT = new SimpleDateFormat("MM/dd/yyyy kk:mm:ss:SSS zzz");
    }
}

