/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca17.processor.service;

import com.ibm.websphere.config.ConfigEvaluatorException;
import com.ibm.websphere.config.WSConfigurationHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.AppDefinedResourceFactory;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jca.service.ConnectionFactoryService;
import com.ibm.ws.jca17.processor.service.AdministeredObjectResourceFactoryBuilder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.resource.ResourceException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConnectionFactoryResourceBuilder
implements ResourceFactoryBuilder {
    private static final String BASE_PROPERTIES_KEY = "properties.0.";
    private static final TraceComponent tc = Tr.register(ConnectionFactoryResourceBuilder.class, null, null);
    private static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String CONFIG_SOURCE = "config.source";
    private static final String FILE = "file";
    private static final String ID = "id";
    static final String DECLARING_APPLICATION = "declaringApplication";
    static final String UNIQUE_JNDI_NAME = "jndiName.unique";
    static final String TARGET_CONNECTION_MANAGER = "connectionManager.target";
    static final String CONNECTION_MANAGER_REF = "connectionManagerRef";
    private static final String BUNDLE_LOCATION = "ConnectorModuleMetatype@ConnectorModule:";
    private static final String BOOTSTRAP_CONTEXT = "bootstrapContext.target";
    private static final String MANAGED_CONNECTION_FACTORY_CLASS = "managedconnectionfactory-class";
    private static final String CREATES_OBJECTCLASS = "creates.objectClass";
    private static final String RESOURCE_ADAPTER = "resourceAdapter";
    private static final String INTERFACE_NAME = "interfaceName";
    private BundleContext bundleContext;
    private static final String EMBEDDED_RA_PREFIX = "#";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configAdmin");
    private final AtomicServiceReference<VariableRegistry> variableRegistryRef = new AtomicServiceReference("variableRegistry");
    private final AtomicServiceReference<MetaTypeService> metaTypeServiceRef = new AtomicServiceReference("metaTypeService");
    private final AtomicServiceReference<WSConfigurationHelper> wsConfigurationHelperRef = new AtomicServiceReference("wsConfigurationHelper");
    static final long serialVersionUID = 6460101492527121538L;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
        this.configAdminRef.activate(context);
        this.variableRegistryRef.activate(context);
        this.metaTypeServiceRef.activate(context);
        this.wsConfigurationHelperRef.activate(context);
        this.bundleContext = AdministeredObjectResourceFactoryBuilder.priv.getBundleContext(context);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceFactory", (Object[])new Object[]{props});
        }
        Hashtable<Object, String> cmSvcProps = new Hashtable<Object, String>();
        Hashtable<String, Object> connectionFactorySvcProps = new Hashtable<String, Object>();
        HashMap<String, Object> annotationProps = new HashMap<String, Object>();
        VariableRegistry variableRegistry = (VariableRegistry)this.variableRegistryRef.getServiceWithException();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            if (value instanceof String) {
                value = variableRegistry.resolveRawString((String)value);
            }
            annotationProps.put(prop.getKey(), value);
        }
        String application = (String)annotationProps.remove("application");
        String declaringApplication = (String)annotationProps.remove(DECLARING_APPLICATION);
        String module = (String)annotationProps.remove("module");
        String component = (String)annotationProps.remove("component");
        String jndiName = (String)annotationProps.remove("jndiName");
        String connectionFactoryID = ConnectionFactoryResourceBuilder.getConnectionFactoryID(application, module, component, jndiName);
        String conManagerID = connectionFactoryID + '/' + "connectionManager";
        String conManagerFilter = FilterUtils.createPropertyFilter((String)ID, (String)conManagerID);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)connectionFactoryID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(connectionFactoryID);
        }
        cmSvcProps.put(ID, conManagerID);
        cmSvcProps.put(CONFIG_DISPLAY_ID, conManagerID);
        connectionFactorySvcProps.put(ID, connectionFactoryID);
        connectionFactorySvcProps.put(CONFIG_DISPLAY_ID, connectionFactoryID);
        connectionFactorySvcProps.put("jndiName", jndiName);
        connectionFactorySvcProps.put(UNIQUE_JNDI_NAME, connectionFactoryID);
        connectionFactorySvcProps.put(TARGET_CONNECTION_MANAGER, conManagerFilter);
        connectionFactorySvcProps.put("jaasLoginContextEntry.target", "(service.pid=unbound)");
        connectionFactorySvcProps.put("jaasLoginContextEntry.cardinality.minimum", 0);
        if (application != null) {
            connectionFactorySvcProps.put("application", application);
            if (module != null) {
                connectionFactorySvcProps.put("module", module);
                if (component != null) {
                    connectionFactorySvcProps.put("component", component);
                }
            }
        }
        String resourceAdapter = (String)annotationProps.remove(RESOURCE_ADAPTER);
        String interfaceName = (String)annotationProps.remove(INTERFACE_NAME);
        if (resourceAdapter.startsWith(EMBEDDED_RA_PREFIX)) {
            resourceAdapter = declaringApplication + "." + resourceAdapter.substring(resourceAdapter.indexOf(EMBEDDED_RA_PREFIX) + 1, resourceAdapter.length());
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Embedded resourceAdapter name : " + resourceAdapter), (Object[])new Object[0]);
            }
        }
        connectionFactorySvcProps.put(BOOTSTRAP_CONTEXT, "(id=" + resourceAdapter + ")");
        connectionFactorySvcProps.put(CREATES_OBJECTCLASS, interfaceName);
        connectionFactorySvcProps.put("transactionSupport", annotationProps.remove("transactionSupport"));
        Dictionary<String, Object> connectionFactoryDefaultProps = this.getDefaultProperties(resourceAdapter, interfaceName);
        String configPropsPid = null;
        Enumeration<String> keys = connectionFactoryDefaultProps.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = connectionFactoryDefaultProps.get(key);
            if (annotationProps.containsKey(key)) {
                value = annotationProps.remove(key);
            }
            if (value instanceof String) {
                value = variableRegistry.resolveString((String)value);
            }
            if (CONFIG_DISPLAY_ID.equals(key)) {
                configPropsPid = (String)value;
                connectionFactorySvcProps.put("properties.0.config.referenceType", configPropsPid);
                continue;
            }
            connectionFactorySvcProps.put(BASE_PROPERTIES_KEY + (String)key, value);
        }
        for (Object name : ConnectionManagerService.CONNECTION_MANAGER_PROPS) {
            Object value = annotationProps.remove(name);
            if (value == null) continue;
            cmSvcProps.put(name, (String)value);
        }
        WSConfigurationHelper configHelper = (WSConfigurationHelper)this.wsConfigurationHelperRef.getServiceWithException();
        for (Map.Entry entry : annotationProps.entrySet()) {
            String key = (String)entry.getKey();
            String attrName = configHelper.getMetaTypeAttributeName(configPropsPid, key);
            if (attrName == null || "INTERNAL".equalsIgnoreCase(attrName)) continue;
            connectionFactorySvcProps.put(BASE_PROPERTIES_KEY + key, entry.getValue());
        }
        BundleContext bundleContext = AdministeredObjectResourceFactoryBuilder.priv.getBundleContext(FrameworkUtil.getBundle(ConnectionFactoryService.class));
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("(&").append(FilterUtils.createPropertyFilter((String)ID, (String)connectionFactoryID));
        stringBuilder.append(FilterUtils.createPropertyFilter((String)"objectClass", (String)ConnectionFactoryService.class.getName())).append(")");
        AppDefinedResourceFactory factory = new AppDefinedResourceFactory((ResourceFactoryBuilder)this, bundleContext, connectionFactoryID, stringBuilder.toString(), declaringApplication);
        try {
            String bundleLocation = bundleContext.getBundle().getLocation();
            String jcaBundleLocation = AdministeredObjectResourceFactoryBuilder.priv.getBundleContext(FrameworkUtil.getBundle(ConnectorService.class)).getBundle().getLocation();
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            Configuration conMgrConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jca.connectionManager", jcaBundleLocation);
            conMgrConfig.update(cmSvcProps);
            connectionFactorySvcProps.put(CONNECTION_MANAGER_REF, new String[]{conMgrConfig.getPid()});
            Configuration connectionFactorySvcConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jca.connectionFactory.supertype", bundleLocation);
            connectionFactorySvcConfig.update(connectionFactorySvcProps);
        }
        catch (Exception bundleLocation) {
            void x;
            FFDCFilter.processException((Throwable)bundleLocation, (String)"com.ibm.ws.jca17.processor.service.ConnectionFactoryResourceBuilder", (String)"263", (Object)this, (Object[])new Object[]{props});
            factory.destroy();
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jca17.processor.service.ConnectionFactoryResourceBuilder", (String)"266", (Object)this, (Object[])new Object[]{props});
            factory.destroy();
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceFactory", (Object)factory);
        }
        return factory;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
        this.configAdminRef.deactivate(context);
        this.variableRegistryRef.deactivate(context);
        this.metaTypeServiceRef.deactivate(context);
        this.wsConfigurationHelperRef.deactivate(context);
    }

    private Dictionary<String, Object> getDefaultProperties(String resourceAdapter, String interfaceName) throws ConfigEvaluatorException, ResourceException {
        String[] factoryPids;
        MetaTypeInformation metaTypeInformation = ((MetaTypeService)this.metaTypeServiceRef.getService()).getMetaTypeInformation(this.bundleContext.getBundle(BUNDLE_LOCATION + resourceAdapter));
        for (String factoryPid : factoryPids = metaTypeInformation.getFactoryPids()) {
            Dictionary defaultProps = ((WSConfigurationHelper)this.wsConfigurationHelperRef.getService()).getMetaTypeDefaultProperties(factoryPid);
            if (defaultProps.get(MANAGED_CONNECTION_FACTORY_CLASS) == null) continue;
            for (String createsClass : (String[])defaultProps.get(CREATES_OBJECTCLASS)) {
                if (!createsClass.equals(interfaceName)) continue;
                return defaultProps;
            }
        }
        ResourceException x = new ResourceException();
        throw x;
    }

    private static final String getConnectionFactoryID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application").append('[').append(application).append(']').append('/');
            if (module != null) {
                sb.append("module").append('[').append(module).append(']').append('/');
                if (component != null) {
                    sb.append("component").append('[').append(component).append(']').append('/');
                }
            }
        }
        return sb.append("connectionFactory").append('[').append(jndiName).append(']').toString();
    }

    public final boolean removeExistingConfigurations(String filter) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        Configuration[] existingConfigurations = configAdmin.listConfigurations(filter);
        if (existingConfigurations != null) {
            for (Configuration config : existingConfigurations) {
                Dictionary cfgProps = config.getProperties();
                if (cfgProps != null && FILE.equals(cfgProps.get(CONFIG_SOURCE))) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"configuration found in server.xml: ", (Object[])new Object[]{config.getPid()});
                    }
                    return false;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing", (Object[])new Object[]{config.getPid()});
                }
                config.delete();
            }
        }
        return true;
    }

    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.unsetReference(ref);
    }

    protected void setVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.setReference(ref);
    }

    protected void unsetVariableRegistry(ServiceReference<VariableRegistry> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetVariableRegistry", (Object[])new Object[]{ref});
        }
        this.variableRegistryRef.unsetReference(ref);
    }

    protected void setWsConfigurationHelper(ServiceReference<WSConfigurationHelper> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setWSConfigurationHelper", (Object[])new Object[]{ref});
        }
        this.wsConfigurationHelperRef.setReference(ref);
    }

    protected void unsetWsConfigurationHelper(ServiceReference<WSConfigurationHelper> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetVariableRegistry", (Object[])new Object[]{ref});
        }
        this.wsConfigurationHelperRef.unsetReference(ref);
    }

    protected void setMetaTypeService(ServiceReference<MetaTypeService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setMetaTypeService", (Object[])new Object[]{ref});
        }
        this.metaTypeServiceRef.setReference(ref);
    }

    protected void unsetMetaTypeService(ServiceReference<MetaTypeService> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetMetaTypeService", (Object[])new Object[]{ref});
        }
        this.metaTypeServiceRef.unsetReference(ref);
    }
}

