/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.Timer;

public abstract class MetricRegistry {
    public static String name(String name, String ... names) {
        StringBuilder builder = new StringBuilder();
        MetricRegistry.append(builder, name);
        if (names != null) {
            for (String s : names) {
                MetricRegistry.append(builder, s);
            }
        }
        return builder.toString();
    }

    private static void append(StringBuilder builder, String part) {
        if (part != null && !part.isEmpty()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
    }

    public static String name(Class<?> klass, String ... names) {
        return MetricRegistry.name(klass.getName(), names);
    }

    public abstract <T extends Metric> T register(String var1, T var2) throws IllegalArgumentException;

    public abstract <T extends Metric> T register(String var1, T var2, Metadata var3) throws IllegalArgumentException;

    public abstract Counter counter(String var1);

    public abstract Counter counter(Metadata var1);

    public abstract Histogram histogram(String var1);

    public abstract Histogram histogram(Metadata var1);

    public abstract Meter meter(String var1);

    public abstract Meter meter(Metadata var1);

    public abstract Timer timer(String var1);

    public abstract Timer timer(Metadata var1);

    public abstract boolean remove(String var1);

    public abstract void removeMatching(MetricFilter var1);

    public abstract SortedSet<String> getNames();

    public abstract SortedMap<String, Gauge> getGauges();

    public abstract SortedMap<String, Gauge> getGauges(MetricFilter var1);

    public abstract SortedMap<String, Counter> getCounters();

    public abstract SortedMap<String, Counter> getCounters(MetricFilter var1);

    public abstract SortedMap<String, Histogram> getHistograms();

    public abstract SortedMap<String, Histogram> getHistograms(MetricFilter var1);

    public abstract SortedMap<String, Meter> getMeters();

    public abstract SortedMap<String, Meter> getMeters(MetricFilter var1);

    public abstract SortedMap<String, Timer> getTimers();

    public abstract SortedMap<String, Timer> getTimers(MetricFilter var1);

    public abstract Map<String, Metric> getMetrics();

    public abstract Map<String, Metadata> getMetadata();

    public static enum Type {
        APPLICATION("application"),
        BASE("base"),
        VENDOR("vendor");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

