/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections.udp;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.transport.connections.udp.SIPConnectionImpl;
import com.ibm.ws.sip.stack.transaction.transport.connections.udp.UDPSenderThread;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;

public class SIPListenningConnectionImpl
implements SIPListenningConnection,
Runnable {
    private static final LogMgr s_logger = Log.get(SIPListenningConnectionImpl.class);
    private static int s_pathMTU = ApplicationProperties.getProperties().getInt("pathMtu");
    private boolean m_isRunning;
    private DatagramSocket m_sock;
    private Thread m_listeningThread;
    private ListeningPointImpl m_lp;
    private UDPSenderThread m_sender;

    SIPListenningConnectionImpl(ListeningPointImpl lp) throws IOException {
        try {
            this.init(lp);
        }
        catch (IOException e2) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "SIPListenningConnectionImpl", e2.getMessage(), e2);
            }
            throw e2;
        }
    }

    private void init(ListeningPointImpl lp) throws IOException {
        this.m_lp = lp;
        InetAddress address = InetAddressCache.getByName(this.m_lp.getHost());
        this.m_sock = new DatagramSocket(this.m_lp.getPort(), address);
        this.m_lp.setPort(this.m_sock.getLocalPort());
        int bufferSize = ApplicationProperties.getProperties().getInt("receiveBufferSize");
        this.m_sock.setReceiveBufferSize(bufferSize);
        this.m_sock.setSendBufferSize(bufferSize);
        this.m_sender = new UDPSenderThread(this.m_sock);
        this.m_sender.start();
    }

    @Override
    public SIPConnection createConnection(InetAddress remoteAddress, int remotePort) {
        String ip = InetAddressCache.getHostAddress(remoteAddress);
        return new SIPConnectionImpl(this, ip, remotePort);
    }

    @Override
    public synchronized void listen() throws IOException {
        this.m_listeningThread = new Thread((Runnable)this, "Listenning Thread on " + this.m_lp);
        this.m_listeningThread.start();
    }

    @Override
    public synchronized void stopListen() {
        this.m_isRunning = false;
    }

    @Override
    public synchronized void close() {
        this.m_isRunning = false;
        this.notifyClosed();
    }

    private synchronized void notifyClosed() {
    }

    @Override
    public ListeningPoint getListeningPoint() {
        return this.m_lp;
    }

    public static int getPathMTU() {
        return s_pathMTU;
    }

    public void write(MessageContext messageSendingContext, String peerHost, int peerPort) {
        this.m_sender.addToQ(messageSendingContext);
    }

    public List<MessageContext> getMessages() {
        return this.m_sender.getMessagesFromQ();
    }

    @Override
    public void run() {
        block4: {
            Dispatcher dispatch = Dispatcher.instance();
            try {
                int packetSize = this.m_sock.getReceiveBufferSize();
                byte[] buf = new byte[packetSize];
                DatagramPacket packet = new DatagramPacket(buf, packetSize);
                this.m_isRunning = true;
                while (this.m_isRunning) {
                    this.m_sock.receive(packet);
                    if (dispatch.isOverLoaded()) {
                        this.handleOverLoading();
                        continue;
                    }
                    int messageSize = packet.getLength();
                    String peerHost = SIPStackUtil.getHostAddress(packet.getAddress());
                    int peerPort = packet.getPort();
                    SipMessageByteBuffer byteBuffer = SipMessageByteBuffer.fromNetwork(buf, messageSize, peerHost, peerPort);
                    SIPConnectionImpl connection = new SIPConnectionImpl(this, peerHost, peerPort);
                    connection.setRemoteHost(peerHost);
                    connection.setRemotePort(peerPort);
                    connection.setConnected();
                    dispatch.queueConnectionAcceptedEvent(this, connection);
                    dispatch.queueIncomingDataEvent(byteBuffer, connection);
                }
            }
            catch (IOException e2) {
                if (!s_logger.isTraceDebugEnabled()) break block4;
                s_logger.traceDebug(this, "run", e2.getMessage());
            }
        }
        this.close();
    }

    private void handleOverLoading() {
    }
}

