/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnectionFactory;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import com.ibm.ws.sip.stack.transport.sip.SIPConnectionFactoryImplWs;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SIPConnectionsModel {
    protected static final TraceComponent tc = Tr.register(SIPConnectionsModel.class);
    private static final LogMgr c_logger = Log.get(SIPConnectionsModel.class);
    private HashMap<ListeningPoint, SIPListenningConnection> m_listeningConnections = new HashMap(4);
    private ArrayList<ListeningPoint> m_listeningPoints = new ArrayList(4);
    private final HashMap<ListeningPoint, HashMap<Hop, SIPConnection>> m_connections = new HashMap(4);
    private ArrayList<SupportedTransport> m_supportedTransports;
    private static SIPConnectionsModel s_instance = new SIPConnectionsModel();

    public static SIPConnectionsModel instance() {
        return s_instance;
    }

    private SIPConnectionsModel() {
        this.initSupportedTransports();
    }

    private final void initSupportedTransports() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"initSupportedTransports", (Object[])new Object[]{"useChannelFramework"});
        }
        SIPConnectionFactoryImplWs factory = SIPConnectionFactoryImplWs.instance();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"initSupportedTransports", (Object[])new Object[]{"loading connection factory class"});
        }
        SIPConnectionFactoryImplWs udpConnectionFactory = factory;
        SIPConnectionFactoryImplWs tcpConnectionFactory = factory;
        SIPConnectionFactoryImplWs tlsConnectionFactory = factory;
        SupportedTransport udp = new SupportedTransport("udp", udpConnectionFactory, false);
        SupportedTransport tcp = new SupportedTransport("tcp", tcpConnectionFactory, false);
        SupportedTransport tls = new SupportedTransport("tls", tlsConnectionFactory, true);
        this.m_supportedTransports = new ArrayList(3);
        this.m_supportedTransports.add(udp);
        this.m_supportedTransports.add(tcp);
        this.m_supportedTransports.add(tls);
    }

    public void addedListeningPoint(ListeningPoint lp) throws IOException {
        this.createSIPListenningConnection((ListeningPointImpl)lp);
    }

    public ListeningPointImpl getDefaultListenningPoint(String transport) {
        ListeningPoint retVal = null;
        Set<ListeningPoint> keys = this.m_listeningConnections.keySet();
        for (ListeningPoint lp : keys) {
            if (!lp.getTransport().equalsIgnoreCase(transport)) continue;
            retVal = lp;
            break;
        }
        return (ListeningPointImpl)retVal;
    }

    public ListeningPointImpl getDefaultListenningPoint(String transport, String inetAddress) {
        ListeningPointImpl retVal = this.getDefaultListenningPoint(transport);
        Set<ListeningPoint> keys = this.m_listeningConnections.keySet();
        for (ListeningPointImpl listeningPointImpl : keys) {
            if (!listeningPointImpl.getTransport().equalsIgnoreCase(transport) || !SIPStackUtil.isSameInetAddressType(inetAddress, listeningPointImpl.getHost())) continue;
            retVal = listeningPointImpl;
            break;
        }
        return retVal;
    }

    private synchronized HashMap<Hop, SIPConnection> getConnections(ListeningPoint listeningPoint) {
        HashMap<Hop, SIPConnection> connections = this.m_connections.get(listeningPoint);
        if (connections == null) {
            connections = new HashMap(16);
            this.m_connections.put(listeningPoint, connections);
        }
        return connections;
    }

    public synchronized SIPConnection getConnection(ListeningPoint listeningPoint, Hop hop) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{"connection listeningPoint = " + listeningPoint + " hop = " + hop});
        }
        SIPConnection connection = null;
        if (listeningPoint == null) {
            int n = this.m_listeningPoints.size();
            for (int i = 0; i < n; ++i) {
                listeningPoint = this.m_listeningPoints.get(i);
                connection = this.getConnection(listeningPoint, hop);
                if (connection == null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{"Found Connection = " + connection});
                }
                return connection;
            }
        } else {
            HashMap<Hop, SIPConnection> connections = this.getConnections(listeningPoint);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{"connections = " + connections.toString()});
            }
            connection = connections.get(hop);
        }
        return connection;
    }

    public synchronized void addConnection(SIPConnection connection) {
        HashMap<Hop, SIPConnection> connections;
        SIPConnection removed;
        SIPListenningConnection listening = connection.getSIPListenningConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"addConnection", (Object[])new Object[]{"listening " + listening});
        }
        ListeningPoint listeningPoint = listening.getListeningPoint();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"addConnection", (Object[])new Object[]{"listeningPoint " + listeningPoint});
        }
        if ((removed = (connections = this.getConnections(listeningPoint)).put(connection.getKey(), connection)) != null && removed != connection) {
            if (removed.isOutbound()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"addConnection", (Object[])new Object[]{"closing replaced connection " + removed});
                }
                removed.close();
            }
            this.logConnection(removed, true);
        }
        this.logConnection(connection, false);
    }

    public synchronized void updateConnection(SIPConnection connection, int aliasPort) {
        SIPListenningConnection listening = connection.getSIPListenningConnection();
        ListeningPoint listeningPoint = listening.getListeningPoint();
        HashMap<Hop, SIPConnection> connections = this.getConnections(listeningPoint);
        Hop key = connection.getKey();
        connections.remove(key);
        connection.setAliacePort(aliasPort);
        key.setPort(aliasPort);
        connection.setKey(key);
        SIPConnection removed = connections.put(key, connection);
        if (removed != null && removed != connection) {
            if (removed.isOutbound()) {
                ListeningPoint lp = removed.getSIPListenningConnection().getListeningPoint();
                String lpHost = lp.getHost();
                int lpPort = lp.getPort();
                String remoteHost = removed.getRemoteHost();
                int remotePort = removed.getRemotePort();
                if (!lpHost.equals(remoteHost) || lpPort != remotePort) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"updateConnection", (Object[])new Object[]{"closing replaced connection " + removed});
                    }
                    removed.close();
                }
            }
            this.logConnection(removed, true);
        }
        this.logConnection(connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(SIPConnection connection) {
        SIPConnectionsModel sIPConnectionsModel = this;
        synchronized (sIPConnectionsModel) {
            SIPListenningConnection listening = connection.getSIPListenningConnection();
            ListeningPoint listeningPoint = listening.getListeningPoint();
            HashMap<Hop, SIPConnection> connections = this.getConnections(listeningPoint);
            Hop key = connection.getKey();
            if (connections.get(key) == connection) {
                connections.remove(key);
                this.logConnection(connection, true);
            }
        }
        connection.close();
    }

    public synchronized SIPConnection createConnection(ListeningPoint lp, String remoteHost, int remotePort) throws IOException {
        SIPListenningConnection listenningConnection;
        if (lp.getHost().equals(remoteHost) && lp.getPort() == remotePort && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Warning: loopback connection detected", (Object[])new Object[0]);
        }
        if ((listenningConnection = this.getListeningConnection(lp)) == null) {
            throw new IOException("no listenning connection found to listenning point " + lp);
        }
        InetAddress remoteAddress = InetAddressCache.getByName(remoteHost);
        SIPConnection retVal = listenningConnection.createConnection(remoteAddress, remotePort);
        return retVal;
    }

    private SIPListenningConnection getListeningConnection(ListeningPoint lp) {
        ListeningPointImpl lpA = (ListeningPointImpl)lp;
        String transportA = lpA.getTransport();
        String hostA = lpA.getHost();
        String sentByA = lpA.getSentBy();
        int portA = lpA.getPort();
        boolean secureA = lpA.isSecure();
        Set<Map.Entry<ListeningPoint, SIPListenningConnection>> entries = this.m_listeningConnections.entrySet();
        for (Map.Entry<ListeningPoint, SIPListenningConnection> entry : entries) {
            ListeningPointImpl lpB = (ListeningPointImpl)entry.getKey();
            String transportB = lpB.getTransport();
            String hostB = lpB.getHost();
            String sentByB = lpB.getSentBy();
            int portB = lpB.getPort();
            boolean secureB = lpB.isSecure();
            if (secureA != secureB || portA != portB || !transportA.equals(transportB) || !hostA.equals(hostB) && !sentByA.equalsIgnoreCase(sentByB)) continue;
            return entry.getValue();
        }
        return null;
    }

    public synchronized void removeListeningConnectionClosed(SIPListenningConnection listenning) {
        listenning.stopListen();
        ListeningPoint lp = listenning.getListeningPoint();
        this.m_listeningConnections.remove(lp);
        this.m_listeningPoints.remove(lp);
    }

    public List<ListeningPoint> getListeningPoints() {
        return this.m_listeningPoints;
    }

    public synchronized Collection<SIPListenningConnection> getListeningConnections() {
        return this.m_listeningConnections.values();
    }

    synchronized SIPListenningConnection createSIPListenningConnection(ListeningPointImpl lp) throws IOException {
        String transportFactoryKey = lp.getTransport().equals("tcp") && lp.isSecure() ? "tls" : lp.getTransport();
        SIPConnectionFactory factory = this.getConnectionFactory(transportFactoryKey);
        SIPListenningConnection listenConnection = factory.createListeningConnection(lp);
        if (listenConnection != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"createSIPListenningConnection", (Object[])new Object[]{"connection " + listenConnection + " created,trying to listen"});
            }
            listenConnection.listen();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"createSIPListenningConnection", (Object[])new Object[]{"connection " + listenConnection + " started to listen"});
            }
            this.m_listeningConnections.put(lp, listenConnection);
            if (!this.m_listeningPoints.contains(lp)) {
                this.m_listeningPoints.add(lp);
            }
            Object[] params = new Object[]{lp};
            if (c_logger.isInfoEnabled()) {
                c_logger.info("info.com.ibm.ws.sip.stack.transaction.transport.initListeningPoints", (Object)"Start.START INITIATED", params);
            }
        } else {
            throw new IOException("could not instansiate Listenning connection!");
        }
        return listenConnection;
    }

    synchronized void removeSIPListenningConnection(ListeningPointImpl lp) {
        SIPListenningConnection listenConnection = this.m_listeningConnections.remove(lp);
        if (listenConnection != null) {
            listenConnection.stopListen();
        }
    }

    private SupportedTransport getSupportedTransport(String transport) {
        for (int i = 0; i < this.m_supportedTransports.size(); ++i) {
            SupportedTransport t = this.m_supportedTransports.get(i);
            if (!t.m_transport.equalsIgnoreCase(transport)) continue;
            return t;
        }
        return null;
    }

    public boolean isTransportSupported(String transport) {
        return this.getSupportedTransport(transport) != null;
    }

    private SIPConnectionFactory getConnectionFactory(String transport) {
        SupportedTransport t = this.getSupportedTransport(transport);
        if (t == null) {
            return null;
        }
        return t.m_connectionFactory;
    }

    public boolean isTransportSecure(String transport) {
        SupportedTransport t = this.getSupportedTransport(transport);
        if (t == null) {
            return false;
        }
        return t.m_secure;
    }

    public String getDefaultSecureTransport() {
        return "tls";
    }

    public int getDefaultSecurePort() {
        return 5061;
    }

    public synchronized ListeningPointImpl getListeningPoint(String host, int port, String transport) {
        int n = this.m_listeningPoints.size();
        for (int i = 0; i < n; ++i) {
            ListeningPointImpl listeningPoint = (ListeningPointImpl)this.m_listeningPoints.get(i);
            String listeningPointHost = listeningPoint.getHost();
            int listeningPointPort = listeningPoint.getPort();
            String listeningPointTransport = listeningPoint.getTransport();
            if (listeningPointPort != port || !listeningPointHost.equalsIgnoreCase(host) || !listeningPointTransport.equalsIgnoreCase(transport)) continue;
            return listeningPoint;
        }
        return null;
    }

    public ListeningPointImpl getListeningPoint(int index, String transport) {
        int n = this.m_listeningPoints.size();
        int counter = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getListeningPoint", (Object[])new Object[]{"listeningPoints = " + this.m_listeningPoints});
        }
        for (int i = 0; i < n; ++i) {
            ListeningPointImpl listeningPoint = (ListeningPointImpl)this.m_listeningPoints.get(i);
            String listeningPointTransport = listeningPoint.getTransport();
            if (!listeningPointTransport.equalsIgnoreCase(transport) || counter++ != index) continue;
            return listeningPoint;
        }
        return null;
    }

    private void logConnection(SIPConnection connection, boolean remove) {
        SIPListenningConnection listening = connection.getSIPListenningConnection();
        ListeningPoint listeningPoint = listening.getListeningPoint();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"logConnection", (Object[])new Object[]{"[" + (remove ? "removed" : "changed") + "] connection [" + System.identityHashCode(connection) + "] listening point [" + listeningPoint + "] key [" + connection.getKey() + "] remote [" + connection.getRemoteHost() + ':' + connection.getRemotePort() + ']'});
        }
    }

    private static class SupportedTransport {
        private final String m_transport;
        private final SIPConnectionFactory m_connectionFactory;
        private final boolean m_secure;

        SupportedTransport(String transport, SIPConnectionFactory connectionFactory, boolean secure) {
            this.m_transport = transport;
            this.m_connectionFactory = connectionFactory;
            this.m_secure = secure;
        }
    }
}

