/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.sipAppAdapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipXMLParser;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.xml.sax.SAXException;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, configurationPid={"com.ibm.ws.sip.sipAppAdapter.SipAppAdapter"}, service={ContainerAdapter.class}, property={"service.vendor=IBM", "toType=com.ibm.ws.javaee.dd.web.WebApp", "service.ranking:Integer=1"})
public class SipAppAdapter
implements ContainerAdapter<WebApp> {
    private static final TraceComponent tc = Tr.register(SipAppAdapter.class);
    private ThreadLocal<Collection<Container>> _currentlyProcessing = null;

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SipAppAdapter activated", (Object[])new Object[]{properties});
        }
        this._currentlyProcessing = new ThreadLocal<Collection<Container>>(){

            @Override
            protected Collection<Container> initialValue() {
                return new ArrayList<Container>(1);
            }
        };
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("SipAppAdapter deactivated, reason=" + reason), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        SipAppDesc appDesc = (SipAppDesc)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), SipAppDesc.class);
        if (appDesc != null) {
            return appDesc;
        }
        WebApp webApp = (WebApp)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), WebApp.class);
        if (webApp != null) {
            return webApp;
        }
        Collection<Container> inFlight = this._currentlyProcessing.get();
        if (inFlight.contains(containerToAdapt)) {
            return null;
        }
        try {
            inFlight.add(containerToAdapt);
            webApp = (WebApp)containerToAdapt.adapt(WebApp.class);
            ArtifactEntry sipXMLEntry = artifactContainer.getEntry("/WEB-INF/sip.xml");
            InputStream xmlStream = null;
            if (sipXMLEntry != null) {
                try {
                    xmlStream = sipXMLEntry.getInputStream();
                    if (xmlStream != null && (appDesc = this.loadDataFromSipXml(xmlStream)) != null) {
                        appDesc.updateShouldExcludeFromApplicationRouting();
                        if (webApp != null) {
                            appDesc.setddWebApp(webApp);
                            appDesc.mergeWebApptoSip();
                        }
                        rootOverlay.addToNonPersistentCache(artifactContainer.getPath(), SipAppDesc.class, (Object)appDesc);
                        SipAppDesc sipAppDesc = appDesc;
                        return sipAppDesc;
                    }
                }
                catch (IOException e2) {
                    WebApp webApp2 = webApp;
                    return webApp2;
                }
                finally {
                    if (xmlStream != null) {
                        try {
                            xmlStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            WebApp webApp3 = webApp;
            return webApp3;
        }
        finally {
            inFlight.remove(containerToAdapt);
        }
    }

    private SipAppDesc loadDataFromSipXml(InputStream sipXML) {
        SipAppDesc sipApp;
        block7: {
            sipApp = null;
            try {
                SipXMLParser parser = new SipXMLParser();
                sipApp = parser.parse(sipXML);
            }
            catch (SAXException e2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"loadDataFromSipXml", (Object[])new Object[]{", failed reading sip.xml=", e2});
                }
            }
            catch (IOException e3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"loadDataFromSipXml", (Object[])new Object[]{", failed reading sip.xml=", e3});
                }
            }
            catch (ParserConfigurationException e4) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"loadDataFromSipXml", (Object[])new Object[]{", failed reading sip.xml=", e4});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SIP Application: ");
            buffer.append(sipApp.getApplicationName());
            buffer.append(" ,Root URI: ");
            buffer.append(sipApp.getRootURI());
            Tr.debug((TraceComponent)tc, (String)"loadSipXml", (Object[])new Object[]{buffer.toString()});
        }
        return sipApp;
    }
}

