/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.properties;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.properties.CustPropSource;
import com.ibm.ws.sip.properties.DeclarativeServiceProperties;
import com.ibm.ws.sip.properties.SipPropertyEntry;
import java.util.Map;
import java.util.Properties;

public class SipPropertiesMap {
    private static final long serialVersionUID = -2474724823492890831L;
    private static final transient LogMgr c_logger = Log.get(SipPropertiesMap.class);
    protected Properties _properties = new Properties();

    private void setEntry(String key, Object value, CustPropSource source, String wccmAttrName) {
        SipPropertyEntry entry = new SipPropertyEntry(key, value, source, wccmAttrName);
        this._properties.put(key, entry);
    }

    public final SipPropertyEntry getEntry(String key) {
        return (SipPropertyEntry)this._properties.get(key);
    }

    public void setString(String key, String value, CustPropSource source) {
        this.setEntry(key, value, source, "");
    }

    public void setString(String key, String value, String wccmAttrName) {
        this.setEntry(key, value, CustPropSource.WCCM, wccmAttrName);
    }

    public void setObject(String key, Object value, CustPropSource source, String wccmAttrName) {
        this.setEntry(key, value, source, wccmAttrName);
    }

    public void setObject(String key, Object value, CustPropSource source) {
        this.setEntry(key, value, source, "");
    }

    public void setInt(String key, int value, CustPropSource source) {
        this.setEntry(key, new Integer(value), source, "");
    }

    public void setShort(String key, short value, String wccmAttrName) {
        this.setEntry(key, new Short(value), CustPropSource.WCCM, wccmAttrName);
    }

    public void setShort(String key, short value, CustPropSource source) {
        this.setEntry(key, new Short(value), source, "");
    }

    public void setInt(String key, int value, String wccmAttrName) {
        this.setEntry(key, new Integer(value), CustPropSource.WCCM, wccmAttrName);
    }

    public void setBoolean(String key, boolean value, CustPropSource source) {
        this.setEntry(key, new Boolean(value), source, "");
    }

    public void setBoolean(String key, boolean value, String wccmAttrName) {
        this.setEntry(key, new Boolean(value), CustPropSource.WCCM, wccmAttrName);
    }

    public void setLong(String key, long value, CustPropSource source) {
        this.setEntry(key, new Long(value), source, "");
    }

    public int getInt(String key) {
        int retValue;
        block6: {
            SipPropertyEntry entry = (SipPropertyEntry)this._properties.get(key);
            retValue = -1;
            if (entry != null) {
                try {
                    Object oVal = entry.getValue();
                    if (oVal instanceof String) {
                        retValue = Integer.parseInt((String)oVal);
                        break block6;
                    }
                    Integer value = (Integer)oVal;
                    retValue = value;
                }
                catch (Exception exp) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getInt", "got Exception, retrieving value: " + retValue + " " + exp);
                    }
                    break block6;
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getInt", "could not find value for: " + key + " ,retrieving value: " + retValue);
            }
        }
        return retValue;
    }

    public short getShort(String key) {
        short retValue;
        block6: {
            SipPropertyEntry entry = (SipPropertyEntry)this._properties.get(key);
            retValue = -1;
            if (entry != null) {
                try {
                    Object oVal = entry.getValue();
                    if (oVal instanceof String) {
                        retValue = Short.parseShort((String)oVal);
                        break block6;
                    }
                    Short value = (Short)entry.getValue();
                    retValue = value;
                }
                catch (Exception exp) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getShort", "got Exception, retrieving value: " + retValue + " " + exp);
                    }
                    break block6;
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getShort", "could not find value for: " + key + " ,retrieving value: " + retValue);
            }
        }
        return retValue;
    }

    public long getLong(String key) {
        long retValue;
        block6: {
            SipPropertyEntry entry = (SipPropertyEntry)this._properties.get(key);
            retValue = -1L;
            if (entry != null) {
                try {
                    Object oVal = entry.getValue();
                    if (oVal instanceof String) {
                        retValue = Long.parseLong((String)oVal);
                        break block6;
                    }
                    Long value = (Long)entry.getValue();
                    retValue = value;
                }
                catch (Exception exp) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getLong", "got Exception, retrieving value: " + retValue + " " + exp);
                    }
                    break block6;
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getLong", "could not find value for: " + key + " ,retrieving value: " + retValue);
            }
        }
        return retValue;
    }

    public int getDuration(String key) {
        int retValue;
        block10: {
            SipPropertyEntry entry = (SipPropertyEntry)this._properties.get(key);
            retValue = -1;
            if (entry != null) {
                try {
                    long longValue;
                    Object oVal = entry.getValue();
                    if (oVal instanceof String) {
                        longValue = Long.parseLong((String)oVal);
                    } else {
                        Long value = (Long)entry.getValue();
                        longValue = value;
                    }
                    if (longValue <= Integer.MAX_VALUE) {
                        retValue = (int)longValue;
                    } else if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getDuration", "the duration for " + key + " is greater than max integer, retrieving value: " + retValue);
                    }
                    break block10;
                }
                catch (Exception exp) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getDuration", "got Exception, retrieving value: " + retValue + " " + exp);
                    }
                    break block10;
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getDuration", "could not find value for: " + key + " ,retrieving value: " + retValue);
            }
        }
        return retValue;
    }

    public String getString(String key) {
        return this.getString(key, false);
    }

    public String getString(String key, boolean forceString) {
        SipPropertyEntry entry = (SipPropertyEntry)this._properties.get(key);
        String strValue = "";
        if (entry != null) {
            Object object = entry.getValue();
            if (object instanceof String) {
                strValue = (String)object;
            } else if (forceString) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    Object[] params = new Object[]{key, forceString};
                    c_logger.traceEntry((Object)SipPropertiesMap.class.getName(), "getString", params);
                }
                strValue = object.toString();
            }
        }
        return strValue;
    }

    public boolean getBoolean(String key) {
        boolean retValue;
        block6: {
            SipPropertyEntry entry = (SipPropertyEntry)this._properties.get(key);
            retValue = false;
            if (entry != null) {
                try {
                    Object oVal = entry.getValue();
                    if (oVal instanceof String) {
                        retValue = Boolean.valueOf((String)oVal);
                        break block6;
                    }
                    Boolean value = (Boolean)entry.getValue();
                    retValue = value;
                }
                catch (Exception exp) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getBoolean", "got Exception, retrieving value: " + retValue + " " + exp);
                    }
                    break block6;
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getBoolean", "could not find value for: " + key + " ,retrieving value: " + retValue);
            }
        }
        return retValue;
    }

    public Object getObject(String key) {
        SipPropertyEntry entry = (SipPropertyEntry)this._properties.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public void remove(String key) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{key};
            c_logger.traceEntry((Object)SipPropertiesMap.class.getName(), "remove", params);
        }
        this._properties.remove(key);
    }

    public String logProprs(CustPropSource source) {
        StringBuffer buff = new StringBuffer(1000);
        for (String string : this._properties.keySet()) {
            SipPropertyEntry element = (SipPropertyEntry)this._properties.get(string);
            if (element.getSource() != source) continue;
            buff.append('\n');
            buff.append(element.toString());
        }
        return buff.toString();
    }

    public void putAll(Properties prop, CustPropSource source) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipPropertiesMap.class.getName(), "putAll");
        }
        for (String string : prop.keySet()) {
            String newValue = prop.getProperty(string);
            this.set(string, newValue, source);
        }
    }

    public void set(String key, String newValue, CustPropSource custom) {
        SipPropertyEntry entry;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{key, newValue, custom};
            c_logger.traceEntry((Object)SipPropertiesMap.class.getName(), "set", params);
        }
        if ((entry = (SipPropertyEntry)this._properties.get(key)) != null) {
            Object obj = entry.getValue();
            if (obj instanceof Integer) {
                try {
                    Integer integerVal = Integer.parseInt(newValue);
                    entry.setValue(integerVal);
                    entry.setSource(CustPropSource.CUSTOM);
                }
                catch (NumberFormatException e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "putAll", "cant't load Integer value property: " + key + " value: " + newValue);
                    }
                    return;
                }
            } else if (obj instanceof Long) {
                try {
                    Long longVal = Long.parseLong(newValue);
                    entry.setValue(longVal);
                    entry.setSource(CustPropSource.CUSTOM);
                }
                catch (NumberFormatException e3) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "putAll", "cant't load Long value property: " + key + " value: " + newValue);
                    }
                    return;
                }
            } else if (obj instanceof Short) {
                try {
                    Short shortVal = Short.parseShort(newValue);
                    entry.setValue(shortVal);
                    entry.setSource(CustPropSource.CUSTOM);
                }
                catch (NumberFormatException e4) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "putAll", "cant't load Short value property: " + key + " value: " + newValue);
                    }
                    return;
                }
            } else if (obj instanceof Boolean) {
                Boolean boolVal = true;
                if (newValue.equalsIgnoreCase("false")) {
                    boolVal = false;
                } else if (!newValue.equalsIgnoreCase("true")) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "putAll", "cant't load Boolean value property: " + key + " value: " + newValue);
                    }
                    return;
                }
                entry.setValue(boolVal);
                entry.setSource(CustPropSource.CUSTOM);
            } else {
                entry.setValue(newValue);
                entry.setSource(CustPropSource.CUSTOM);
            }
        } else {
            entry = new SipPropertyEntry(key, newValue, CustPropSource.CUSTOM, "");
            this._properties.put(key, entry);
        }
    }

    public Properties copyProps() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(SipPropertiesMap.class.getName(), "copyProps");
        }
        Properties prop = new Properties();
        for (String string : this._properties.keySet()) {
            SipPropertyEntry element = (SipPropertyEntry)this._properties.get(string);
            if (element.getValue().equals("")) continue;
            prop.put(string, element.getValue().toString());
        }
        return prop;
    }

    public void validateAndFixProperty(String key, String[] values, String fixValue) {
        if (values == null || values.length == 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "validateAndFixProperty", "Skipping validation for key: " + key);
            }
            return;
        }
        String value = this.getString(key);
        if (value == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "validateAndFixProperty", "key wans't found.");
            }
            return;
        }
        boolean found = false;
        for (int i = 0; i < values.length && !found; ++i) {
            if (values[i] == null) {
                throw new NullPointerException("Illegal value specified.");
            }
            if (!value.equals(values[i])) continue;
            found = true;
        }
        if (!found) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "validateAndFixProperty", "Invalid value retrieved: " + value + " replacing with: " + fixValue);
            }
            this.setString(key, fixValue, CustPropSource.DEFAULT);
        }
    }

    public DeclarativeServiceProperties updateProperties(Map<String, Object> properties) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "updateProperties", (Object)properties);
        }
        DeclarativeServiceProperties pHolder = new DeclarativeServiceProperties(properties);
        for (String key : properties.keySet()) {
            Object oldValue = this.getObject(key);
            Object value = properties.get(key);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateProperties", "Debug: Key=" + key + " value=" + value + " replacing : " + oldValue);
            }
            if (oldValue == null || oldValue.equals(value)) continue;
            this.setObject(key, value, CustPropSource.CONFIG_FILE);
            pHolder.storeChangedFromValue(key, oldValue);
            if (!c_logger.isTraceDebugEnabled()) continue;
            c_logger.traceDebug(this, "updateProperties", "key: " + key + " modified from: " + oldValue + " to:" + value);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "updateProperties", pHolder);
        }
        return pHolder;
    }
}

