/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser.util;

import com.ibm.ws.sip.parser.MessageParser;
import java.io.CharArrayWriter;
import java.math.BigDecimal;

public class CharsBuffer
extends CharArrayWriter {
    private byte[] _bytes = new byte[0];
    private int _bytesAvailable = 0;

    public char[] getCharArray() {
        return this.buf;
    }

    public int getCharCount() {
        return this.count;
    }

    public char charAt(int index) {
        return this.buf[index];
    }

    @Override
    public CharsBuffer append(char c) {
        this.write(c);
        return this;
    }

    public CharsBuffer append(float value) {
        this.append(Float.toString(value));
        return this;
    }

    public void append(double value) {
        BigDecimal bd = new BigDecimal(value);
        this.append(bd.toPlainString());
    }

    public CharsBuffer append(int value) {
        if (value == 0) {
            this.append('0');
            return this;
        }
        if (value < 0) {
            this.append('-');
            value = -value;
        }
        this.appendNumber(value);
        return this;
    }

    public CharsBuffer append(long value) {
        if (value == 0L) {
            this.append('0');
            return this;
        }
        if (value < 0L) {
            this.append('-');
            value = -value;
        }
        this.appendNumber(value);
        return this;
    }

    public CharsBuffer append(short value) {
        if (value == 0) {
            this.append('0');
            return this;
        }
        if (value < 0) {
            this.append('-');
            value = -value;
        }
        this.appendNumber(value);
        return this;
    }

    private void appendNumber(int value) {
        char dig = (char)(48 + value % 10);
        int remain = value / 10;
        if (remain > 0) {
            this.appendNumber(remain);
        }
        this.append(dig);
    }

    private void appendNumber(long value) {
        char dig = (char)(48L + value % 10L);
        long remain = value / 10L;
        if (remain > 0L) {
            this.appendNumber(remain);
        }
        this.append(dig);
    }

    private void appendNumber(short value) {
        char dig = (char)(48 + value % 10);
        long remain = value / 10;
        if (remain > 0L) {
            this.appendNumber(remain);
        }
        this.append(dig);
    }

    public CharsBuffer append(Object obj) {
        this.append(String.valueOf(obj));
        return this;
    }

    public CharsBuffer append(String str) {
        if (str == null) {
            str = "";
        }
        this.write(str, 0, str.length());
        return this;
    }

    public CharsBuffer append(char[] str, int length) {
        this.write(str, 0, length);
        return this;
    }

    public boolean append(byte[] bytes, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            char c;
            byte b = bytes[i];
            if ((b & 0x80) == 128) {
                int size = MessageParser.utf8size(b);
                if (size == -1) {
                    return false;
                }
                int value = MessageParser.utf8(bytes, i, end - i, size);
                c = (char)value;
                i += size - 1;
            } else {
                c = (char)b;
            }
            this.append(c);
        }
        return true;
    }

    public void rtrim() {
        while (this.count > 0 && Character.isWhitespace(this.buf[this.count - 1])) {
            --this.count;
        }
    }

    public void rewind(int position) {
        this.count = position;
    }

    public byte[] getBytes() {
        if (this._bytes.length / 4 < this.buf.length) {
            this._bytes = new byte[this.buf.length * 4];
        }
        this._bytesAvailable = 0;
        int j = 0;
        for (int i = 0; i < this.size(); ++i) {
            char c = this.buf[i];
            if (c < '\u0080') {
                this._bytes[j++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                this._bytes[j++] = (byte)(0xC0 | c >> 6);
                this._bytes[j++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\u10000') {
                this._bytes[j++] = (byte)(0xE0 | c >> 12);
                this._bytes[j++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._bytes[j++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\u200000') continue;
            this._bytes[j++] = (byte)(0xF0 | c >> 18);
            this._bytes[j++] = (byte)(0x80 | c >> 12 & 0x3F);
            this._bytes[j++] = (byte)(0x80 | c >> 6 & 0x3F);
            this._bytes[j++] = (byte)(0x80 | c & 0x3F);
        }
        this._bytesAvailable = j;
        return this._bytes;
    }

    public int getBytesSize() {
        return this._bytesAvailable;
    }

    public int hashCode() {
        int hash = 0;
        char[] array = this.buf;
        for (int i = this.count - 1; i >= 0; --i) {
            int carry = (hash & Integer.MIN_VALUE) == 0 ? 0 : 1;
            hash <<= 1;
            hash |= carry;
            hash ^= array[i];
        }
        return hash;
    }
}

