/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.router.SipServletInvokerListener;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.ext.SipServletMessageExt;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.util.wlm.QueueableTransformer;
import com.ibm.ws.sip.container.util.wlm.SipContainerWLMHooksFactory;
import com.ibm.ws.sip.container.was.message.SipMessage;
import jain.protocol.ip.sip.SipProvider;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

public class WebsphereInvoker {
    private static final LogMgr c_logger = Log.get(WebsphereInvoker.class);
    private static WebsphereInvoker s_instance = new WebsphereInvoker();
    public static final String INVOKER_LISTENER_KEY = "INVOKER_LISTENER_KEY";

    private WebsphereInvoker() {
    }

    public static WebsphereInvoker getInstance() {
        return s_instance;
    }

    public void invokeSipServlet(SipServletRequest request, SipServletResponse response, SipServletDesc sipServletDesc, SipServletInvokerListener listener) {
        String requestURI;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "invokeSipServlet", "name: " + sipServletDesc.getName());
        }
        SipAppDesc appDesc = sipServletDesc.getSipApp();
        SipMessage msg = SipContainerComponent.getSipMessageFactory().createSipMessage(request, response, appDesc);
        SipProvider provider = null;
        if (request instanceof SipServletMessageImpl) {
            provider = ((SipServletMessageImpl)((Object)request)).getSipProvider();
        } else if (response instanceof SipServletMessageImpl) {
            provider = ((SipServletMessageImpl)((Object)response)).getSipProvider();
        }
        int port = appDesc.getVHPort();
        String host = appDesc.getVHHost();
        if (port < 1) {
            port = provider.getListeningPoint().getPort();
            host = provider.getListeningPoint().getHost();
        }
        msg.setServerPort(port);
        msg.setHost(host);
        if (provider == null) {
            msg.setSSLEnbaled(false);
        } else {
            msg.setSSLEnbaled(((ListeningPointImpl)provider.getListeningPoint()).isSecure());
        }
        msg.setServletName(sipServletDesc.getName());
        if (null != listener) {
            msg.setListener(listener);
        }
        if ((requestURI = sipServletDesc.getSipApp().getRootURI()).equals("/")) {
            requestURI = "";
        }
        requestURI = requestURI + '/' + sipServletDesc.getName();
        msg.setRequestURI(requestURI);
        Queueable queueable = this.wrapMessageForWLM(msg);
        queueable.run();
    }

    private Queueable wrapMessageForWLM(SipMessage msg) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "wrapMessageForWLM");
        }
        Queueable queueable = msg;
        QueueableTransformer transformer = SipContainerWLMHooksFactory.getSipContainerHooks().getQueueableTransformer();
        if (transformer != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "wrapMessageForWLM", "calling WLMHook transformer");
            }
            SipServletMessageExt sipServletMsg = null;
            if (msg.getRequest() != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "wrapMessageForWLM", "WLMHook - this is request");
                }
                sipServletMsg = (SipServletMessageExt)((Object)msg.getRequest());
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "wrapMessageForWLM", "WLMHook - this is response");
                }
                sipServletMsg = (SipServletMessageExt)((Object)msg.getResponse());
            }
            TransactionUserWrapper ctx = ((SipServletMessageImpl)sipServletMsg).getTransactionUser();
            queueable = transformer.wrap(ctx, msg, sipServletMsg);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "wrapMessageForWLM", "WLMHook - wrapping done");
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "wrapMessageForWLM");
        }
        return queueable;
    }

    public void stop() {
    }
}

