/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.transaction;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.transaction.ClientTransaction;
import com.ibm.ws.sip.container.transaction.ServerTransaction;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import java.util.Hashtable;

public class TransactionTable {
    private static final LogMgr c_logger = Log.get(TransactionTable.class);
    private static TransactionTable c_transactionTable = new TransactionTable();
    private Hashtable m_transactions = new Hashtable();

    private TransactionTable() {
    }

    public synchronized SipTransaction getTransaction(long transactionID) {
        Long ID = new Long(transactionID);
        return (SipTransaction)this.m_transactions.get(ID);
    }

    protected void putTransaction(SipTransaction transaction) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{transaction, transaction.getTransactionID()};
            c_logger.traceEntry((Object)this, "putTransaction", params);
        }
        Long ID = new Long(transaction.getTransactionID());
        this.m_transactions.put(ID, transaction);
    }

    public ServerTransaction createServerTransaction(SipServletRequestImpl request) {
        ServerTransaction serverTransaction = new ServerTransaction(request.getTransactionId(), request);
        if (request.getTransactionId() != -1L) {
            this.putTransaction(serverTransaction);
        }
        return serverTransaction;
    }

    public ClientTransaction createClientTransaction(SipServletRequestImpl request) {
        return new ClientTransaction(request);
    }

    public static TransactionTable getInstance() {
        return c_transactionTable;
    }

    public boolean removeTransaction(SipTransaction transaction) {
        Long transactionId;
        SipTransaction removedTransaction;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeTransaction", Long.toString(transaction.getTransactionID()));
        }
        return (removedTransaction = (SipTransaction)this.m_transactions.remove(transactionId = new Long(transaction.getTransactionID()))) != null;
    }
}

