/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.RouteHeader;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.message.Request;
import java.io.IOException;
import java.util.List;

public class OutgoingSipServletCancelRequest
extends OutgoingSipServletRequest {
    private static final LogMgr c_logger = Log.get(OutgoingSipServletCancelRequest.class);

    public OutgoingSipServletCancelRequest() {
    }

    public OutgoingSipServletCancelRequest(OutgoingSipServletRequest request) {
        this.generateJainCancelRequest(request);
        TransactionUserWrapper tUser = request.getTransactionUser();
        this.setSipProvider(request.getSipProvider());
        this.setIsInital(false);
        this.setIsCommited(false);
        this.setIsSubsequentRequest(true);
        this.setTransactionUser(tUser);
    }

    private void generateJainCancelRequest(OutgoingSipServletRequest servletRequest) {
        block6: {
            RequestImpl inviteReq = (RequestImpl)servletRequest.getRequest();
            try {
                Header poHeader;
                Header destination;
                HeaderIterator iter;
                URI reqUri = inviteReq.getRequestURI();
                CallIdHeader callHeader = inviteReq.getCallIdHeader();
                CSeqHeader cseq = (CSeqHeader)inviteReq.getCSeqHeader().clone();
                cseq.setMethod("CANCEL");
                FromHeader from = inviteReq.getFromHeader();
                TransactionUserWrapper tu = servletRequest.getTransactionUser();
                ToHeader to = inviteReq.getToHeader();
                List viaList = SIPStackUtil.headerIteratorToList(inviteReq.getViaHeaders());
                Request cancelReq = this.getMessageFactory().createRequest(reqUri, "CANCEL", callHeader, cseq, from, to, viaList);
                if (inviteReq.hasRouteHeaders() && (iter = inviteReq.getRouteHeaders()) != null) {
                    while (iter.hasNext()) {
                        cancelReq.addHeader((RouteHeader)iter.next(), false);
                    }
                }
                if ((destination = servletRequest.getDestinationURI()) != null) {
                    cancelReq.setHeader(destination, true);
                }
                if ((poHeader = servletRequest.getPreferredOutbound()) != null) {
                    cancelReq.setHeader(poHeader, true);
                }
                boolean isLoopBack = inviteReq.isLoopback();
                ((MessageImpl)((Object)cancelReq)).setLoopback(isLoopBack);
                this.setMessage(cancelReq);
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block6;
                c_logger.error("error.exception", "Create", null, (Throwable)e2);
            }
        }
    }

    @Override
    public void setupParametersBeforeSent(SipURL target, boolean isLoopBack) throws IOException {
        TransactionUserWrapper tu = this.getTransactionUser();
        boolean outboundEnable = PropertiesStore.getInstance().getProperties().getBoolean("enableSetOutboundIF");
        String ibmPOHeader = this.getHeader("IBM-PO");
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setupParametersBeforeSent", "current IBM-PO =  " + ibmPOHeader);
        }
        if (!(ibmPOHeader != null && outboundEnable || tu == null)) {
            SipProxyInfo.getInstance().addPreferedOutboundHeader(this, tu.getPreferedOutboundIface(this.getTransport()));
        }
    }

    @Override
    public void updateParamAccordingToDestination() throws IOException {
    }

    @Override
    protected boolean shouldCreateContactIfNotExist() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "shouldCreateContactIfNotExist", "Contact header won't be added to the outgoing CANCEL message");
        }
        return false;
    }
}

