/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.appqueue.MessageDispatchingException;
import com.ibm.ws.sip.container.asynch.AsynchronousWorkTaskFactory;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.osgi.AsynchronousWorkHolder;
import com.ibm.ws.sip.container.osgi.ServletContextManager;
import com.ibm.ws.sip.container.osgi.ServletInstanceHolderFactory;
import com.ibm.ws.sip.container.parser.ServletsInstanceHolder;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.servlets.ServletContextFactoryImpl;
import com.ibm.ws.sip.container.util.SipLogExtension;
import com.ibm.ws.sip.container.was.WASContextEstablisher;
import com.ibm.ws.sip.container.was.WASHttpSessionListener;
import com.ibm.ws.sip.container.was.filters.SipFilter;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import jain.protocol.ip.sip.SipPeerUnavailableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;
import javax.servlet.sip.SipURI;

public class SipAppDescManager {
    private final ReentrantLock appLock = new ReentrantLock();
    private static boolean firstSipAppStarted = false;
    private static final LogMgr c_logger = Log.get(SipAppDescManager.class);
    private static SipAppDescManager s_instance = new SipAppDescManager();
    private ConcurrentHashMap<String, SipAppDesc> _applications = new ConcurrentHashMap();

    public static SipAppDescManager getInstance() {
        return s_instance;
    }

    private SipAppDescManager() {
    }

    public SipAppDesc addNewApp(SipAppDesc appDesc) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "addNewApp", "Adding new application: Name = " + appDesc.getWebAppName() + " Desc = " + appDesc.getDescription());
        }
        SipContainer sipCon = SipContainer.getInstance();
        sipCon.init();
        return this._applications.put(appDesc.getWebAppName(), appDesc);
    }

    public SipAppDesc updateWebApp(WebApp webApp) {
        SipAppDesc appDesc;
        String name = webApp.getName();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "updateWebApp", "Name = " + name);
        }
        if ((appDesc = this._applications.get(name)) != null) {
            appDesc.setWebApp(webApp);
            return appDesc;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "updateWebApp cannot find Sip Application", name);
        }
        return null;
    }

    public void initSipAppIfNeeded(String name) throws ServletException, Throwable {
        SipAppDesc appDesc;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "initSipAppIfNeeded", "Name = " + name);
        }
        if ((appDesc = this._applications.get(name)) == null) {
            if (c_logger.isWarnEnabled()) {
                c_logger.warn("initSipAppIfNeeded cannot find Sip Application", null, name);
            }
            return;
        }
        if (appDesc.getContextEstablisher() != null) {
            return;
        }
        this.appLock.lock();
        try {
            if (appDesc.wasInitialized()) {
                return;
            }
            appDesc.setWasInitialized(true);
            this.initContainerComponentsOnFirstApp();
            this.setWebContainerConfig(appDesc);
        }
        finally {
            this.appLock.unlock();
        }
        WebApp webApp = appDesc.getWebApp();
        WASHttpSessionListener httpSessionListener = null;
        if (!webApp.isInitialized() && !appDesc.isDuringWebAppInitialization()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)null, "initSipAppIfNeeded", "init WebApp " + webApp);
            }
            webApp.initialize();
        }
        if (appDesc.getContextEstablisher() == null) {
            appDesc.setRootURI(webApp.getContextPath());
            appDesc.setIsDistributed(webApp.getWebAppConfig().isDistributable());
            this._applications.get(name).setContextEstablisher(new WASContextEstablisher((IServletContext)webApp));
            httpSessionListener = SipContainer.getHttpSessionListener();
            appDesc.setupSipApplication();
        }
        if (httpSessionListener == null) {
            throw new RuntimeException("Unable to add http session listener");
        }
        webApp.addLifecycleListener(httpSessionListener);
    }

    private EnumSet<DispatcherType> getFilterTypes() {
        ArrayList<DispatcherType> types = new ArrayList<DispatcherType>(5);
        types.add(DispatcherType.ASYNC);
        types.add(DispatcherType.ERROR);
        types.add(DispatcherType.FORWARD);
        types.add(DispatcherType.INCLUDE);
        types.add(DispatcherType.REQUEST);
        return EnumSet.copyOf(types);
    }

    private void createServletsFilter(SipAppDesc sipApp) {
        block5: {
            Iterator<SipServletDesc> itr = sipApp.getSipServlets().iterator();
            WebApp servletContext = sipApp.getWebApp();
            FilterRegistration.Dynamic filterReg = servletContext.addFilter("SipFilter", SipFilter.class.getName());
            EnumSet<DispatcherType> filterTypes = this.getFilterTypes();
            while (itr.hasNext()) {
                SipServletDesc desc = itr.next();
                String name = desc.getName();
                filterReg.addMappingForServletNames(filterTypes, false, new String[]{name});
                if (!c_logger.isTraceDebugEnabled()) continue;
                c_logger.traceDebug(this, "createServletsFilter", "pattern = " + name);
            }
            try {
                List<SipURI> outboundIfList = SipProxyInfo.getInstance().getOutboundInterfaceList();
                if (outboundIfList != null) {
                    servletContext.setAttribute("javax.servlet.sip.outboundInterfaces", outboundIfList);
                } else {
                    servletContext.setAttribute("javax.servlet.sip.outboundInterfaces", new LinkedList());
                }
            }
            catch (Exception e2) {
                if (!c_logger.isTraceDebugEnabled()) break block5;
                c_logger.traceDebug(this, "createServletsFilter", "Error setting the Outbound Interfaces" + e2.getMessage());
            }
        }
    }

    private void setWebContainerConfig(SipAppDesc appDesc) throws ServletException {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setWebContainerConfig: SIP Application: " + appDesc);
        }
        this.createServletsFilter(appDesc);
    }

    private void startSipContainer() throws IllegalStateException, SipPeerUnavailableException, MessageDispatchingException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(null, "startSipContainer");
        }
        ServletInstanceHolderFactory.setInstanceHolder(ServletsInstanceHolder.getInstance());
        AsynchronousWorkHolder.setAsynchWorkInstance(new AsynchronousWorkTaskFactory());
        SipContainer.getInstance().getMessageDispatcher().start();
        ServletContextManager.getInstance().setContextFactory(new ServletContextFactoryImpl());
        SessionRepository.getInstance();
        SipLogExtension.init();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "startSipContainer");
        }
    }

    private void initContainerComponentsOnFirstApp() {
        if (!firstSipAppStarted) {
            firstSipAppStarted = true;
            try {
                this.startSipContainer();
            }
            catch (Throwable e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.initialize.sip.container", "Start", null, e2);
                }
                return;
            }
        } else if (SipContainer.getInstance().getNumOfRunningApplications() == 1) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "starting", "Recreating PMI timers");
            }
            SipLogExtension.init();
            PerformanceMgr perfMgr = PerformanceMgr.getInstance();
            if (perfMgr != null) {
                perfMgr.createPMITimer();
                if (perfMgr.getCurrentServerWeight() == 0) {
                    perfMgr.setServerWeight(-1);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "starting", "returning server weight to dynamic status. new weight: " + perfMgr.getCurrentServerWeight());
                    }
                }
            }
        }
    }

    public Collection<SipAppDesc> getSipAppDescs() {
        return this._applications.values();
    }

    public List<String> getSipAppNames() {
        ArrayList<String> appNames = new ArrayList<String>();
        for (SipAppDesc appDesc : this._applications.values()) {
            appNames.add(appDesc.getApplicationName());
        }
        return appNames;
    }

    public SipAppDesc getSipAppDesc(WebApp webApp) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "getSipAppDesc", "Name = " + webApp.getName());
        }
        return this._applications.get(webApp.getName());
    }

    public SipAppDesc getSipAppDesc(String webAppName) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "getSipAppDesc", "Name = " + webAppName);
        }
        return this._applications.get(webAppName);
    }

    public void removeApp(WebApp webApp) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "removeApp", "Remove application: Name = " + webApp.getName());
        }
        this._applications.remove(webApp.getName());
    }

    public SipAppDesc getSipAppDescByAppName(String name) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "getSipAppDescByAppName", "getSipAppDescByAppName Name = " + name);
        }
        for (SipAppDesc appDesc : this._applications.values()) {
            if (!name.equals(appDesc.getApplicationName())) continue;
            return appDesc;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "getSipAppDescByAppName", "getSipAppDescByAppName No Application was found with the name " + name);
        }
        return null;
    }
}

