/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.protocol;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jain.protocol.ip.sip.address.AddressFactoryImpl;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.ListeningPointUnavailableException;
import jain.protocol.ip.sip.SipEvent;
import jain.protocol.ip.sip.SipFactory;
import jain.protocol.ip.sip.SipListener;
import jain.protocol.ip.sip.SipListenerAlreadyRegisteredException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipPeerUnavailableException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.SipStack;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.util.Iterator;
import java.util.TooManyListenersException;
import java.util.concurrent.locks.ReentrantLock;

public class SipProtocolLayer
implements SipListener {
    private static final TraceComponent tc = Tr.register(SipProtocolLayer.class);
    private static final LogMgr c_logger = Log.get(SipProtocolLayer.class);
    private SipStack m_sipStack;
    private SipRouter m_servletsRouter = SipRouter.getInstance();
    private StackProperties m_stackProperties;
    private boolean m_firstRequestReceived = false;
    private final ReentrantLock m_lock = new ReentrantLock();
    private boolean initialized = false;
    private static volatile SipProtocolLayer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SipProtocolLayer getInstance() {
        SipProtocolLayer theInstance = instance;
        if (theInstance != null) return theInstance;
        Class<SipProtocolLayer> clazz = SipProtocolLayer.class;
        synchronized (SipProtocolLayer.class) {
            theInstance = instance;
            if (theInstance != null) return theInstance;
            instance = theInstance = new SipProtocolLayer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return theInstance;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void init() throws SipPeerUnavailableException {
        try {
            SipFactory.getInstance().setPathName("com.ibm.ws");
            SipPropertiesMap properties = PropertiesStore.getInstance().getProperties();
            try {
                ApplicationProperties.setProperties(properties);
                SipContainerComponent.activateSipStack();
                this.m_sipStack = (SipStack)SipContainerComponent.getSipStackService().getService();
                if (this.m_sipStack == null && c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "init", "SipStack service was not set");
                }
            }
            catch (Throwable e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.sip.stack.exception", "Create", null, e2);
                }
                throw new SipPeerUnavailableException();
            }
            SipFactory jainSipfactory = SipFactory.getInstance();
            this.m_stackProperties = StackProperties.getInstance();
            this.m_stackProperties.setFactories(jainSipfactory.createMessageFactory(), jainSipfactory.createHeaderFactory(), jainSipfactory.createAddressFactory());
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "init", "Sip Protocol Layer Using Sip Stack:" + this.m_sipStack.getStackName());
            }
            SipContainerComponent.startGenericEndpoints();
            PerformanceMgr perfMgr = PerformanceMgr.getInstance();
            if (perfMgr != null) {
                perfMgr.init(properties);
            }
            SipContainerComponent.activatePerfManager();
            this.initialized = true;
        }
        catch (SipPeerUnavailableException e3) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.sip.stack.exception", "Create", null, (Throwable)e3);
            }
            throw e3;
        }
    }

    public void initNewInterfaces(ListeningPoint listeningPoint) {
        this.createSipListeners(listeningPoint);
        this.initOutboundIfaceList(listeningPoint);
    }

    private void initOutboundIfaceList(ListeningPoint listeningPoint) {
        block8: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "initOutboundIfaceList");
            }
            String host = listeningPoint.getHost();
            int port = listeningPoint.getPort();
            String transport = listeningPoint.getTransport();
            try {
                SipURL url = AddressFactoryImpl.createSipURL(null, null, null, host, port, null, null, null, transport);
                SipURIImpl newUri = new SipURIImpl(url);
                if (newUri.getTransportParam().equalsIgnoreCase("udp")) {
                    SipProxyInfo.getInstance().addUdpInterface(newUri);
                } else if (newUri.getTransportParam().equalsIgnoreCase("tcp")) {
                    SipProxyInfo.getInstance().addTcpInterface(newUri);
                } else if (newUri.getTransportParam().equalsIgnoreCase("tls")) {
                    SipProxyInfo.getInstance().addTlsInterface(newUri);
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block8;
                c_logger.error("error.sip.stack.exception", "Create", null, (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSipListeners(ListeningPoint listeningPoint) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "createSipListeners");
        }
        if (c_logger.isInfoEnabled()) {
            Object[] args = new Object[]{listeningPoint.getHost(), new Integer(listeningPoint.getPort()), listeningPoint.getTransport()};
            c_logger.info("info.listening.point", (Object)"Start", args);
        }
        Exception exp = null;
        try {
            SipProvider provider = this.m_sipStack.createSipProvider(listeningPoint);
            provider.addSipListener(this);
            this.m_stackProperties.addProvider(provider);
        }
        catch (ListeningPointUnavailableException e2) {
            exp = e2;
            throw new RuntimeException();
        }
        catch (SipListenerAlreadyRegisteredException e3) {
            exp = e3;
        }
        catch (TooManyListenersException e4) {
            exp = e4;
        }
        finally {
            if (exp != null && c_logger.isErrorEnabled()) {
                c_logger.error("error.sip.stack.exception", "Configure", null, (Throwable)exp);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "createSipListeners");
            }
        }
    }

    @Override
    public void processResponse(SipEvent responseReceivedEvent) {
        Response response = (Response)responseReceivedEvent.getMessage();
        long transactionId = responseReceivedEvent.getTransactionId();
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Transaction: ");
            b.append(transactionId);
            b.append("\r\n");
            b.append(response);
            c_logger.traceDebug(this, "processResponse", b.toString());
        }
        SipProvider provider = (SipProvider)responseReceivedEvent.getSource();
        if (transactionId == -1L) {
            this.m_servletsRouter.handleStrayResponses(response, provider);
        } else {
            IncomingSipServletResponse sipResponse = new IncomingSipServletResponse(response, transactionId, provider);
            if (responseReceivedEvent.getEventId() == 4) {
                SipUtil.setIntenalResponseFlag(sipResponse);
            }
            this.m_servletsRouter.handleResponse(sipResponse);
        }
    }

    @Override
    public void processTimeOut(SipEvent transactionTimeOutEvent) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processTimeOut", "Received a Sip Timeout\n" + transactionTimeOutEvent.getTransactionId());
        }
        long transactionId = transactionTimeOutEvent.getTransactionId();
        this.m_servletsRouter.handleTimeout(transactionId);
    }

    @Override
    public void processRequest(SipEvent requestReceivedEvent) {
        Request request = (Request)requestReceivedEvent.getMessage();
        long transactionId = requestReceivedEvent.getTransactionId();
        SipProvider provider = (SipProvider)requestReceivedEvent.getSource();
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Transaction: ");
            b.append(transactionId);
            b.append("\r\n");
            b.append(requestReceivedEvent.getMessage());
            c_logger.traceDebug(this, "processRequest", b.toString());
        }
        IncomingSipServletRequest sipRequest = new IncomingSipServletRequest(request, transactionId, provider);
        this.m_lock.lock();
        if (!this.m_firstRequestReceived) {
            SipContainerComponent.activateSipApplicationRouter();
            this.m_firstRequestReceived = true;
        }
        this.m_lock.unlock();
        this.m_servletsRouter.handleRequest(sipRequest);
    }

    public void stop() {
    }

    public Iterator getListeningPoints() {
        return this.m_sipStack.getListeningPoints();
    }
}

