/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.naptr;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.naptr.NaptrSenderContainer;
import com.ibm.ws.sip.container.naptr.SendProcessor;
import com.ibm.ws.sip.container.naptr.Sender;
import com.ibm.ws.sip.container.util.ContainerObjectPool;

public class SenderFactory {
    private static final LogMgr c_logger = Log.get(SenderFactory.class);
    private static final String MAX_NAPTR_SENDER_POOL_SIZE = "maxNaptrSenderPoolSize";
    public static ContainerObjectPool s_naptrSenderPool = new ContainerObjectPool(NaptrSenderContainer.class, "maxNaptrSenderPoolSize");

    private SenderFactory() {
    }

    public static SendProcessor getNaptrProcessor(boolean useKnownDestination) {
        if (SipContainerComponent.getDomainResolverService().isNaptrAutoResolveEnabled() && !useKnownDestination) {
            SendProcessor processor = (SendProcessor)s_naptrSenderPool.get();
            processor.setIsPoolable(true);
            return processor;
        }
        return Sender.getInstnace();
    }

    public static void finishToUseSender(SendProcessor sender) {
        if (sender.isPoolable()) {
            sender.cleanItself();
            s_naptrSenderPool.putBack(sender);
        }
    }
}

