/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.appqueue;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.appqueue.MessageDispatchingHandler;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.router.tasks.RequestRoutedTask;
import com.ibm.ws.sip.container.router.tasks.RoutedTask;
import java.util.Timer;
import java.util.TimerTask;

public class MessageDispatcher {
    private static final TraceComponent tc = Tr.register(MessageDispatcher.class);
    private static final LogMgr c_logger = Log.get(MessageDispatcher.class);
    private static long ERR_PRINTOUT_INTERVAL = 1000L;
    private static long _lastErrorPrintoutTime = 0L;
    public static int _shouldPrintQueueState = 0;
    public static int _printTempo = 1000;
    private static Timer s_pmiTimer = new Timer(true);
    private static MessageDispatchingHandler s_messageDispatchingHandler;

    public static void setMessageDispatchingHandler(MessageDispatchingHandler messageDispatchingHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("MessageDispatcher setMessageDispatchingHandler, messageDispatchingHandler=" + messageDispatchingHandler), (Object[])new Object[0]);
        }
        s_messageDispatchingHandler = messageDispatchingHandler;
    }

    public static MessageDispatchingHandler getMessageDispatchingHandler() {
        return s_messageDispatchingHandler;
    }

    public void start() {
        _shouldPrintQueueState = PropertiesStore.getInstance().getProperties().getInt("printQueueStatistic");
        if (_shouldPrintQueueState == 2) {
            _printTempo = PropertiesStore.getInstance().getProperties().getInt("printQueueStatisticTempo");
            s_pmiTimer.schedule((TimerTask)new PrintDispatcherListener(), _printTempo, (long)_printTempo);
        }
        Object[] params = new Object[]{_shouldPrintQueueState, _printTempo};
        c_logger.info("info.sip.queue.stats", (Object)"Report.STATUS", params);
    }

    public void stop() {
        s_messageDispatchingHandler.stop();
    }

    public static void dispatchRoutedTask(RoutedTask task) {
        if (!task.forDispatching()) {
            task.executeOnCurrentThread();
            return;
        }
        if (!s_messageDispatchingHandler.dispatch(task)) {
            RequestRoutedTask requestTask;
            if (c_logger.isErrorEnabled()) {
                MessageDispatcher.printDispatchError(task);
            }
            if (task instanceof RequestRoutedTask && !(requestTask = (RequestRoutedTask)task).isAck()) {
                SipRouter.sendErrorResponse(requestTask.getRequest(), 480);
            }
        }
    }

    private static void printDispatchError(RoutedTask task) {
        if (_lastErrorPrintoutTime < System.currentTimeMillis() - ERR_PRINTOUT_INTERVAL && _lastErrorPrintoutTime < System.currentTimeMillis() - ERR_PRINTOUT_INTERVAL) {
            StringBuffer buff = new StringBuffer();
            buff.append("CWSCT0346E: One container thread queue reached it's maximum capacity");
            buff.append(task.getMethod());
            c_logger.error(buff.toString(), null, null);
            if (_shouldPrintQueueState > 0) {
                MessageDispatcher.printDispatcerInfo();
            }
            _lastErrorPrintoutTime = System.currentTimeMillis();
        }
    }

    private static void printDispatcerInfo() {
        s_messageDispatchingHandler.printState();
    }

    class PrintDispatcherListener
    extends TimerTask {
        PrintDispatcherListener() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    MessageDispatcher.printDispatcerInfo();
                }
                catch (Throwable th) {
                    if (!c_logger.isErrorEnabled()) break block2;
                    c_logger.error("error.exception", null, null, th);
                }
            }
        }
    }
}

