/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl;

import com.ibm.ws.sip.channel.resolver.dns.impl.Dns;
import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.lang.reflect.Constructor;

public class ResourceRecord {
    private Name _name;
    private short _type;
    private short _class;
    private int _ttl;
    private short _rdLength;
    private static final String ARECORD = "ARecord";
    private static final String NSRECORD = "NSRecord";
    private static final String CNAMERECORD = "CNAMERecord";
    private static final String SOARECORD = "SOARecord";
    private static final String PTRRECORD = "PTRRecord";
    private static final String AAAARECORD = "AAAARecord";
    private static final String SRVRECORD = "SRVRecord";
    private static final String NAPTRRECORD = "NAPTRRecord";
    private static final String OPTRECORD = "OPTRecord";

    protected ResourceRecord() {
        this._name = null;
        this._type = 0;
        this._class = 0;
        this._ttl = 0;
        this._rdLength = 0;
    }

    protected ResourceRecord(WsByteBuffer buffer) {
        this._class = buffer.getShort();
        this._ttl = buffer.getInt();
        this._rdLength = buffer.getShort();
    }

    public static ResourceRecord createRecord(Short type) {
        try {
            Class clazz = ResourceRecord.className(type);
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            ResourceRecord rr = (ResourceRecord)constructor.newInstance(new Object[0]);
            rr.setType(type);
            rr.setClassType((short)1);
            return rr;
        }
        catch (Exception e2) {
            System.out.println("ResourceRecord::createRecord Exception: " + e2.getMessage());
            return null;
        }
    }

    protected static ResourceRecord createRecord(WsByteBuffer buffer) {
        Name name = new Name(buffer);
        short type = buffer.getShort();
        try {
            Class clazz = ResourceRecord.className(type);
            ResourceRecord rr = null;
            if (type != 33) {
                Constructor constructor = clazz.getDeclaredConstructor(WsByteBuffer.class);
                rr = (ResourceRecord)constructor.newInstance(buffer);
            } else {
                Constructor constructor = clazz.getDeclaredConstructor(WsByteBuffer.class, Name.class);
                rr = (ResourceRecord)constructor.newInstance(buffer, name);
            }
            rr.setName(name);
            rr.setType(type);
            return rr;
        }
        catch (Exception e2) {
            return null;
        }
    }

    protected void toBuffer(WsByteBuffer buffer) {
        this._name.toBuffer(buffer);
        buffer.putShort(this._type);
        buffer.putShort(this._class);
        buffer.putInt(this._ttl);
        buffer.putShort(this._rdLength);
    }

    public Name getName() {
        return this._name;
    }

    public void setName(Name n) {
        this._name = n;
    }

    public short getType() {
        return this._type;
    }

    public void setType(short s) {
        this._type = s;
    }

    public short getClassType() {
        return this._class;
    }

    public void setClassType(short s) {
        this._class = s;
    }

    public int getTTL() {
        return this._ttl;
    }

    public void setTTL(int i) {
        this._ttl = i;
    }

    public short getrdLength() {
        return this._rdLength;
    }

    public void setrdLength(short s) {
        this._rdLength = s;
    }

    protected static String classNameAsString(Short type) {
        String className = null;
        switch (type) {
            case 1: {
                className = ARECORD;
                break;
            }
            case 2: {
                className = NSRECORD;
                break;
            }
            case 5: {
                className = CNAMERECORD;
                break;
            }
            case 6: {
                className = SOARECORD;
                break;
            }
            case 12: {
                className = PTRRECORD;
                break;
            }
            case 28: {
                className = AAAARECORD;
                break;
            }
            case 33: {
                className = SRVRECORD;
                break;
            }
            case 35: {
                className = NAPTRRECORD;
                break;
            }
            case 41: {
                className = OPTRECORD;
                break;
            }
        }
        return className;
    }

    protected String classNameAsString() {
        String className = null;
        switch (this._type) {
            case 1: {
                className = ARECORD;
                break;
            }
            case 2: {
                className = NSRECORD;
                break;
            }
            case 5: {
                className = CNAMERECORD;
                break;
            }
            case 6: {
                className = SOARECORD;
                break;
            }
            case 12: {
                className = PTRRECORD;
                break;
            }
            case 28: {
                className = AAAARECORD;
                break;
            }
            case 33: {
                className = SRVRECORD;
                break;
            }
            case 35: {
                className = NAPTRRECORD;
                break;
            }
            case 41: {
                className = OPTRECORD;
                break;
            }
        }
        return className;
    }

    public static Class className(Short type) throws ClassNotFoundException {
        String className = "com.ibm.ws.sip.channel.resolver.dns.impl.";
        Class<?> clazz = null;
        className = className + ResourceRecord.classNameAsString(type);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("className exception" + cnfe.getMessage());
        }
        return clazz;
    }

    protected Class className() throws ClassNotFoundException {
        String className = "com.ibm.ws.sip.channel.resolver.dns.impl.";
        className = className + this.classNameAsString();
        return Class.forName(className);
    }

    public String toString() {
        String s = new String();
        s = "    Resource Record: " + Dns.TYPESTRING[this._type] + "\n";
        s = s + "      domain name: " + this._name.toString() + "\n      type:  " + new Short(this._type).toString() + "(" + Dns.TYPESTRING[this._type] + ")\n      class:  " + new Short(this._class).toString() + "\n      ttl:  " + new Integer(this._ttl).toString() + "\n      rdlength:  " + new Short(this._rdLength).toString() + "\n";
        return s;
    }
}

