/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.sip.parser.Coder;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import jain.protocol.ip.sip.Parameters;
import jain.protocol.ip.sip.SipParseException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ParametersImpl
implements Parameters,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 3;
    private ArrayList m_list;

    public ParametersImpl(int initialCapacity) {
        this.m_list = new ArrayList(initialCapacity);
    }

    public ParametersImpl() {
        this(3);
    }

    public Parameter get(int index) {
        return (Parameter)this.m_list.get(index);
    }

    private int indexOf(String key) {
        int size = this.m_list.size();
        for (int i = 0; i < size; ++i) {
            Parameter p = (Parameter)this.m_list.get(i);
            if (!p.m_key.equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    private Parameter get(String key) {
        int size = this.m_list.size();
        for (int i = 0; i < size; ++i) {
            Parameter p = (Parameter)this.m_list.get(i);
            if (!p.m_key.equalsIgnoreCase(key)) continue;
            return p;
        }
        return null;
    }

    public int size() {
        return this.m_list.size();
    }

    @Override
    public String getParameter(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        Parameter p = this.get(name);
        return p == null ? null : p.m_val;
    }

    @Override
    public void setParameter(String name, String value) throws IllegalArgumentException, SipParseException {
        this.setParameter(name, value, false);
    }

    public void setParameter(String name, String value, boolean quote) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        Parameter p = this.get(name);
        if (p == null) {
            p = new Parameter(name, value, quote);
            this.m_list.add(p);
        } else {
            p.m_key = name;
            p.m_val = value;
            p.m_quote = quote;
        }
    }

    @Override
    public boolean hasParameters() {
        return !this.m_list.isEmpty();
    }

    @Override
    public boolean hasParameter(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        return this.get(name) != null;
    }

    @Override
    public void removeParameter(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        int i = this.indexOf(name);
        if (i != -1) {
            this.m_list.remove(i);
        }
    }

    @Override
    public void removeParameters() {
        this.m_list.clear();
    }

    @Override
    public Iterator getParameters() {
        return new ParameterIterator(this.m_list);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParametersImpl)) {
            return false;
        }
        ParametersImpl o = (ParametersImpl)other;
        int nParams = this.m_list.size();
        if (nParams != o.m_list.size()) {
            return false;
        }
        for (int i = 0; i < nParams; ++i) {
            Parameter p1 = (Parameter)this.m_list.get(i);
            Parameter p2 = (Parameter)o.m_list.get(i);
            if (p1.getQuote() != p2.getQuote()) {
                return false;
            }
            if (!p1.equals(p2)) {
                return false;
            }
            if (p1.m_val == null || p1.m_val.length() == 0) {
                if (p2.m_val == null || p2.m_val.length() <= 0) continue;
                return false;
            }
            if (p2.m_val != null && p2.m_val.length() > 0) {
                if (p1.m_val.equals(p2.m_val)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.m_list.size(); ++i) {
            Parameter p = (Parameter)this.m_list.get(i);
            result ^= p.hashCode();
            String val = p.getValue();
            if (val == null || val.length() <= 0) continue;
            result ^= val.hashCode();
        }
        return result;
    }

    public Object clone() {
        ParametersImpl result;
        try {
            result = (ParametersImpl)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
        int nParams = this.m_list.size();
        int capacity = nParams > 3 ? nParams : 3;
        ArrayList<Object> newList = new ArrayList<Object>(capacity);
        for (int i = 0; i < nParams; ++i) {
            Parameter src = (Parameter)this.m_list.get(i);
            Object dst = src.clone();
            newList.add(dst);
        }
        result.m_list = newList;
        return result;
    }

    public void encode(CharsBuffer buffer, char separator, boolean escape) {
        if (this.m_list == null) {
            return;
        }
        int nParams = this.m_list.size();
        for (int i = 0; i < nParams; ++i) {
            Parameter p = (Parameter)this.m_list.get(i);
            String key = p.getKey();
            if (key.length() > 0) {
                buffer.append(key);
                String val = p.getValue();
                boolean hasVal = val != null && val.length() > 0;
                boolean quote = p.getQuote();
                if (quote || hasVal) {
                    buffer.append('=');
                    if (quote) {
                        buffer.append('\"');
                    }
                    if (hasVal) {
                        if (escape && !quote) {
                            Coder.encodeParam(val, buffer);
                        } else {
                            buffer.append(val);
                        }
                    }
                    if (quote) {
                        buffer.append('\"');
                    }
                }
            }
            if (i >= nParams - 1) continue;
            buffer.append(separator);
        }
    }

    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.encode(buffer, ';', false);
        String str = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return str;
    }

    private static class ParameterIterator
    implements Iterator {
        private ArrayList m_list;
        private int m_index;
        private boolean m_canRemove;

        private ParameterIterator(ArrayList list) {
            this.m_list = list;
            this.m_index = 0;
            this.m_canRemove = false;
        }

        @Override
        public boolean hasNext() {
            return this.m_index < this.m_list.size();
        }

        public Object next() {
            try {
                Parameter p = (Parameter)this.m_list.get(this.m_index);
                ++this.m_index;
                this.m_canRemove = true;
                return p.m_key;
            }
            catch (IndexOutOfBoundsException e2) {
                throw new NoSuchElementException(e2.getMessage());
            }
        }

        @Override
        public void remove() {
            if (!this.m_canRemove) {
                throw new IllegalStateException();
            }
            this.m_canRemove = false;
            this.m_list.remove(this.m_index - 1);
            --this.m_index;
        }
    }

    public static class Parameter
    implements Cloneable,
    Serializable {
        private String m_key;
        private String m_val;
        private boolean m_quote;

        private Parameter(String key, String val, boolean quote) {
            this.m_key = key;
            this.m_val = val;
            this.m_quote = quote;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getValue() {
            return this.m_val;
        }

        public boolean getQuote() {
            return this.m_quote;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameter)) {
                return false;
            }
            Parameter p = (Parameter)other;
            return p.m_key.equalsIgnoreCase(this.m_key);
        }

        public int hashCode() {
            int hash = 0;
            int len = this.m_key.length();
            for (int i = 0; i < len; ++i) {
                char c = this.m_key.charAt(i);
                hash = 31 * hash + Character.toLowerCase(c);
            }
            return hash;
        }

        public Object clone() {
            Parameter p;
            try {
                p = (Parameter)super.clone();
                p.m_key = this.m_key;
                p.m_val = this.m_val;
                p.m_quote = this.m_quote;
            }
            catch (CloneNotSupportedException e2) {
                throw new InternalError();
            }
            return p;
        }
    }
}

