/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipDate;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.DateHeader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateHeaderImpl
extends HeaderImpl
implements DateHeader {
    private static final long serialVersionUID = 3833088348064026414L;
    private SipDate m_sipDate;

    @Override
    public Date getDate() {
        if (this.m_sipDate == null) {
            return null;
        }
        return this.m_sipDate.getDate();
    }

    @Override
    public void setDate(Date date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("DateHeader: Null date");
        }
        this.m_sipDate = new SipDate(date);
    }

    @Override
    public void setDate(String date) throws IllegalArgumentException, SipParseException {
        if (date == null) {
            throw new IllegalArgumentException("DateHeader: Null date");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
            Date d = formatter.parse(date);
            this.m_sipDate = new SipDate(d);
        }
        catch (ParseException e2) {
            throw new SipParseException("Wrong date format", date);
        }
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        String date = parser.toString();
        this.setDate(date);
    }

    @Override
    protected void encodeValue(CharsBuffer buf) {
        this.m_sipDate.writeToCharBuffer(buf);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof DateHeaderImpl)) {
            return false;
        }
        DateHeaderImpl o = (DateHeaderImpl)other;
        if (this.m_sipDate == null) {
            return o.m_sipDate == null;
        }
        if (o.m_sipDate == null) {
            return false;
        }
        return this.m_sipDate.equals(o.m_sipDate);
    }

    public void setDate(SipDate date) {
        this.m_sipDate = date;
    }

    @Override
    public String getName() {
        return "Date";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return false;
    }
}

