/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.util.SipStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.ViaHeader;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ListeningPointImpl
implements ListeningPoint {
    private static final LogMgr s_logger = Log.get(ListeningPointImpl.class);
    private static final long serialVersionUID = -2276413619963717197L;
    public static final int DEFAULT_SECURE_PORT = 5061;
    public static final String TRANSPORT_TLS = "tls";
    private String m_host;
    private int m_port;
    private String m_transport;
    private boolean m_isSecure;
    private boolean m_isReliable;
    private String m_channelName;
    private boolean m_isAny;
    private transient SipProvider m_provider;
    private String m_sentBy;
    private String m_callIdValue;

    private final void init(String host, int port, String transport, String channelName) {
        try {
            if (SipStackUtil.isHostName(host)) {
                this.m_host = this.getListeningPointHost(host);
                this.m_isAny = false;
            } else {
                InetAddress address = InetAddressCache.getByName(host);
                if (address.isAnyLocalAddress()) {
                    String localHostName = InetAddress.getLocalHost().getCanonicalHostName();
                    this.m_host = this.getListeningPointHost(localHostName);
                    this.m_isAny = true;
                } else {
                    this.m_host = InetAddressCache.getHostAddress(address);
                    this.m_isAny = false;
                }
            }
        }
        catch (UnknownHostException e2) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "init", e2.getMessage(), e2);
            }
            this.m_host = host;
            this.m_isAny = false;
        }
        if (transport == null) {
            this.m_transport = "udp";
            this.m_isSecure = false;
            this.m_isReliable = false;
        } else if (transport.equalsIgnoreCase("udp")) {
            this.m_transport = "udp";
            this.m_isSecure = false;
            this.m_isReliable = false;
        } else if (transport.equalsIgnoreCase("tcp")) {
            this.m_transport = "tcp";
            this.m_isSecure = false;
            this.m_isReliable = true;
        } else if (transport.equalsIgnoreCase(TRANSPORT_TLS)) {
            this.m_transport = TRANSPORT_TLS;
            this.m_isSecure = true;
            this.m_isReliable = true;
        } else {
            this.m_transport = transport.toLowerCase();
            this.m_isSecure = false;
            this.m_isReliable = true;
        }
        this.m_port = port > 0 ? port : (this.m_isSecure ? 5061 : 5060);
        this.m_sentBy = SIPTransactionStack.instance().getConfiguration().getSentByHost();
        if (this.m_sentBy == null) {
            this.m_sentBy = this.m_host;
        }
        this.m_callIdValue = SIPTransactionStack.instance().getConfiguration().getCallIdValue();
        if (this.m_callIdValue == null) {
            this.m_callIdValue = this.m_host;
        }
        this.m_channelName = channelName;
    }

    private final String getListeningPointHost(String hostName) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(hostName);
        if (addresses.length == 1) {
            return InetAddressCache.getHostAddress(addresses[0].getHostAddress());
        }
        return hostName;
    }

    public ListeningPointImpl(String host, int port, String transport) {
        this.init(host, port, transport, null);
    }

    public ListeningPointImpl(String host, int port, String transport, String channelName) {
        this.init(host, port, transport, channelName);
    }

    public ListeningPointImpl(ViaHeader via) {
        String host = via.getHost();
        int port = via.getPort();
        String transport = via.getTransport();
        this.init(host, port, transport, null);
    }

    public ListeningPointImpl(SipURL address) {
        String host = address.hasMAddr() ? address.getMAddr() : address.getHost();
        boolean isSecure = address.getScheme().equalsIgnoreCase("sips");
        String transport = address.getTransport();
        if (transport == null) {
            transport = isSecure ? TRANSPORT_TLS : "udp";
        }
        int port = address.hasPort() ? address.getPort() : 0;
        this.init(host, port, transport, null);
    }

    @Override
    public boolean isSecure() {
        return this.m_isSecure;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public String getTransport() {
        return this.m_transport;
    }

    @Override
    public String getChannelName() {
        return this.m_channelName;
    }

    @Override
    public String getSentBy() {
        return this.m_sentBy;
    }

    @Override
    public String getCallIdValue() {
        return this.m_callIdValue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.m_isSecure ? "sips" : "sip");
        buf.append(":");
        buf.append(this.m_host);
        buf.append(":");
        buf.append(this.m_port);
        buf.append(";");
        buf.append(this.m_transport);
        return buf.toString();
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public Object clone() {
        try {
            ListeningPointImpl o = (ListeningPointImpl)super.clone();
            o.m_host = this.m_host;
            o.m_port = this.m_port;
            o.m_transport = this.m_transport;
            o.m_isSecure = this.m_isSecure;
            o.m_isReliable = this.m_isReliable;
            o.m_provider = this.m_provider;
            return o;
        }
        catch (CloneNotSupportedException e2) {
            throw new Error("Clone not supported?");
        }
    }

    public SipProvider getProvider() {
        return this.m_provider;
    }

    public void setProvider(SipProvider provider) {
        this.m_provider = provider;
    }

    @Override
    public boolean equals(Object obj) {
        boolean retVal;
        if (obj == this) {
            retVal = true;
        } else if (obj instanceof ListeningPoint) {
            ListeningPointImpl lp = (ListeningPointImpl)obj;
            retVal = lp.m_host.equals(this.m_host) && lp.m_port == this.m_port && lp.m_transport.equals(this.m_transport) && lp.m_isSecure == this.m_isSecure;
        } else {
            retVal = false;
        }
        return retVal;
    }

    public int hashCode() {
        int hash = this.m_isSecure ? -1 : 0;
        hash ^= this.m_host.hashCode();
        hash ^= this.m_port;
        return hash ^= this.m_transport.hashCode();
    }

    public boolean isReliable() {
        return this.m_isReliable;
    }

    public boolean isAnyAddress() {
        return this.m_isAny;
    }
}

