/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.listener.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ejbcontainer.mdb.MDBMessageEndpointFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jbatch.jms.internal.listener.BatchJmsEndpointListener;
import com.ibm.ws.jbatch.jms.internal.listener.impl.BaseMessageEndpointFactory;
import com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor;
import com.ibm.ws.jbatch.jms.internal.listener.impl.ExtendedMessageEndpointHandler;
import com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointHandler;
import com.ibm.ws.jca.service.EndpointActivationService;
import com.ibm.ws.jca.service.WSMessageEndpointFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MessageEndpointFactoryImpl
extends BaseMessageEndpointFactory
implements WSMessageEndpointFactory,
MDBMessageEndpointFactory {
    private static final TraceComponent tc = Tr.register(MessageEndpointFactoryImpl.class, (String)"wsbatch", null);
    private Object activationSpec;
    protected boolean isRRSTransactional = false;
    private int maxEndpoints = 10;
    BatchJmsExecutor.EndpointActivationServiceInfo endpointActivationServiceInfo;
    BatchJmsExecutor.NamedAdminObjectServiceInfo adminObjectServiceInfo;
    boolean runtimeActivated;
    static final long serialVersionUID = 1070502283650752041L;

    public MessageEndpointFactoryImpl(BatchJmsExecutor batchExecutor) throws RemoteException {
        super(batchExecutor);
        this.initProxy();
    }

    /*
     * WARNING - void declaration
     */
    private void initProxy() throws RemoteException {
        Class<?> proxyClass = this.createMessageEndpointProxy();
        try {
            this.ivProxyCTOR = proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"113", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MEF initialization for JmsEndpointListener  with messaging listener interface of  javax.jmx.MessageListener failed.", (Object[])new Object[0]);
            }
            throw new RemoteException("Unable to get Proxy Constructor Method object", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void activateEndpointInternal(EndpointActivationService eas, int maxEndpoints, String destinationJndi) throws ResourceException {
        ResourceException rex;
        block24: {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            Object asInstance = null;
            rex = null;
            try {
                boolean activate;
                Constructor constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    if (this.ivState == 0) {
                        activate = true;
                        this.ivState = 1;
                    } else if (this.ivState == 2) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"endpoint already active", (Object[])new Object[0]);
                        }
                        activate = false;
                    } else {
                        activate = false;
                        rex = new ResourceException("can not activate until deactivate completes");
                    }
                }
                if (!activate) break block24;
                Properties actProp = new Properties();
                String authAlias = null;
                asInstance = eas.activateEndpoint((WSMessageEndpointFactory)this, actProp, authAlias, destinationJndi, null, null);
                Constructor constructor2 = this.ivProxyCTOR;
                synchronized (constructor2) {
                    this.activationSpec = asInstance;
                    this.ivState = (byte)2;
                    this.ivProxyCTOR.notifyAll();
                }
                this.setRRSTransactional();
                this.setMaxEndpoints(maxEndpoints);
            }
            catch (ResourceException actProp) {
                void ex;
                FFDCFilter.processException((Throwable)actProp, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"190", (Object)this, (Object[])new Object[]{eas, maxEndpoints, destinationJndi});
                Constructor authAlias = this.ivProxyCTOR;
                synchronized (authAlias) {
                    this.ivState = 0;
                    this.activationSpec = null;
                    this.unsetRecoveryID();
                }
                rex = ex;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("error activateEndpointInternal " + ex.toString()), (Object[])new Object[0]);
                    Exception link1 = (Exception)ex.getCause();
                    if (link1 != null) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("error activateEndpointInternal link1 " + link1.toString()), (Object[])new Object[0]);
                        Exception link2 = (Exception)link1.getCause();
                        if (link2 != null) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("error activateEndpointInternal link2 " + link2.toString()), (Object[])new Object[0]);
                        }
                    }
                }
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"209", (Object)this, (Object[])new Object[]{eas, maxEndpoints, destinationJndi});
                Constructor constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivState = 0;
                    this.activationSpec = null;
                    this.unsetRecoveryID();
                }
                rex = new ResourceException(ex);
            }
        }
        if (rex != null) {
            throw rex;
        }
    }

    @FFDCIgnore(value={NoSuchMethodException.class})
    private void setRRSTransactional() {
        try {
            this.ivRRSTransactional = (Boolean)this.activationSpec.getClass().getMethod("getRRSTransactional", new Class[0]).invoke(this.activationSpec, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            this.ivRRSTransactional = false;
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"234", (Object)this, (Object[])new Object[0]);
            boolean bl = this.ivRRSTransactional = x == null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(" setRRSTransactional set isRRSTransactional=" + this.isRRSTransactional), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void deactivateEndpointInternal(EndpointActivationService eas) throws ResourceException {
        ResourceException rex = null;
        Constructor constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            if (this.ivState == 2 || this.ivState == 4) {
                this.ivState = (byte)3;
                Object deactivationKey = this.activationSpec;
                if (deactivationKey == null) {
                    this.ivState = 0;
                }
            } else if (this.ivState != 0) {
                throw new ResourceException("illegal state for deactivate");
            }
        }
        if (eas != null && this.isEndpointActive()) {
            try {
                eas.deactivateEndpoint(this.activationSpec, (WSMessageEndpointFactory)this);
            }
            catch (ResourceException resourceException) {
                void ex;
                FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"290", (Object)this, (Object[])new Object[]{eas});
                rex = ex;
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl", (String)"292", (Object)this, (Object[])new Object[]{eas});
                rex = new ResourceException(ex);
            }
        }
        constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            this.activationSpec = null;
            this.unsetRecoveryID();
            this.ivState = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ENDPOINT_DEACTIVATED " + this.getJ2EEName().toString()), (Object[])new Object[0]);
        }
        if (rex != null) {
            throw rex;
        }
    }

    void unsetRecoveryID() {
        this.ivRecoveryId = 0;
        this.ivRecoveryIdKnown = false;
    }

    @Override
    protected boolean isEndpointActive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activationSpec : " + this.activationSpec), (Object[])new Object[0]);
        }
        return this.activationSpec != null;
    }

    protected Class<?> createMessageEndpointProxy() {
        Class[] interfaces = new Class[]{MessageEndpoint.class, MessageListener.class};
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createMessageEndpointProxy: CLASSLOADER= " + BatchJmsEndpointListener.class.getClassLoader()), (Object[])new Object[0]);
        }
        return Proxy.getProxyClass(BatchJmsEndpointListener.class.getClassLoader(), interfaces);
    }

    @Trivial
    public void messageEndpointForcefullyDeactivated() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MessageEndpointHandler createEndpointHandler() {
        MessageEndpointHandler meh = null;
        meh = this.getBatchExecutor().isResourceFactorySet() ? new ExtendedMessageEndpointHandler(this, this.ivRecoveryId, this.ivRRSTransactional) : super.createEndpointHandler();
        return meh;
    }

    @Override
    public J2EEName getJ2EEName() {
        return super.getJ2EEName();
    }

    @Override
    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        return super.createEndpoint(xaResource, 0L);
    }

    private void setMaxEndpoints(int maxEndpoints) {
        this.maxEndpoints = maxEndpoints;
    }

    public int getMaxEndpoints() {
        return this.maxEndpoints;
    }

    public Object getMDBKey() {
        return this.j2eeName;
    }

    public String getActivationSpecId() {
        return this.getBatchExecutor().getEndpointActivationSpecId();
    }

    public String getDestinationId() {
        return this.getBatchExecutor().getEndpointDestinationQueueJndi();
    }

    public void setJCAVersion(int majorJCAVer, int minorJCAVer) {
        this.majorJCAVersion = majorJCAVer;
        this.minorJCAVersion = minorJCAVer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("MessageEndpointFactoryImpl.setJCAVersionJCA: Version " + this.majorJCAVersion + "." + this.minorJCAVersion + " is set"), (Object[])new Object[0]);
        }
    }
}

