/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.listener.impl;

import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.BatchOperationGroup;
import com.ibm.ws.jbatch.jms.internal.listener.impl.MessageEndpointFactoryImpl;
import com.ibm.ws.jca.service.AdminObjectService;
import com.ibm.ws.jca.service.EndpointActivationService;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.rrs.RRSXAResourceFactory;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.jbatch.jms.executor"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={}, property={"service.vendor=IBM"})
public class BatchJmsExecutor {
    private static final TraceComponent tc = Tr.register(BatchJmsExecutor.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.jms.internal.resources.BatchJmsMessages");
    static final String REFERENCE_ENDPOINT_ACTIVATION_SERVICES = "JmsActivationSpec";
    static final String REFERENCE_ADMIN_OBJECT_SERVICES = "JmsQueue";
    static final String OPERATION_GROUP = "operationGroup";
    private ComponentContext cContext = null;
    private final AtomicServiceReference<RRSXAResourceFactory> rrsXAResFactorySvcRef = new AtomicServiceReference("rRSXAResourceFactory");
    private ConnectionFactory jmsCF = null;
    private ResourceFactory jmsConnectionFactory;
    private ResourceConfigFactory resourceConfigFactory;
    private BatchOperationGroup batchOperationGroup;
    private WSJobRepository jobRepo;
    private static final String ACT_SPEC_CFG_ID = "id";
    private static final String ACT_SPEC_CFG_MAX_ENDPOINTS = "maxEndpoints";
    private static final String ADMIN_OBJECT_CFG_ID = "id";
    private static final String ADMIN_OBJECT_CFG_JNDI_NAME = "jndiName";
    private J2EENameFactory j2eeNameFactory = null;
    private J2EEName j2eeName = null;
    private String endpointActivationSpecId = null;
    private String endpointDestinationQueueJndi = null;
    private final Map<String, NamedAdminObjectServiceInfo> adminObjectServices = new HashMap<String, NamedAdminObjectServiceInfo>();
    private final Map<String, EndpointActivationServiceInfo> endpointActivationServices = new HashMap<String, EndpointActivationServiceInfo>();
    private volatile boolean isServerStarted = false;
    private final Set<MessageEndpointFactoryImpl> endpointFactories = new LinkedHashSet<MessageEndpointFactoryImpl>();
    private boolean deactivated = false;
    static final long serialVersionUID = 3595554093309104727L;

    @Reference(service=ResourceConfigFactory.class)
    protected void setResourceConfigFactory(ResourceConfigFactory svc) {
        this.resourceConfigFactory = svc;
    }

    @Reference(target="(id=unbound)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJMSConnectionFactory(ResourceFactory factory, Map<String, String> serviceProps) {
        this.jmsConnectionFactory = factory;
    }

    public BatchOperationGroup getBatchOperationGroup() {
        return this.batchOperationGroup;
    }

    @Reference
    protected void setWSJobRepository(WSJobRepository jobRepository) {
        this.jobRepo = jobRepository;
    }

    public WSJobRepository getWSJobRepository() {
        return this.jobRepo;
    }

    protected void unsetJMSConnectionFactory(ResourceFactory svc) {
        if (svc == this.jmsConnectionFactory) {
            this.jmsConnectionFactory = null;
        }
    }

    protected void unsetResourceConfigFactory(ResourceConfigFactory svc) {
        if (svc == this.resourceConfigFactory) {
            this.resourceConfigFactory = null;
        }
    }

    @Reference(name="rRSXAResourceFactory", service=RRSXAResourceFactory.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setRRSXAResourceFactory(ServiceReference<RRSXAResourceFactory> ref) {
        this.rrsXAResFactorySvcRef.setReference(ref);
    }

    protected void unsetRRSXAResourceFactory(ServiceReference<RRSXAResourceFactory> ref) {
        this.rrsXAResFactorySvcRef.unsetReference(ref);
    }

    public XAResource getRRSXAResource(String activationSpecId, Xid xid) throws XAResourceNotAvailableException {
        return ((RRSXAResourceFactory)this.rrsXAResFactorySvcRef.getServiceWithException()).getTwoPhaseXAResource(xid);
    }

    public boolean isResourceFactorySet() {
        return this.rrsXAResFactorySvcRef.getService() != null;
    }

    @Reference(service=AdminObjectService.class, target="(id=unbound)")
    protected void setJmsQueue(ServiceReference<AdminObjectService> reference) {
        String id = (String)reference.getProperty("id");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addAdminObjectService: id=" + id), (Object[])new Object[0]);
        }
        if (id != null) {
            String jndiName;
            this.endpointDestinationQueueJndi = jndiName = (String)reference.getProperty(ADMIN_OBJECT_CFG_JNDI_NAME);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addAdminObjectService: jndiName=" + jndiName), (Object[])new Object[0]);
            }
            this.addAdminObjectService(reference, id, false);
            if (jndiName != null && !jndiName.equals(id)) {
                this.addAdminObjectService(reference, jndiName, true);
            }
        }
    }

    private synchronized void addAdminObjectService(ServiceReference<AdminObjectService> reference, String id, boolean jndiName) {
        NamedAdminObjectServiceInfo aosInfo = this.createNamedAdminObjectServiceInfo(id);
        aosInfo.getServices(jndiName).addReference(reference);
        ServiceReference<AdminObjectService> oldServiceRef = aosInfo.serviceRef;
        if (aosInfo.updateServiceRef().equals(reference)) {
            if (oldServiceRef != null) {
                this.deactivateEndpoints(aosInfo.endpointFactories);
            }
            this.activateDeferredEndpoints(aosInfo.endpointFactories);
        }
    }

    protected synchronized void unsetJmsQueue(ServiceReference<AdminObjectService> reference) {
        String id = (String)reference.getProperty("id");
        if (id != null) {
            this.removeAdminObjectService(reference, id, false);
            String jndiName = (String)reference.getProperty(ADMIN_OBJECT_CFG_JNDI_NAME);
            if (jndiName != null && !jndiName.equals(id)) {
                this.removeAdminObjectService(reference, jndiName, true);
            }
        }
    }

    protected synchronized void removeAdminObjectService(ServiceReference<AdminObjectService> reference, String id, boolean jndiName) {
        NamedAdminObjectServiceInfo aosInfo = this.adminObjectServices.get(id);
        if (aosInfo != null) {
            aosInfo.getServices(jndiName).removeReference(reference);
            if (reference.equals(aosInfo.serviceRef)) {
                this.deactivateEndpoints(aosInfo.endpointFactories);
                if (aosInfo.updateServiceRef() == null) {
                    this.cleanupAdminObjectServiceInfo(aosInfo);
                } else {
                    this.activateDeferredEndpoints(aosInfo.endpointFactories);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unset reference not the primary reference", (Object[])new Object[0]);
            }
        }
    }

    private synchronized NamedAdminObjectServiceInfo createNamedAdminObjectServiceInfo(String id) {
        NamedAdminObjectServiceInfo aosInfo = this.adminObjectServices.get(id);
        if (aosInfo == null) {
            aosInfo = new NamedAdminObjectServiceInfo(id, (ConcurrentServiceReferenceSet<AdminObjectService>)new ConcurrentServiceReferenceSet(REFERENCE_ADMIN_OBJECT_SERVICES), (ConcurrentServiceReferenceSet<AdminObjectService>)new ConcurrentServiceReferenceSet(REFERENCE_ADMIN_OBJECT_SERVICES));
            this.adminObjectServices.put(id, aosInfo);
        }
        return aosInfo;
    }

    private synchronized void cleanupAdminObjectServiceInfo(NamedAdminObjectServiceInfo aosInfo) {
        if (aosInfo.serviceRef == null && aosInfo.endpointFactories.isEmpty()) {
            this.endpointActivationServices.remove(aosInfo.id);
        }
    }

    @Reference(service=EndpointActivationService.class, target="(id=unbound)")
    protected void setJmsActivationSpec(ServiceReference<EndpointActivationService> reference) {
        String activationSvcId = (String)reference.getProperty("id");
        this.setEndpointActivationSpecId(activationSvcId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("activationSvcId : " + activationSvcId), (Object[])new Object[0]);
        }
        if (activationSvcId != null) {
            EndpointActivationServiceInfo easInfo = this.createEndpointActivationServiceInfo(activationSvcId);
            if (easInfo.service != null) {
                this.deactivateEndpoints(easInfo.endpointFactories);
            }
            easInfo.setReference(reference);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("easInfo=" + easInfo.toString()), (Object[])new Object[0]);
            }
            this.activateDeferredEndpoints(easInfo.endpointFactories);
        }
    }

    protected synchronized void unsetJmsActivationSpec(ServiceReference<EndpointActivationService> reference) {
        EndpointActivationServiceInfo easInfo;
        String activationSvcId = (String)reference.getProperty("id");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activationSvcId : " + activationSvcId), (Object[])new Object[0]);
        }
        if ((easInfo = this.endpointActivationServices.get(activationSvcId)) != null) {
            if (easInfo.serviceRef.equals(reference)) {
                this.deactivateEndpoints(easInfo.endpointFactories);
                easInfo.setReference(null);
                this.cleanupEndpointActivationServiceInfo(easInfo);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unset reference already removed", (Object[])new Object[0]);
            }
        }
    }

    private synchronized EndpointActivationServiceInfo createEndpointActivationServiceInfo(String id) {
        EndpointActivationServiceInfo easInfo = this.endpointActivationServices.get(id);
        if (easInfo == null) {
            easInfo = new EndpointActivationServiceInfo(id);
            this.endpointActivationServices.put(id, easInfo);
        }
        return easInfo;
    }

    private synchronized void cleanupEndpointActivationServiceInfo(EndpointActivationServiceInfo easInfo) {
        if (easInfo.serviceRef == null && easInfo.endpointFactories.isEmpty()) {
            this.endpointActivationServices.remove(easInfo.id);
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        this.isServerStarted = true;
        this.activateDeferredEndpoints(this.endpointFactories);
    }

    protected void unsetServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        this.isServerStarted = false;
    }

    private void setOperationGroupFromConfig(String[] opGroups) {
        BatchOperationGroup newBatchOperationGroup = new BatchOperationGroup();
        if (opGroups != null) {
            for (String group : opGroups) {
                newBatchOperationGroup.addGroup(group);
            }
        }
        this.batchOperationGroup = newBatchOperationGroup;
    }

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) throws Exception {
        if (!FrameworkState.isStopping()) {
            String[] opGroups = (String[])config.get(OPERATION_GROUP);
            this.setOperationGroupFromConfig(opGroups);
            this.cContext = context;
            this.j2eeName = this.j2eeNameFactory.create("JBatchListenerApp", "JBatchListenerModule", "JBatchListenerComp");
            this.rrsXAResFactorySvcRef.activate(context);
            try {
                this.activateEndpoint();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"646", (Object)this, (Object[])new Object[]{context, config});
                Tr.error((TraceComponent)tc, (String)"error.batch.executor.activate.failure", (Object[])new Object[]{e.toString()});
            }
        }
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> config) throws Exception {
        String[] opGroups = (String[])config.get(OPERATION_GROUP);
        this.setOperationGroupFromConfig(opGroups);
    }

    @Deactivate
    protected void deactivate() {
        this.deactivated = true;
    }

    public void setContext(ComponentContext cContext) {
        this.cContext = cContext;
    }

    @Reference
    protected void setJEENameFactory(J2EENameFactory svc) {
        this.j2eeNameFactory = svc;
    }

    synchronized void activateEndpoint(MessageEndpointFactoryImpl mef) throws ResourceException {
        mef.endpointActivationServiceInfo = this.createEndpointActivationServiceInfo(mef.getActivationSpecId());
        mef.endpointActivationServiceInfo.addReferencingEndpoint(mef);
        String destId = mef.getDestinationId();
        if (destId != null) {
            mef.adminObjectServiceInfo = this.createNamedAdminObjectServiceInfo(destId);
            mef.adminObjectServiceInfo.addReferencingEndpoint(mef);
        }
        this.endpointFactories.add(mef);
        this.activateEndpointInternal(mef, true);
    }

    public void activateEndpoint() throws RemoteException, ResourceException {
        MessageEndpointFactoryImpl mef = new MessageEndpointFactoryImpl(this);
        mef.setJ2eeName(this.j2eeName);
        this.activateEndpoint(mef);
    }

    /*
     * WARNING - void declaration
     */
    private void activateDeferredEndpoints(Set<MessageEndpointFactoryImpl> mefs) {
        for (MessageEndpointFactoryImpl mef : mefs) {
            if (!mef.runtimeActivated) {
                try {
                    this.activateEndpointInternal(mef, true);
                }
                catch (Throwable throwable) {
                    void ex;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"740", (Object)this, (Object[])new Object[]{mefs});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Ignoring unexpected exception : " + ex), (Object[])new Object[0]);
                }
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)(mef.toString() + " already activated"), (Object[])new Object[0]);
        }
    }

    private void activateEndpointInternal(MessageEndpointFactoryImpl mef, boolean explicit) throws ResourceException {
        if (mef.adminObjectServiceInfo != null && mef.adminObjectServiceInfo.id.equalsIgnoreCase(this.endpointDestinationQueueJndi) && mef.adminObjectServiceInfo.serviceRef == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The message endpoint for the batch" + mef.getJ2EEName().getComponent() + " JMS listener cannot be activated because the " + mef.adminObjectServiceInfo.id + " destination queue does not exist. The message endpoint will not receive batch JMS messages until the destination queue becomes available."), (Object[])new Object[0]);
            }
            return;
        }
        EndpointActivationService eas = mef.endpointActivationServiceInfo.getService();
        if (eas == null && mef.endpointActivationServiceInfo.id.endsWith(this.getEndpointActivationSpecId())) {
            Tr.warning((TraceComponent)tc, (String)"warning.batch.activation.spec.not.found", (Object[])new Object[]{mef.getJ2EEName().getComponent(), mef.endpointActivationServiceInfo.id});
            return;
        }
        if (!this.isServerStarted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"server is not started", (Object[])new Object[0]);
            }
            return;
        }
        if (mef.endpointActivationServiceInfo.id.endsWith(this.endpointActivationSpecId)) {
            mef.activateEndpointInternal(eas, mef.endpointActivationServiceInfo.getMaxEndpoints(), mef.getDestinationId());
            mef.runtimeActivated = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Batch activation spec is " + mef.endpointActivationServiceInfo.id + " activated"), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ignore non batch activation spec: " + mef.endpointActivationServiceInfo.id + "mef.endpointActivationServiceInfo.id"), (Object[])new Object[0]);
        }
    }

    synchronized void deactivateEndpoint(MessageEndpointFactoryImpl mef) {
        if (mef.adminObjectServiceInfo != null) {
            mef.adminObjectServiceInfo.removeReferencingEndpoint(mef);
            this.cleanupAdminObjectServiceInfo(mef.adminObjectServiceInfo);
        }
        mef.endpointActivationServiceInfo.removeReferencingEndpoint(mef);
        this.cleanupEndpointActivationServiceInfo(mef.endpointActivationServiceInfo);
        this.endpointFactories.remove(mef);
        if (mef.runtimeActivated) {
            this.deactivateEndpointInternal(mef);
        }
    }

    private void deactivateEndpoints(Set<MessageEndpointFactoryImpl> mefs) {
        for (MessageEndpointFactoryImpl mef : mefs) {
            if (!mef.runtimeActivated) continue;
            this.deactivateEndpointInternal(mef);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deactivateEndpointInternal(MessageEndpointFactoryImpl mef) {
        block2: {
            mef.runtimeActivated = false;
            EndpointActivationService eas = mef.endpointActivationServiceInfo.getService();
            try {
                mef.deactivateEndpointInternal(eas);
            }
            catch (Throwable throwable) {
                void ex;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"871", (Object)this, (Object[])new Object[]{mef});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Ignoring unexpected exception : " + ex), (Object[])new Object[0]);
            }
        }
    }

    public String getEndpointActivationSpecId() {
        return this.endpointActivationSpecId;
    }

    public void setEndpointActivationSpecId(String id) {
        this.endpointActivationSpecId = id;
    }

    public String getEndpointDestinationQueueJndi() {
        return this.endpointDestinationQueueJndi;
    }

    protected ConnectionFactory getConnectionFactory() {
        if (this.deactivated) {
            throw new IllegalStateException("Executor = " + this + " has been deactivated, but getConnectionFactory() called.");
        }
        if (this.jmsCF == null) {
            if (this.jmsConnectionFactory != null) {
                this.createConnectionFactoryInstance();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"jmsConnectionFactory not set, exiting", (Object[])new Object[0]);
            }
        }
        return this.jmsCF;
    }

    /*
     * WARNING - void declaration
     */
    private void createConnectionFactoryInstance() {
        try {
            ResourceConfig cfResourceConfig = this.resourceConfigFactory.createResourceConfig(ConnectionFactory.class.getName());
            cfResourceConfig.setResAuthType(0);
            this.jmsCF = (ConnectionFactory)this.jmsConnectionFactory.createResource((ResourceInfo)cfResourceConfig);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jmsConnectionFactory = " + this.jmsConnectionFactory.toString() + ", jmsCf = " + this.jmsCF.toString()), (Object[])new Object[0]);
            }
        }
        catch (Exception cfResourceConfig) {
            void e;
            FFDCFilter.processException((Throwable)cfResourceConfig, (String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor", (String)"947", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"error.batch.executor.jms.create.failure", (Object[])new Object[]{e});
            throw new IllegalStateException("Problem creating batch executor reply CF", (Throwable)e);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class EndpointActivationServiceInfo
    extends ReferencingEndpointFactorySet {
        private ServiceReference<EndpointActivationService> serviceRef;
        private EndpointActivationService service;
        private Integer maxEndpoints;
        static final long serialVersionUID = -6449090627619271096L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public String toString() {
            return "EndpointActivationServiceInfo [serviceRef=" + this.serviceRef + ", service=" + this.service + ", maxEndpoints=" + this.maxEndpoints + ", id=" + this.id + ", endpointFactories=" + this.endpointFactories + "]";
        }

        EndpointActivationServiceInfo(String id) {
            super(id);
        }

        void setReference(ServiceReference<EndpointActivationService> ref) {
            this.serviceRef = ref;
            this.service = null;
            this.maxEndpoints = null;
        }

        EndpointActivationService getService() {
            if (this.serviceRef == null) {
                return null;
            }
            if (this.service == null) {
                this.service = (EndpointActivationService)BatchJmsExecutor.this.cContext.locateService(BatchJmsExecutor.REFERENCE_ENDPOINT_ACTIVATION_SERVICES, this.serviceRef);
            }
            return this.service;
        }

        int getMaxEndpoints() {
            if (this.maxEndpoints == null) {
                this.maxEndpoints = (Integer)this.serviceRef.getProperty(BatchJmsExecutor.ACT_SPEC_CFG_MAX_ENDPOINTS);
            }
            return this.maxEndpoints;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor$EndpointActivationServiceInfo", EndpointActivationServiceInfo.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class NamedAdminObjectServiceInfo
    extends ReferencingEndpointFactorySet {
        private final ConcurrentServiceReferenceSet<AdminObjectService> idServices;
        private final ConcurrentServiceReferenceSet<AdminObjectService> jndiNameServices;
        ServiceReference<AdminObjectService> serviceRef;
        static final long serialVersionUID = -5776002171026532827L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public String toString() {
            return "NamedAdminObjectServiceInfo [idServices=" + this.idServices + ", jndiNameServices=" + this.jndiNameServices + ", serviceRef=" + this.serviceRef + ", id=" + this.id + ", endpointFactories=" + this.endpointFactories + "]";
        }

        NamedAdminObjectServiceInfo(String id, ConcurrentServiceReferenceSet<AdminObjectService> idServices, ConcurrentServiceReferenceSet<AdminObjectService> jndiNameServices) {
            super(id);
            this.idServices = idServices;
            this.jndiNameServices = jndiNameServices;
        }

        ConcurrentServiceReferenceSet<AdminObjectService> getServices(boolean jndiName) {
            return jndiName ? this.jndiNameServices : this.idServices;
        }

        ServiceReference<AdminObjectService> updateServiceRef() {
            this.serviceRef = this.idServices.getHighestRankedReference();
            if (this.serviceRef == null) {
                this.serviceRef = this.jndiNameServices.getHighestRankedReference();
            }
            return this.serviceRef;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor$NamedAdminObjectServiceInfo", NamedAdminObjectServiceInfo.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ReferencingEndpointFactorySet {
        final String id;
        Set<MessageEndpointFactoryImpl> endpointFactories = new LinkedHashSet<MessageEndpointFactoryImpl>();
        static final long serialVersionUID = -3468268824210050687L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ReferencingEndpointFactorySet(String id) {
            this.id = id;
        }

        void addReferencingEndpoint(MessageEndpointFactoryImpl mef) {
            this.endpointFactories.add(mef);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.id + " now has " + this.endpointFactories.size() + " endpoints"), (Object[])new Object[0]);
            }
        }

        void removeReferencingEndpoint(MessageEndpointFactoryImpl mef) {
            this.endpointFactories.remove(mef);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.id + " now has " + this.endpointFactories.size() + " endpoints"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.listener.impl.BatchJmsExecutor$ReferencingEndpointFactorySet", ReferencingEndpointFactorySet.class, (String)"wsbatch", null);
        }
    }
}

