/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.external;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.RemoteEndpointAsyncImpl;
import com.ibm.ws.wsoc.RemoteEndpointBasicImpl;
import com.ibm.ws.wsoc.SendFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RemoteEndpointAsyncExt
implements RemoteEndpoint.Async {
    private RemoteEndpointAsyncImpl asyncImpl = null;
    private RemoteEndpointBasicImpl basicImpl = null;
    static final long serialVersionUID = 367973878776867876L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RemoteEndpointAsyncExt(RemoteEndpointAsyncImpl asyncImpl, RemoteEndpointBasicImpl basicImpl) {
        this.basicImpl = basicImpl;
        this.asyncImpl = asyncImpl;
    }

    public long getSendTimeout() {
        return this.asyncImpl.getSendTimeout();
    }

    public Future<Void> sendBinary(@Sensitive ByteBuffer data) {
        if (data == null) {
            IllegalArgumentException up = new IllegalArgumentException();
            throw up;
        }
        SendFuture future = this.asyncImpl.sendBinary(data);
        return future;
    }

    public void sendBinary(@Sensitive ByteBuffer data, SendHandler handler) {
        if (data == null || handler == null) {
            IllegalArgumentException up = new IllegalArgumentException();
            throw up;
        }
        this.asyncImpl.sendBinary(data, handler);
    }

    public Future<Void> sendObject(@Sensitive Object data) {
        if (data == null) {
            IllegalArgumentException up = new IllegalArgumentException();
            throw up;
        }
        SendFuture future = this.asyncImpl.sendObject(data);
        return future;
    }

    public void sendObject(@Sensitive Object data, SendHandler handler) {
        if (data == null || handler == null) {
            IllegalArgumentException up = new IllegalArgumentException();
            throw up;
        }
        this.asyncImpl.sendObject(data, handler);
    }

    public Future<Void> sendText(@Sensitive String text) {
        if (text == null) {
            IllegalArgumentException up = new IllegalArgumentException();
            throw up;
        }
        SendFuture future = this.asyncImpl.sendText(text);
        return future;
    }

    public void sendText(@Sensitive String text, SendHandler handler) {
        if (text == null || handler == null) {
            IllegalArgumentException up = new IllegalArgumentException();
            throw up;
        }
        this.asyncImpl.sendText(text, handler);
    }

    public void setSendTimeout(long timeoutmillis) {
        this.asyncImpl.setSendTimeout(timeoutmillis);
    }

    public void sendPing(@Sensitive ByteBuffer data) {
        if (data == null) {
            IllegalArgumentException up = new IllegalArgumentException("a null ByteBuffer was passed into the sendPing API");
            throw up;
        }
        if (data.remaining() > 125) {
            IllegalArgumentException up = new IllegalArgumentException("data pass into the sendPing API was too large");
            throw up;
        }
        this.basicImpl.sendBinaryFromAsyncRemote(data, OpcodeType.PING);
    }

    public void sendPong(@Sensitive ByteBuffer data) {
        if (data == null) {
            IllegalArgumentException up = new IllegalArgumentException();
            throw up;
        }
        this.basicImpl.sendBinaryFromAsyncRemote(data, OpcodeType.PONG);
    }

    public void flushBatch() throws IOException {
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void setBatchingAllowed(boolean arg0) throws IOException {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.external.RemoteEndpointAsyncExt", RemoteEndpointAsyncExt.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    }
}

