/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.ws.wsoc.injection.InjectionThings;
import com.ibm.ws.wsoc.util.Utils;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.websocket.CloseReason;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SessionIdleTimeout
implements Runnable {
    private static final TraceComponent tc = Tr.register(SessionIdleTimeout.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    String sessionID = null;
    ScheduledFuture<?> sessionTimeoutFuture = null;
    boolean restartTimer = true;
    WsocConnLink wsocLink;
    long startTime;
    long maxIdleTimeout;
    static final long serialVersionUID = -98580751490332582L;

    public SessionIdleTimeout(String sessionID, long maxIdleTimeout, WsocConnLink wsocLink) {
        this.sessionID = sessionID;
        this.maxIdleTimeout = maxIdleTimeout;
        this.wsocLink = wsocLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartIdleTimeout(long maxIdleTimeout) {
        this.maxIdleTimeout = maxIdleTimeout;
        if (maxIdleTimeout < 1L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Session idle timeout is default which is no time out", (Object[])new Object[0]);
            }
            return;
        }
        String string = this.sessionID;
        synchronized (string) {
            if (this.sessionTimeoutFuture != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"restartIdleTimeout to cancel sessionTimeoutFuture", (Object[])new Object[0]);
                }
                this.sessionTimeoutFuture.cancel(true);
                this.sessionTimeoutFuture = null;
            }
        }
        this.wsocLink.setReadWrite(false);
        long readWriteCheckWakeUpTime = this.calculateReadWriteWakeUpTime();
        this.startTime = System.nanoTime();
        String string2 = this.sessionID;
        synchronized (string2) {
            if (this.restartTimer) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"restartIdleTimeout: schedule new sessionTimeoutFuture", (Object[])new Object[0]);
                }
                this.sessionTimeoutFuture = ServiceManager.getExecutorService().scheduleAtFixedRate(this, readWriteCheckWakeUpTime, readWriteCheckWakeUpTime, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Session idle timeout interval check called for session: " + this.sessionID), (Object[])new Object[0]);
        }
        if (this.wsocLink.isReadWrite()) {
            this.restartIdleTimeout(this.maxIdleTimeout);
        } else if (TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS) >= this.maxIdleTimeout) {
            String closeMsg = Tr.formatMessage((TraceComponent)tc, (String)"maxidletimeout.closesession", (Object[])new Object[]{TimeUnit.SECONDS.convert(this.maxIdleTimeout, TimeUnit.MILLISECONDS)});
            closeMsg = Utils.truncateCloseReason(closeMsg);
            CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, closeMsg);
            InjectionThings it = this.wsocLink.pushContexts();
            try {
                this.close(closeReason);
            }
            finally {
                this.wsocLink.popContexts(it);
            }
        }
    }

    private long calculateReadWriteWakeUpTime() {
        if (this.maxIdleTimeout <= 60000L) {
            return 2000L;
        }
        if (this.maxIdleTimeout >= 60000L && this.maxIdleTimeout <= 600000L) {
            return 4000L;
        }
        return 6000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        String string = this.sessionID;
        synchronized (string) {
            if (this.sessionTimeoutFuture != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cleanup: cancel sessionTimeoutFuture", (Object[])new Object[0]);
                }
                this.sessionTimeoutFuture.cancel(false);
                this.sessionTimeoutFuture = null;
            }
            this.restartTimer = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(CloseReason cr) {
        if (this.wsocLink.checkIfClosingAlready()) {
            String string = this.sessionID;
            synchronized (string) {
                if (this.sessionTimeoutFuture != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close(1): cancel sessionTimeoutFuture", (Object[])new Object[0]);
                    }
                    this.sessionTimeoutFuture.cancel(false);
                    this.sessionTimeoutFuture = null;
                }
                this.restartTimer = false;
            }
            return;
        }
        if (this.wsocLink.finishReadBeforeIdleClose()) {
            this.wsocLink.outgoingCloseConnection(cr);
            String string = this.sessionID;
            synchronized (string) {
                if (this.sessionTimeoutFuture != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close(2): cancel sessionTimeoutFuture", (Object[])new Object[0]);
                    }
                    this.sessionTimeoutFuture.cancel(false);
                    this.sessionTimeoutFuture = null;
                }
                this.restartTimer = false;
            }
        } else {
            this.restartIdleTimeout(this.maxIdleTimeout);
        }
    }
}

