/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1InputStream;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERInputStream;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier;
import com.ibm.ws.transport.iiop.asn1.DEROutputStream;
import com.ibm.ws.transport.iiop.asn1.x509.GeneralName;
import com.ibm.ws.transport.iiop.asn1.x509.X509Name;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidMechanismException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSConfig;
import com.ibm.ws.transport.iiop.security.util.GSSExportedName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.X501DistinguishedNameHelper;
import org.omg.CSI.X509CertificateChainHelper;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.Security.OpaqueHelper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class Util {
    private static final TraceComponent tc = Tr.register(Util.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private static final byte ASN_TAG_NT_EXPORTED_NAME1 = 4;
    private static final byte ASN_TAG_NT_EXPORTED_NAME2 = 1;
    private static final byte ASN_TAG_OID = 6;
    private static final byte ASN_TAG_GSS = 96;
    private static final byte[] ASN_TAG_GSS_BYTE_ARRAY = new byte[]{96};
    private static final Map<String, TSSConfig> tssConfigs = new ConcurrentHashMap<String, TSSConfig>();
    private static final Pattern SCOPED_NAME_EXTRACTION_PATTERN = Pattern.compile("(\\\\\\\\)|(\\\\@)|(@)|(\\z)");
    private static final Pattern SCOPED_NAME_ESCAPE_PATTERN = Pattern.compile("(\\\\)|(@)");
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Map<String, String> specialTypeNames = new HashMap<String, String>();
    private static final Map<String, String> specialTypePackages;
    private static final Set<String> keywords;
    static final long serialVersionUID = -6258364084525786436L;

    public static TSSConfig getRegisteredTSSConfig(String orb_id) {
        return tssConfigs.get(orb_id);
    }

    public static void registerTSSConfig(String orb_id, TSSConfig tssConfig) {
        tssConfigs.put(orb_id, tssConfig);
    }

    public static byte[] encodeOID(String oid) throws IOException {
        oid = oid.startsWith("oid:") ? oid.substring(4) : oid;
        return Util.encodeOID(new DERObjectIdentifier(oid));
    }

    public static byte[] encodeOID(DERObjectIdentifier oid) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(oid);
        return bOut.toByteArray();
    }

    public static String decodeOID(byte[] oid) throws IOException {
        return Util.decodeOIDDERObjectIdentifier(oid).getId();
    }

    public static DERObjectIdentifier decodeOIDDERObjectIdentifier(byte[] oid) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(oid);
        DERInputStream dIn = new DERInputStream(bIn);
        return (DERObjectIdentifier)dIn.readObject();
    }

    public static byte[] encodeGeneralName(String name) throws IOException {
        return Util.encodeGeneralName(new X509Name(name));
    }

    public static byte[] encodeGeneralName(X509Name x509Name) throws IOException {
        return Util.encodeGeneralName(new GeneralName(x509Name));
    }

    public static byte[] encodeGeneralName(GeneralName generalName) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(generalName);
        return bOut.toByteArray();
    }

    public static String decodeGeneralName(byte[] name) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(name);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        DERObject dObj = aIn.readObject();
        aIn.close();
        X509Name xName = X509Name.getInstance((ASN1TaggedObject)dObj, true);
        return xName.toString();
    }

    public static byte[] encodeGSSExportName(String oid, String name) {
        try {
            byte[] oid_arr = Util.encodeOID(oid);
            int oid_len = oid_arr.length;
            byte[] name_arr = name.getBytes("UTF-8");
            int name_len = name_arr.length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(4);
            baos.write(1);
            baos.write((byte)(oid_len & 0xFF00) >> 8);
            baos.write((byte)(oid_len & 0xFF));
            baos.write(oid_arr);
            baos.write((byte)(name_len & 0xFF000000) >> 24);
            baos.write((byte)(name_len & 0xFF0000) >> 16);
            baos.write((byte)(name_len & 0xFF00) >> 8);
            baos.write((byte)(name_len & 0xFF));
            baos.write(name_arr);
            return baos.toByteArray();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"254", null, (Object[])new Object[]{oid, name});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static GSSExportedName decodeGSSExportedName(byte[] name_tok) {
        if (name_tok != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(name_tok);
            try {
                int t2;
                int t1 = bais.read();
                if (t1 == 4 && (t2 = bais.read()) == 1) {
                    int l = bais.read() << 8;
                    byte[] oid_arr = new byte[l += bais.read()];
                    bais.read(oid_arr, 0, l);
                    String oid = Util.decodeOID(oid_arr);
                    int l1 = bais.read();
                    int l2 = bais.read();
                    int l3 = bais.read();
                    int l4 = bais.read();
                    int name_len = (l1 << 24) + (l2 << 16) + (l3 << 8) + l4;
                    byte[] name_arr = new byte[name_len];
                    bais.read(name_arr, 0, name_len);
                    String name = new String(name_arr);
                    return new GSSExportedName(name, oid);
                }
            }
            catch (Exception t1) {
                void ex;
                FFDCFilter.processException((Throwable)t1, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"299", null, (Object[])new Object[]{name_tok});
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static String extractUserNameFromScopedName(byte[] scopedNameBytes) throws UnsupportedEncodingException {
        String scopedUserName = new String(scopedNameBytes, "UTF8");
        return Util.extractUserNameFromScopedName(scopedUserName);
    }

    public static String extractUserNameFromScopedName(String scopedUserName) {
        Matcher m = SCOPED_NAME_EXTRACTION_PATTERN.matcher(scopedUserName);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(buf, "");
            if (m.group(1) != null) {
                buf.append('\\');
                continue;
            }
            if (m.group(2) != null) {
                buf.append("@");
                continue;
            }
            if (m.group(3) == null) continue;
            break;
        }
        return buf.toString();
    }

    public static String buildScopedUserName(String user, String domain) {
        StringBuffer buf = new StringBuffer();
        if (user != null) {
            Util.escape(user, buf);
        }
        if (domain != null) {
            buf.append('@');
            Util.escape(domain, buf);
        }
        return buf.toString();
    }

    private static void escape(String s, StringBuffer buf) {
        Matcher m = SCOPED_NAME_ESCAPE_PATTERN.matcher(s);
        while (m.find()) {
            m.appendReplacement(buf, "");
            if (m.group(1) != null) {
                buf.append("\\\\");
                continue;
            }
            if (m.group(2) == null) continue;
            buf.append("\\@");
        }
        m.appendTail(buf);
    }

    @Sensitive
    public static byte[] encodeGSSUPToken(Codec codec, String user, @Sensitive char[] pwd, String target) {
        byte[] result = null;
        try {
            InitialContextToken init_token = new InitialContextToken();
            init_token.username = user.getBytes("UTF-8");
            init_token.password = Util.getUTF8Bytes(pwd);
            init_token.target_name = Util.encodeGSSExportName("oid:2.23.130.1.1.1".substring(4), target);
            Any a = ORB.init().create_any();
            InitialContextTokenHelper.insert((Any)a, (InitialContextToken)init_token);
            byte[] init_ctx_token = codec.encode_value(a);
            result = Util.createGSSToken(codec, "oid:2.23.130.1.1.1", init_ctx_token);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[4];
            objectArray[0] = codec;
            objectArray[1] = user;
            objectArray[2] = "<sensitive char[]>";
            objectArray[3] = target;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"399", null, (Object[])objectArray);
        }
        return result;
    }

    @Sensitive
    public static byte[] encodeLTPAToken(Codec codec, @Sensitive byte[] ltpaTokenBytes) {
        byte[] result = null;
        try {
            Any a = ORB.init().create_any();
            OpaqueHelper.insert((Any)a, (byte[])ltpaTokenBytes);
            byte[] init_ctx_token = codec.encode_value(a);
            result = Util.createGSSToken(codec, "oid:1.3.18.0.2.30.2", init_ctx_token);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            objectArray[0] = codec;
            objectArray[1] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"418", null, (Object[])objectArray);
        }
        return result;
    }

    @Sensitive
    public static byte[] encodeLTPATokenForWASClassic(Codec codec, @Sensitive byte[] ltpaTokenBytes) {
        byte[] result = null;
        try {
            byte[] innerGSSToken = Util.encodeLTPAToken(codec, ltpaTokenBytes);
            if (innerGSSToken != null) {
                result = Util.createGSSToken(codec, "oid:1.3.18.0.2.30.2", innerGSSToken);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            objectArray[0] = codec;
            objectArray[1] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"440", null, (Object[])objectArray);
        }
        return result;
    }

    @Sensitive
    private static byte[] createGSSToken(Codec codec, String oid, @Sensitive byte[] data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(96);
        byte[] oid_arr = Util.encodeOID(oid);
        Util.writeTokenLength(baos, oid_arr.length + data.length);
        baos.write(oid_arr);
        baos.write(data);
        return baos.toByteArray();
    }

    private static void writeTokenLength(ByteArrayOutputStream baos, int tokenLength) {
        if (tokenLength < 128) {
            baos.write((byte)tokenLength);
        } else if (tokenLength < 256) {
            baos.write(-127);
            baos.write((byte)tokenLength);
        } else if (tokenLength < 65536) {
            baos.write(-126);
            baos.write((byte)(tokenLength >> 8));
            baos.write((byte)tokenLength);
        } else if (tokenLength < 0x1000000) {
            baos.write(-125);
            baos.write((byte)(tokenLength >> 16));
            baos.write((byte)(tokenLength >> 8));
            baos.write((byte)tokenLength);
        } else {
            baos.write(-124);
            baos.write((byte)(tokenLength >> 24));
            baos.write((byte)(tokenLength >> 16));
            baos.write((byte)(tokenLength >> 8));
            baos.write((byte)tokenLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensitive
    private static byte[] getUTF8Bytes(@Sensitive char[] pwd) {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer bb = utf8.encode(CharBuffer.wrap(pwd));
        try {
            bb.rewind();
            byte[] bytes = new byte[bb.limit()];
            bb.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            bb.rewind();
            bb.put(new byte[bb.limit()]);
        }
    }

    public static boolean decodeGSSUPToken(Codec codec, @Sensitive byte[] token_arr, InitialContextToken gssup_tok) {
        boolean result = false;
        if (gssup_tok != null) {
            try {
                Any a;
                InitialContextToken token;
                byte[] data = Util.readGSSTokenData("oid:2.23.130.1.1.1".substring(4), token_arr);
                if (data != null && (token = InitialContextTokenHelper.extract((Any)(a = codec.decode_value(data, InitialContextTokenHelper.type())))) != null) {
                    gssup_tok.username = token.username;
                    gssup_tok.password = token.password;
                    gssup_tok.target_name = Util.decodeGSSExportedName(token.target_name).getName().getBytes("UTF-8");
                    result = true;
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[3];
                objectArray[0] = codec;
                objectArray[1] = "<sensitive byte[]>";
                objectArray[2] = gssup_tok;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"539", null, (Object[])objectArray);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public static byte[] decodeLTPAToken(Codec codec, @Sensitive byte[] token_arr) throws SASException {
        byte[] ltpaTokenBytes = null;
        try {
            byte[] data = Util.readGSSTokenData("oid:1.3.18.0.2.30.2".substring(4), token_arr);
            if (data != null) {
                if (Util.isGSSToken("oid:1.3.18.0.2.30.2".substring(4), data)) {
                    data = Util.readGSSTokenData("oid:1.3.18.0.2.30.2".substring(4), data);
                }
                Any any = codec.decode_value(data, OpaqueHelper.type());
                ltpaTokenBytes = OpaqueHelper.extract((Any)any);
            }
        }
        catch (Exception data) {
            void ex;
            Object[] objectArray = new Object[2];
            objectArray[0] = codec;
            objectArray[1] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)data, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"571", null, (Object[])objectArray);
            throw new SASException(2, (Throwable)ex);
        }
        if (ltpaTokenBytes == null || ltpaTokenBytes.length == 0) {
            throw new SASException(2);
        }
        return ltpaTokenBytes;
    }

    @FFDCIgnore(value={Exception.class})
    public static boolean isGSSToken(String expectedOID, @Sensitive byte[] data) {
        boolean result = false;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        int c = bais.read();
        try {
            if (c == 96) {
                int oid_len;
                String oid;
                int token_len = Util.readTokenLength(bais);
                int oid_tag = bais.read();
                if (oid_tag == 6 && (oid = Util.readOID(bais, oid_len = bais.read())).equals(expectedOID)) {
                    result = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Sensitive
    public static byte[] readGSSTokenData(String expectedOID, @Sensitive byte[] gssToken) throws Exception {
        byte[] data = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(gssToken);
        int c = bais.read();
        if (c == 96) {
            int oid_len;
            String oid;
            int token_len = Util.readTokenLength(bais);
            int oid_tag = bais.read();
            if (oid_tag == 6 && (oid = Util.readOID(bais, oid_len = bais.read())).equals(expectedOID)) {
                int len = token_len - (oid_len + 2);
                data = new byte[len];
                bais.read(data, 0, len);
            }
        }
        return data;
    }

    private static int readTokenLength(ByteArrayInputStream bais) {
        int tokenLength = 0;
        byte lengthMarker = (byte)bais.read();
        if (lengthMarker == -127) {
            int firstByte;
            tokenLength = firstByte = bais.read();
        } else if (lengthMarker == -126) {
            int secondByte = bais.read();
            int firstByte = bais.read();
            tokenLength = (secondByte << 8) + firstByte;
        } else if (lengthMarker == -125) {
            int thirdByte = bais.read();
            int secondByte = bais.read();
            int firstByte = bais.read();
            tokenLength = (thirdByte << 16) + (secondByte << 8) + firstByte;
        } else if (lengthMarker == -124) {
            int fourthByte = bais.read();
            int thirdByte = bais.read();
            int secondByte = bais.read();
            int firstByte = bais.read();
            tokenLength = (fourthByte << 24) + (thirdByte << 16) + (secondByte << 8) + firstByte;
        } else {
            tokenLength = lengthMarker;
        }
        return tokenLength;
    }

    private static String readOID(ByteArrayInputStream bais, int oid_len) throws IOException {
        byte[] oid_tmp_arr = new byte[oid_len];
        bais.read(oid_tmp_arr, 0, oid_len);
        byte[] oid_arr = new byte[oid_len + 2];
        oid_arr[0] = 6;
        oid_arr[1] = (byte)oid_len;
        System.arraycopy(oid_tmp_arr, 0, oid_arr, 2, oid_len);
        return Util.decodeOID(oid_arr);
    }

    public static byte[] encodeDN(Codec codec, String distinguishedName) throws Exception {
        X500Principal issuer = new X500Principal(distinguishedName);
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setIssuer(issuer);
        byte[] asnX501DN = certSelector.getIssuerAsBytes();
        Any a = ORB.init().create_any();
        X501DistinguishedNameHelper.insert((Any)a, (byte[])asnX501DN);
        return codec.encode_value(a);
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeDN(Codec codec, byte[] encodedDN) throws SASException {
        String dn = null;
        try {
            Any any = codec.decode_value(encodedDN, X501DistinguishedNameHelper.type());
            byte[] asnX501DN = X501DistinguishedNameHelper.extract((Any)any);
            X500Principal x500Principal = new X500Principal(asnX501DN);
            dn = x500Principal.toString();
        }
        catch (Exception any) {
            void e;
            FFDCFilter.processException((Throwable)any, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"722", null, (Object[])new Object[]{codec, encodedDN});
            throw new SASException(1, (Throwable)e);
        }
        return dn;
    }

    @Sensitive
    public static byte[] encodeCertChain(Codec codec, @Sensitive X509Certificate[] certificateChain) {
        byte[] result = null;
        try {
            if (certificateChain != null) {
                List<X509Certificate> certList = Util.getCertChainAsListWithoutDuplicates(certificateChain);
                CertificateFactory cfx = CertificateFactory.getInstance("X.509");
                CertPath certPath = cfx.generateCertPath(certList);
                Any any = ORB.init().create_any();
                X509CertificateChainHelper.insert((Any)any, (byte[])certPath.getEncoded());
                result = codec.encode_value(any);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            objectArray[0] = codec;
            objectArray[1] = "<sensitive java.security.cert.X509Certificate[]>";
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"751", null, (Object[])objectArray);
        }
        return result;
    }

    @Sensitive
    private static List<X509Certificate> getCertChainAsListWithoutDuplicates(@Sensitive X509Certificate[] certificateChain) throws CertificateException, CertificateEncodingException {
        ArrayList<X509Certificate> certChainAsList = new ArrayList<X509Certificate>(certificateChain.length);
        HashSet<X509Certificate> uniqueCertificates = new HashSet<X509Certificate>(certificateChain.length);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < certificateChain.length; ++i) {
            ByteArrayInputStream bais = new ByteArrayInputStream(certificateChain[i].getEncoded());
            X509Certificate tmpClientCert = (X509Certificate)certificateFactory.generateCertificate(bais);
            if (!uniqueCertificates.add(tmpClientCert)) continue;
            certChainAsList.add(tmpClientCert);
        }
        return certChainAsList;
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public static X509Certificate[] decodeCertChain(Codec codec, @Sensitive byte[] encodedCertChain) throws SASException {
        X509Certificate[] certificateChain = null;
        try {
            Any any = codec.decode_value(encodedCertChain, X509CertificateChainHelper.type());
            byte[] decodedCertificateChain = X509CertificateChainHelper.extract((Any)any);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(decodedCertificateChain);
            CertPath certPath = certificateFactory.generateCertPath(bais);
            List<? extends Certificate> certificates = certPath.getCertificates();
            certificateChain = new X509Certificate[certificates.size()];
            for (int i = 0; i < certificates.size(); ++i) {
                certificateChain[i] = (X509Certificate)certificates.get(i);
            }
        }
        catch (Exception any) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = codec;
            objectArray[1] = "<sensitive byte[]>";
            FFDCFilter.processException((Throwable)any, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"801", null, (Object[])objectArray);
            throw new SASException(1, (Throwable)e);
        }
        return certificateChain;
    }

    public static String byteToString(byte[] data) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            buffer.append(HEXCHAR[data[i] >>> 4 & 0xF]);
            buffer.append(HEXCHAR[data[i] & 0xF]);
        }
        return buffer.toString();
    }

    public static void throwException(Method method, InputStream in) throws Throwable {
        String id = in.read_string();
        if (!id.startsWith("IDL:")) {
            Tr.error((TraceComponent)tc, (String)("Malformed exception id: " + id), (Object[])new Object[0]);
            return;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            Class<?> exceptionType = exceptionTypes[i];
            String exceptionId = Util.getExceptionId(exceptionType);
            if (!id.equals(exceptionId)) continue;
            throw (Throwable)in.read_value(exceptionType);
        }
        throw new UnexpectedException(id);
    }

    public static OutputStream writeUserException(Method method, ResponseHandler reply, Exception exception) throws Exception {
        if (exception instanceof RuntimeException || exception instanceof RemoteException) {
            throw exception;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            Class<?> exceptionType = exceptionTypes[i];
            if (!exceptionType.isInstance(exception)) continue;
            OutputStream out = (OutputStream)reply.createExceptionReply();
            String exceptionId = Util.getExceptionId(exceptionType);
            out.write_string(exceptionId);
            out.write_value((Serializable)exception);
            return out;
        }
        throw exception;
    }

    private static String getExceptionId(Class<?> exceptionType) {
        String exceptionName = exceptionType.getName().replace('.', '/');
        if (exceptionName.endsWith("Exception")) {
            exceptionName = exceptionName.substring(0, exceptionName.length() - "Exception".length());
        }
        exceptionName = exceptionName + "Ex";
        String exceptionId = "IDL:" + exceptionName + ":1.0";
        return exceptionId;
    }

    public static String[] createCorbaIds(Class<?> type) {
        LinkedList<String> ids = new LinkedList<String>();
        for (Class<?> superInterface : Util.getAllInterfaces(type)) {
            if (!Remote.class.isAssignableFrom(superInterface) || superInterface == Remote.class) continue;
            ids.add("RMI:" + superInterface.getName() + ":0000000000000000");
        }
        return ids.toArray(new String[ids.size()]);
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> intfClass) {
        LinkedHashSet allInterfaces = new LinkedHashSet();
        LinkedList stack = new LinkedList();
        stack.addFirst(intfClass);
        while (!stack.isEmpty()) {
            Class intf = (Class)stack.removeFirst();
            allInterfaces.add(intf);
            stack.addAll(0, Arrays.asList(intf.getInterfaces()));
        }
        return allInterfaces;
    }

    public static Map<Method, String> mapMethodToOperation(Class<?> intfClass) {
        HashMap<Method, String> methodToOperation = new HashMap<Method, String>();
        Util.iiopMap(intfClass, methodToOperation, null);
        return methodToOperation;
    }

    public static Map<String, Method> mapOperationToMethod(Class<?> intfClass) {
        HashMap<String, Method> operationToMethod = new HashMap<String, Method>();
        Util.iiopMap(intfClass, null, operationToMethod);
        return operationToMethod;
    }

    private static void iiopMap(Class<?> intfClass, HashMap<Method, String> methodToOperation, HashMap<String, Method> operationToMethod) {
        Class<?> exceptionType;
        Class<?>[] exceptionTypes;
        boolean exceptionsValid;
        Method[] methods = Util.getAllMethods(intfClass);
        HashMap<Method, String> getterByMethod = new HashMap<Method, String>(methods.length);
        HashMap<String, Method> getterByName = new HashMap<String, Method>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String verb;
            Method method = methods[i];
            String methodName = method.getName();
            if (method.getParameterTypes().length != 0) continue;
            if (methodName.startsWith("get") && methodName.length() > 3 && method.getReturnType() != Void.TYPE) {
                verb = "get";
            } else {
                if (!methodName.startsWith("is") || methodName.length() <= 2 || method.getReturnType() != Boolean.TYPE) continue;
                verb = "is";
            }
            exceptionsValid = true;
            exceptionTypes = method.getExceptionTypes();
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionType = exceptionTypes[j];
                if (RemoteException.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
                exceptionsValid = false;
                break;
            }
            if (!exceptionsValid) continue;
            String propertyName = methodName.length() > verb.length() + 1 && Character.isUpperCase(methodName.charAt(verb.length() + 1)) ? methodName.substring(verb.length()) : Character.toLowerCase(methodName.charAt(verb.length())) + methodName.substring(verb.length() + 1);
            getterByMethod.put(method, propertyName);
            getterByName.put(propertyName, method);
        }
        HashMap<Method, String> setterByMethod = new HashMap<Method, String>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method getter;
            Method method = methods[i];
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !methodName.startsWith("set") || methodName.length() <= 3) continue;
            exceptionsValid = true;
            exceptionTypes = method.getExceptionTypes();
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionType = exceptionTypes[j];
                if (RemoteException.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
                exceptionsValid = false;
                break;
            }
            if (!exceptionsValid || (getter = (Method)getterByName.get(propertyName = methodName.length() > 4 && Character.isUpperCase(methodName.charAt(4)) ? methodName.substring(3) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4))) == null || !method.getParameterTypes()[0].equals(getter.getReturnType())) continue;
            setterByMethod.put(method, propertyName);
        }
        HashMap<String, LinkedList<Method>> overloadedMethods = new HashMap<String, LinkedList<Method>>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (getterByMethod.containsKey(method) || setterByMethod.containsKey(method)) continue;
            String methodName = method.getName();
            LinkedList<Method> methodList = (LinkedList<Method>)overloadedMethods.get(methodName);
            if (methodList == null) {
                methodList = new LinkedList<Method>();
                overloadedMethods.put(methodName, methodList);
            }
            methodList.add(method);
        }
        HashMap<String, HashSet<String>> caseCollisionMethods = new HashMap<String, HashSet<String>>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (getterByMethod.containsKey(method) || setterByMethod.containsKey(method)) continue;
            String lowerCaseMethodName = method.getName().toLowerCase();
            HashSet<String> methodSet = (HashSet<String>)caseCollisionMethods.get(lowerCaseMethodName);
            if (methodSet == null) {
                methodSet = new HashSet<String>();
                caseCollisionMethods.put(lowerCaseMethodName, methodSet);
            }
            methodSet.add(method.getName());
        }
        String className = Util.getClassName(intfClass);
        for (int i = 0; i < methods.length; ++i) {
            List overloads;
            Method method = methods[i];
            String iiopName = (String)getterByMethod.get(method);
            if (iiopName != null) {
                iiopName = iiopName.charAt(0) == '_' ? "J_get_" + iiopName.substring(1) : "_get_" + iiopName;
            } else {
                iiopName = (String)setterByMethod.get(method);
                if (iiopName != null) {
                    iiopName = iiopName.charAt(0) == '_' ? "J_set_" + iiopName.substring(1) : "_set_" + iiopName;
                } else {
                    iiopName = method.getName();
                    if (iiopName.charAt(0) == '_') {
                        iiopName = "J" + iiopName;
                    }
                }
            }
            Set caseCollisions = (Set)caseCollisionMethods.get(method.getName().toLowerCase());
            if (caseCollisions != null && caseCollisions.size() > 1) {
                iiopName = iiopName + Util.upperCaseIndexString(iiopName);
            }
            if ((overloads = (List)overloadedMethods.get(method.getName())) != null && overloads.size() > 1) {
                iiopName = iiopName + Util.buildOverloadParameterString(method.getParameterTypes());
            }
            if (keywords.contains((iiopName = Util.replace(iiopName, '$', "U0024")).toLowerCase())) {
                iiopName = "_" + iiopName;
            }
            if (iiopName.equalsIgnoreCase(className)) {
                iiopName = iiopName + "_";
            }
            if (operationToMethod != null) {
                operationToMethod.put(iiopName, method);
            }
            if (methodToOperation == null) continue;
            methodToOperation.put(method, iiopName);
        }
    }

    private static Method[] getAllMethods(Class<?> intfClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class<?> intf : Util.getAllInterfaces(intfClass)) {
            methods.addAll(Arrays.asList(intf.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private static String upperCaseIndexString(String iiopName) {
        StringBuilder StringBuilder2 = new StringBuilder();
        for (int i = 0; i < iiopName.length(); ++i) {
            char c = iiopName.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            StringBuilder2.append('_').append(i);
        }
        return StringBuilder2.toString();
    }

    private static String replace(String source, char oldChar, String newString) {
        StringBuilder StringBuilder2 = new StringBuilder(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == oldChar) {
                StringBuilder2.append(newString);
                continue;
            }
            StringBuilder2.append(c);
        }
        return StringBuilder2.toString();
    }

    private static String buildOverloadParameterString(Class<?>[] parameterTypes) {
        StringBuilder name = new StringBuilder();
        if (parameterTypes.length == 0) {
            name.append("__");
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                name.append(Util.buildOverloadParameterString(parameterType));
            }
        }
        int index = -1;
        while ((index = name.indexOf(".", index)) > -1) {
            name.setCharAt(index, '_');
        }
        return name.toString();
    }

    private static String buildOverloadParameterString(Class<?> parameterType) {
        String className;
        String packageName;
        String name = "_";
        int arrayDimensions = 0;
        while (parameterType.isArray()) {
            ++arrayDimensions;
            parameterType = parameterType.getComponentType();
        }
        if (arrayDimensions > 0) {
            name = name + "_org_omg_boxedRMI";
        }
        if (IDLEntity.class.isAssignableFrom(parameterType)) {
            name = name + "_org_omg_boxedIDL";
        }
        if ((packageName = specialTypePackages.get(parameterType.getName())) == null) {
            packageName = Util.getPackageName(parameterType.getName());
        }
        if (packageName.length() > 0) {
            name = name + "_" + packageName;
        }
        if (arrayDimensions > 0) {
            name = name + "_seq" + arrayDimensions;
        }
        if ((className = specialTypeNames.get(parameterType.getName())) == null) {
            className = Util.buildClassName(parameterType);
        }
        name = name + "_" + className;
        return name;
    }

    private static String buildClassName(Class<?> type) {
        if (type.isArray()) {
            throw new IllegalArgumentException("type is an array: " + type);
        }
        String typeName = type.getName();
        int endIndex = typeName.lastIndexOf(46);
        if (endIndex < 0) {
            return typeName;
        }
        StringBuilder className = new StringBuilder(typeName.substring(endIndex + 1));
        if (type.getDeclaringClass() != null) {
            String declaringClassName = Util.getClassName(type.getDeclaringClass());
            assert (className.toString().startsWith(declaringClassName + "$"));
            className.replace(declaringClassName.length(), declaringClassName.length() + 1, "__");
        }
        if (className.charAt(0) == '_') {
            className.insert(0, "J");
        }
        return className.toString();
    }

    private static String getClassName(Class<?> type) {
        if (type.isArray()) {
            throw new IllegalArgumentException("type is an array: " + type);
        }
        String typeName = type.getName();
        int endIndex = typeName.lastIndexOf(46);
        if (endIndex < 0) {
            return typeName;
        }
        return typeName.substring(endIndex + 1);
    }

    private static String getPackageName(String interfaceName) {
        int endIndex = interfaceName.lastIndexOf(46);
        if (endIndex < 0) {
            return "";
        }
        return interfaceName.substring(0, endIndex);
    }

    public static String getMechOidFromAuthToken(Codec codec, EstablishContext msg) throws SASException {
        String mechOid;
        if (msg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"establish context is null", (Object[])new Object[0]);
            }
            return null;
        }
        byte[] authToken = msg.client_authentication_token;
        if (authToken == null || authToken.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"authToken is null or blank", (Object[])new Object[0]);
            }
            return null;
        }
        int i = 0;
        if (authToken[i] != ASN_TAG_GSS_BYTE_ARRAY[0]) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid token form encountered.", (Object[])new Object[0]);
            }
            throw new SASInvalidMechanismException();
        }
        int fullTokenLen = 0;
        if (authToken[++i] == -127) {
            fullTokenLen = authToken[i + 1] & 0xFF;
            i += 2;
        } else if (authToken[i] == -126) {
            fullTokenLen = ((authToken[i + 1] & 0xFF) << 8) + (authToken[i + 2] & 0xFF);
            i += 3;
        } else if (authToken[i] == -125) {
            fullTokenLen = ((authToken[i + 1] & 0xFF) << 16) + ((authToken[i + 2] & 0xFF) << 8) + (authToken[i + 3] & 0xFF);
            i += 4;
        } else if (authToken[i] == -124) {
            fullTokenLen = ((authToken[i + 1] & 0xFF) << 24) + ((authToken[i + 2] & 0xFF) << 16) + ((authToken[i + 3] & 0xFF) << 8) + (authToken[i + 4] & 0xFF);
            i += 5;
        } else {
            fullTokenLen = authToken[i];
            ++i;
        }
        if (fullTokenLen > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Full token length: " + fullTokenLen), (Object[])new Object[0]);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid full token length: " + fullTokenLen), (Object[])new Object[0]);
            }
            return null;
        }
        if (authToken[i] != 6) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid OID encountered.", (Object[])new Object[0]);
            }
            throw new SASInvalidMechanismException();
        }
        int oidstart = i++;
        int oidLen = 0;
        if (authToken[i] == -127) {
            oidLen = authToken[i + 1] & 0xFF;
            i += 2;
        } else if (authToken[i] == -126) {
            oidLen = ((authToken[i + 1] & 0xFF) << 8) + (authToken[i + 2] & 0xFF);
            i += 3;
        } else if (authToken[i] == -125) {
            oidLen = ((authToken[i + 1] & 0xFF) << 16) + ((authToken[i + 2] & 0xFF) << 8) + (authToken[i + 3] & 0xFF);
            i += 4;
        } else if (authToken[i] == -124) {
            oidLen = ((authToken[i + 1] & 0xFF) << 24) + ((authToken[i + 2] & 0xFF) << 16) + ((authToken[i + 3] & 0xFF) << 8) + (authToken[i + 4] & 0xFF);
            i += 5;
        } else {
            oidLen = authToken[i];
            ++i;
        }
        if (oidLen > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("OID length: " + oidLen), (Object[])new Object[0]);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid OID length: " + oidLen), (Object[])new Object[0]);
            }
            throw new SASInvalidMechanismException();
        }
        byte[] derOID = new byte[oidLen + 2];
        System.arraycopy(authToken, oidstart, derOID, 0, oidLen + 2);
        try {
            mechOid = Util.decodeOID(derOID);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.transport.iiop.security.util.Util", (String)"1513", null, (Object[])new Object[]{codec, msg});
            throw new SASInvalidMechanismException();
        }
        return "oid:" + mechOid;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        specialTypeNames.put("boolean", "boolean");
        specialTypeNames.put("char", "wchar");
        specialTypeNames.put("byte", "octet");
        specialTypeNames.put("short", "short");
        specialTypeNames.put("int", "long");
        specialTypeNames.put("long", "long_long");
        specialTypeNames.put("float", "float");
        specialTypeNames.put("double", "double");
        specialTypeNames.put("java.lang.Class", "ClassDesc");
        specialTypeNames.put("java.lang.String", "WStringValue");
        specialTypeNames.put("org.omg.CORBA.Object", "Object");
        specialTypePackages = new HashMap<String, String>();
        specialTypePackages.put("boolean", "");
        specialTypePackages.put("char", "");
        specialTypePackages.put("byte", "");
        specialTypePackages.put("short", "");
        specialTypePackages.put("int", "");
        specialTypePackages.put("long", "");
        specialTypePackages.put("float", "");
        specialTypePackages.put("double", "");
        specialTypePackages.put("java.lang.Class", "javax.rmi.CORBA");
        specialTypePackages.put("java.lang.String", "CORBA");
        specialTypePackages.put("org.omg.CORBA.Object", "");
        keywords = new HashSet<String>();
        keywords.add("abstract");
        keywords.add("any");
        keywords.add("attribute");
        keywords.add("boolean");
        keywords.add("case");
        keywords.add("char");
        keywords.add("const");
        keywords.add("context");
        keywords.add("custom");
        keywords.add("default");
        keywords.add("double");
        keywords.add("enum");
        keywords.add("exception");
        keywords.add("factory");
        keywords.add("false");
        keywords.add("fixed");
        keywords.add("float");
        keywords.add("in");
        keywords.add("inout");
        keywords.add("interface");
        keywords.add("long");
        keywords.add("module");
        keywords.add("native");
        keywords.add("object");
        keywords.add("octet");
        keywords.add("oneway");
        keywords.add("out");
        keywords.add("private");
        keywords.add("public");
        keywords.add("raises");
        keywords.add("readonly");
        keywords.add("sequence");
        keywords.add("short");
        keywords.add("string");
        keywords.add("struct");
        keywords.add("supports");
        keywords.add("switch");
        keywords.add("true");
        keywords.add("truncatable");
        keywords.add("typedef");
        keywords.add("union");
        keywords.add("unsigned");
        keywords.add("valuebase");
        keywords.add("valuetype");
        keywords.add("void");
        keywords.add("wchar");
        keywords.add("wstring");
    }
}

