/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidEvidenceException;
import com.ibm.ws.transport.iiop.security.config.ConfigUtil;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TSSSSLTransportConfig
extends TSSTransportMechConfig {
    private static final TraceComponent tc = Tr.register(TSSSSLTransportConfig.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private transient Authenticator authenticator;
    private TransportAddress[] transportAddresses;
    private short handshakeTimeout = (short)-1;
    private short supports;
    private short requires;
    static final long serialVersionUID = -4912661872009340581L;

    public TSSSSLTransportConfig() {
    }

    public TSSSSLTransportConfig(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.transportAddresses = new TransportAddress[0];
    }

    public TSSSSLTransportConfig(TaggedComponent component, Codec codec) throws UserException {
        Any any = codec.decode_value(component.component_data, TLS_SEC_TRANSHelper.type());
        TLS_SEC_TRANS tst = TLS_SEC_TRANSHelper.extract((Any)any);
        this.supports = tst.target_supports;
        this.requires = tst.target_requires;
        this.transportAddresses = tst.addresses;
    }

    public void setTransportAddresses(List<TransportAddress> addrs) {
        this.transportAddresses = addrs.toArray(new TransportAddress[addrs.size()]);
    }

    public TransportAddress[] getTransportAddresses() {
        return (TransportAddress[])this.transportAddresses.clone();
    }

    public short getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public void setHandshakeTimeout(short handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public short getSupports() {
        return this.supports;
    }

    public void setSupports(short supports) {
        this.supports = supports;
    }

    @Override
    public short getRequires() {
        return this.requires;
    }

    public void setRequires(short requires) {
        this.requires = requires;
    }

    @Override
    public TaggedComponent encodeIOR(Codec codec) {
        TaggedComponent result = new TaggedComponent();
        TLS_SEC_TRANS tst = new TLS_SEC_TRANS();
        tst.target_supports = this.supports;
        tst.target_requires = this.requires;
        tst.addresses = this.transportAddresses;
        try {
            Any any = ORB.init().create_any();
            TLS_SEC_TRANSHelper.insert((Any)any, (TLS_SEC_TRANS)tst);
            result.tag = 36;
            result.component_data = codec.encode_value(any);
        }
        catch (Exception any) {
            FFDCFilter.processException((Throwable)any, (String)"com.ibm.ws.transport.iiop.security.config.tss.TSSSSLTransportConfig", (String)"135", (Object)this, (Object[])new Object[]{codec});
            Tr.error((TraceComponent)tc, (String)"Error enncoding transport tagged component, defaulting encoding to NULL", (Object[])new Object[0]);
            result.tag = 34;
            result.component_data = new byte[0];
        }
        return result;
    }

    @Override
    public Subject check(SSLSession session) throws SASException {
        this.validateSSLSessionExistsWhenSSLRequired(session);
        return this.tryToAuthenticate(session);
    }

    private void validateSSLSessionExistsWhenSSLRequired(SSLSession session) throws SASException {
        if (session == null && this.requires != 0) {
            throw new SASInvalidEvidenceException("The target security service requires client certificate authentication, but there was no SSL session found.", 1229079296);
        }
    }

    @FFDCIgnore(value={SSLPeerUnverifiedException.class, Exception.class})
    private Subject tryToAuthenticate(SSLSession session) throws SASException {
        Subject transportSubject = null;
        try {
            transportSubject = this.authenticateWithCertificateChain(session);
        }
        catch (SSLPeerUnverifiedException e) {
            this.throwExceptionIfClientCertificateAuthenticationIsRequired(e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The peer could not be verified, but ignoring because client certificate authentication is not required. The exception is: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            this.throwExceptionIfClientCertificateAuthenticationIsRequired(e);
        }
        return transportSubject;
    }

    private Subject authenticateWithCertificateChain(SSLSession session) throws SSLPeerUnverifiedException, AuthenticationException, CredentialExpiredException, CredentialDestroyedException {
        Subject transportSubject = null;
        if (session != null) {
            Certificate[] certificateChain = session.getPeerCertificates();
            transportSubject = this.authenticator.authenticate((X509Certificate[])certificateChain);
            SubjectHelper subjectHelper = new SubjectHelper();
            WSCredential wsCredential = subjectHelper.getWSCredential(transportSubject);
            wsCredential.set("wssecurity.identity_name", (Object)"ClientCertificate");
            wsCredential.set("wssecurity.identity_value", (Object)certificateChain);
        }
        return transportSubject;
    }

    private void throwExceptionIfClientCertificateAuthenticationIsRequired(Exception e) throws SASException {
        if (this.clientCertificateAuthenticationRequired()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Client certificate authentication is required, but it was not possible to authenticate. The exception is: " + e.getMessage()), (Object[])new Object[0]);
            }
            throw new SASInvalidEvidenceException(e.getMessage(), 1229079296);
        }
    }

    private boolean clientCertificateAuthenticationRequired() {
        return (this.requires & 0x40) != 0;
    }

    @Override
    @FFDCIgnore(value={SSLPeerUnverifiedException.class})
    public boolean isTrusted(TrustedIDEvaluator trustedIDEvaluator, SSLSession session) {
        if (session != null) {
            try {
                Certificate[] certificateChain = session.getPeerCertificates();
                return trustedIDEvaluator.isTrusted((X509Certificate[])certificateChain);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    @Trivial
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSSSLTransportConfig: [\n");
        buf.append(moreSpaces).append("SUPPORTS: ").append(ConfigUtil.flags(this.supports)).append("\n");
        buf.append(moreSpaces).append("REQUIRES: ").append(ConfigUtil.flags(this.requires)).append("\n");
        if (this.transportAddresses != null) {
            for (TransportAddress addr : this.transportAddresses) {
                if (addr == null) continue;
                buf.append(moreSpaces).append("  ").append("hostName: ").append(addr.host_name).append(",  port    : ").append(addr.port).append("\n");
            }
        }
        buf.append(moreSpaces).append("handshakeTimeout: ").append(this.handshakeTimeout).append("\n");
        buf.append(spaces).append("]\n");
    }
}

