/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.css;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.ConfigUtil;
import com.ibm.ws.transport.iiop.security.config.css.CSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CSSSSLTransportConfig
implements CSSTransportMechConfig {
    private static final TraceComponent tc = Tr.register(CSSSSLTransportConfig.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private short supports;
    private short requires;
    private String sslConfigName;
    private String cantHandleMsg;
    private boolean lookupOutboundSSLRef = false;
    static final long serialVersionUID = 3537697340868370308L;

    public void setOutboundSSLReference() {
        this.lookupOutboundSSLRef = true;
    }

    @Override
    public boolean getOutboundSSLReference() {
        return this.lookupOutboundSSLRef;
    }

    @Override
    public short getSupports() {
        return this.supports;
    }

    public void setSupports(short supports) {
        this.supports = supports;
    }

    @Override
    public short getRequires() {
        return this.requires;
    }

    public void setRequires(short requires) {
        this.requires = requires;
    }

    @Override
    public String getSslConfigName() {
        return this.sslConfigName;
    }

    public void setSslConfigName(String sslConfigName) {
        this.sslConfigName = sslConfigName;
    }

    @Override
    public boolean canHandle(TSSTransportMechConfig transMech, String clientMech) {
        this.cantHandleMsg = null;
        if ((this.supports & transMech.getRequires()) != transMech.getRequires()) {
            this.buildSupportsFailedMsg(transMech, clientMech);
            return false;
        }
        if ((this.requires & transMech.getSupports()) != this.requires) {
            this.buildRequiresFailedMsg(transMech, clientMech);
            return false;
        }
        return true;
    }

    @Override
    public String getCantHandleMsg() {
        return this.cantHandleMsg;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    private void buildSupportsFailedMsg(TSSTransportMechConfig transMech, String clientMech) {
        this.cantHandleMsg = !clientMech.equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_TRANSPORT_SUPPORTS_FAILED", (Object[])new Object[]{clientMech, ConfigUtil.flags(this.supports), ConfigUtil.flags(transMech.getRequires())}, (String)"CWWKS9555E: The client security policy has the transport layer configured for {0} with <{1}> as Supported in the server.xml file and the server security policy is configured with <{2}> as Required.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_TRANSPORT_SUPPORTS_NO_AUTH_FAILED", (Object[])new Object[]{ConfigUtil.flags(this.supports), ConfigUtil.flags(transMech.getRequires())}, (String)"CWWKS9556E: The client security policy has the transport layer configured with <{0}> as Supported in the server.xml file and the server security policy is configured with <{1}> as Required.");
    }

    private void buildRequiresFailedMsg(TSSTransportMechConfig transMech, String clientMech) {
        this.cantHandleMsg = !clientMech.equalsIgnoreCase("DISABLED") ? TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_TRANSPORT_REQUIRES_FAILED", (Object[])new Object[]{clientMech, ConfigUtil.flags(this.requires), ConfigUtil.flags(transMech.getSupports())}, (String)"CWWKS9557E: The client security policy has the transport layer configured for {0} with <{1}> as Required in the server.xml file and the server security policy is configured with <{2}> as Supported.") : TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_CLIENT_COMPATIBLE_TRANSPORT_REQUIRES_NO_AUTH_FAILED", (Object[])new Object[]{ConfigUtil.flags(this.requires), ConfigUtil.flags(transMech.getSupports())}, (String)"CWWKS9558E: The client security policy has the transport layer configured with <{0}> as Required in the server.xml file and the server security policy is configured with <{1}> as Supported.");
    }

    @Override
    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("CSSSSLTransportConfig: [\n");
        buf.append(moreSpaces).append("SUPPORTS: ").append(ConfigUtil.flags(this.supports)).append("\n");
        buf.append(moreSpaces).append("REQUIRES: ").append(ConfigUtil.flags(this.requires)).append("\n");
        buf.append(moreSpaces).append("dynamicSSLEnabled: ").append(this.lookupOutboundSSLRef).append("\n");
        buf.append(spaces).append("]\n");
    }
}

