/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.ServerPolicy;
import com.ibm.ws.transport.iiop.security.config.tss.TSSConfig;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class IORSecurityInterceptor
extends LocalObject
implements IORInterceptor {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(IORSecurityInterceptor.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    private final TSSConfig defaultConfig;
    private final Codec codec;

    public IORSecurityInterceptor(TSSConfig defaultConfig, Codec codec) {
        this.codec = codec;
        this.defaultConfig = defaultConfig;
    }

    /*
     * WARNING - void declaration
     */
    public void establish_components(IORInfo info) {
        try {
            TSSConfig config;
            ServerPolicy policy = (ServerPolicy)info.get_effective_policy(1095976448);
            if (policy == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There was no server policy found of type: 1095976448. Using default configuration.", (Object[])new Object[0]);
                }
                config = this.defaultConfig;
            } else {
                config = policy.getConfig();
                if (config == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There was no TSSConfig object found in the server policy. Using default configuration.", (Object[])new Object[0]);
                    }
                    config = this.defaultConfig;
                }
            }
            if (config == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"There was no TSSConfig object found.", (Object[])new Object[0]);
                }
                return;
            }
            info.add_ior_component_to_profile(config.generateIOR(this.codec), 0);
        }
        catch (INV_POLICY policy) {
            FFDCFilter.processException((Throwable)policy, (String)"com.ibm.ws.transport.iiop.security.IORSecurityInterceptor", (String)"81", (Object)((Object)this), (Object[])new Object[]{info});
        }
        catch (Exception policy) {
            void e;
            FFDCFilter.processException((Throwable)policy, (String)"com.ibm.ws.transport.iiop.security.IORSecurityInterceptor", (String)"83", (Object)((Object)this), (Object[])new Object[]{info});
            Tr.error((TraceComponent)tc, (String)"Generating IOR", (Object[])new Object[]{e});
        }
    }

    public void destroy() {
    }

    public String name() {
        return "org.apache.geronimo.corba.security.IORSecurityInterceptor";
    }
}

