/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Assert;
import graphql.execution.TypeFromAST;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.Collections;
import java.util.List;

public class PossibleFragmentSpreads
extends AbstractRule {
    public PossibleFragmentSpreads(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkInlineFragment(InlineFragment inlineFragment) {
        GraphQLOutputType fragType = this.getValidationContext().getOutputType();
        GraphQLCompositeType parentType = this.getValidationContext().getParentType();
        if (fragType == null || parentType == null) {
            return;
        }
        if (this.isValidTargetCompositeType(fragType) && this.isValidTargetCompositeType(parentType) && !this.doTypesOverlap(fragType, parentType)) {
            String message = String.format("Fragment cannot be spread here as objects of type %s can never be of type %s", parentType.getName(), GraphQLTypeUtil.simplePrint(fragType));
            this.addError(ValidationErrorType.InvalidFragmentType, inlineFragment.getSourceLocation(), message);
        }
    }

    @Override
    public void checkFragmentSpread(FragmentSpread fragmentSpread) {
        FragmentDefinition fragment = this.getValidationContext().getFragment(fragmentSpread.getName());
        if (fragment == null) {
            return;
        }
        GraphQLType typeCondition = TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), fragment.getTypeCondition());
        GraphQLCompositeType parentType = this.getValidationContext().getParentType();
        if (typeCondition == null || parentType == null) {
            return;
        }
        if (this.isValidTargetCompositeType(typeCondition) && this.isValidTargetCompositeType(parentType) && !this.doTypesOverlap(typeCondition, parentType)) {
            String message = String.format("Fragment %s cannot be spread here as objects of type %s can never be of type %s", fragmentSpread.getName(), parentType.getName(), GraphQLTypeUtil.simplePrint(typeCondition));
            this.addError(ValidationErrorType.InvalidFragmentType, fragmentSpread.getSourceLocation(), message);
        }
    }

    private boolean doTypesOverlap(GraphQLType type, GraphQLCompositeType parent) {
        List<? extends GraphQLType> possibleConditionTypes;
        if (type == parent) {
            return true;
        }
        List<? extends GraphQLType> possibleParentTypes = this.getPossibleType(parent);
        return !Collections.disjoint(possibleParentTypes, possibleConditionTypes = this.getPossibleType(type));
    }

    private List<? extends GraphQLType> getPossibleType(GraphQLType type) {
        List<GraphQLType> possibleConditionTypes = null;
        if (type instanceof GraphQLObjectType) {
            possibleConditionTypes = Collections.singletonList(type);
        } else if (type instanceof GraphQLInterfaceType) {
            possibleConditionTypes = this.getValidationContext().getSchema().getImplementations((GraphQLInterfaceType)type);
        } else if (type instanceof GraphQLUnionType) {
            possibleConditionTypes = ((GraphQLUnionType)type).getTypes();
        } else {
            Assert.assertShouldNeverHappen();
        }
        return possibleConditionTypes;
    }

    private boolean isValidTargetCompositeType(GraphQLType type) {
        return type instanceof GraphQLCompositeType;
    }
}

