/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.schema.CodeRegistryVisitor;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeCollectingVisitor;
import graphql.schema.GraphQLTypeResolvingVisitor;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTraverser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class SchemaUtil {
    private static final SchemaTraverser TRAVERSER = new SchemaTraverser();

    Map<String, GraphQLNamedType> allTypes(GraphQLSchema schema, Set<GraphQLType> additionalTypes, boolean afterTransform) {
        ArrayList<GraphQLSchemaElement> roots = new ArrayList<GraphQLSchemaElement>();
        roots.add(schema.getQueryType());
        if (schema.isSupportingMutations()) {
            roots.add(schema.getMutationType());
        }
        if (schema.isSupportingSubscriptions()) {
            roots.add(schema.getSubscriptionType());
        }
        if (additionalTypes != null) {
            roots.addAll(additionalTypes);
        }
        if (schema.getDirectives() != null) {
            roots.addAll(schema.getDirectives());
        }
        roots.add(Introspection.__Schema);
        GraphQLTypeCollectingVisitor visitor = new GraphQLTypeCollectingVisitor();
        SchemaTraverser traverser = afterTransform ? new SchemaTraverser(schemaElement -> schemaElement.getChildrenWithTypeReferences().getChildrenAsList()) : new SchemaTraverser();
        traverser.depthFirst((GraphQLTypeVisitor)visitor, roots);
        return visitor.getResult();
    }

    Map<String, List<GraphQLObjectType>> groupImplementations(GraphQLSchema schema) {
        LinkedHashMap<String, List<GraphQLObjectType>> result = new LinkedHashMap<String, List<GraphQLObjectType>>();
        for (GraphQLType graphQLType : schema.getAllTypesAsList()) {
            if (!(graphQLType instanceof GraphQLObjectType)) continue;
            for (GraphQLNamedOutputType interfaceType : ((GraphQLObjectType)graphQLType).getInterfaces()) {
                List myGroup = result.computeIfAbsent(interfaceType.getName(), k -> new ArrayList());
                myGroup.add((GraphQLObjectType)graphQLType);
            }
        }
        return result;
    }

    @Deprecated
    public List<GraphQLObjectType> findImplementations(GraphQLSchema schema, GraphQLInterfaceType interfaceType) {
        ArrayList<GraphQLObjectType> result = new ArrayList<GraphQLObjectType>();
        for (GraphQLType graphQLType : schema.getAllTypesAsList()) {
            GraphQLObjectType objectType;
            if (!(graphQLType instanceof GraphQLObjectType) || !(objectType = (GraphQLObjectType)graphQLType).getInterfaces().contains(interfaceType)) continue;
            result.add(objectType);
        }
        return result;
    }

    void replaceTypeReferences(GraphQLSchema schema) {
        Map<String, GraphQLNamedType> typeMap = schema.getTypeMap();
        ArrayList<GraphQLNamedType> roots = new ArrayList<GraphQLNamedType>(typeMap.values());
        roots.addAll(schema.getDirectives());
        SchemaTraverser schemaTraverser = new SchemaTraverser(schemaElement -> schemaElement.getChildrenWithTypeReferences().getChildrenAsList());
        schemaTraverser.depthFirst((GraphQLTypeVisitor)new GraphQLTypeResolvingVisitor(typeMap), roots);
    }

    void extractCodeFromTypes(GraphQLCodeRegistry.Builder codeRegistry, GraphQLSchema schema) {
        Introspection.addCodeForIntrospectionTypes(codeRegistry);
        TRAVERSER.depthFirst((GraphQLTypeVisitor)new CodeRegistryVisitor(codeRegistry), schema.getAllTypesAsList());
    }
}

