/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collections;
import java.util.List;

@PublicApi
public class GraphQLList
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLModifiedType,
GraphQLNullableType {
    private final GraphQLType originalWrappedType;
    private GraphQLType replacedWrappedType;
    public static final String CHILD_WRAPPED_TYPE = "wrappedType";

    public static GraphQLList list(GraphQLType wrappedType) {
        return new GraphQLList(wrappedType);
    }

    public GraphQLList(GraphQLType wrappedType) {
        Assert.assertNotNull(wrappedType, "wrappedType can't be null", new Object[0]);
        this.originalWrappedType = wrappedType;
    }

    @Override
    public GraphQLType getWrappedType() {
        return this.replacedWrappedType != null ? this.replacedWrappedType : this.originalWrappedType;
    }

    void replaceType(GraphQLType type) {
        this.replacedWrappedType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphQLList that = (GraphQLList)o;
        GraphQLType wrappedType = this.getWrappedType();
        return !(wrappedType == null ? that.getWrappedType() != null : !wrappedType.equals(that.getWrappedType()));
    }

    public int hashCode() {
        return this.getWrappedType() != null ? this.getWrappedType().hashCode() : 0;
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLList(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        return Collections.singletonList(this.getWrappedType());
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().child(CHILD_WRAPPED_TYPE, this.originalWrappedType).build();
    }

    @Override
    public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
        return GraphQLList.list((GraphQLType)newChildren.getChildOrNull(CHILD_WRAPPED_TYPE));
    }

    public String toString() {
        return GraphQLTypeUtil.simplePrint(this);
    }
}

