/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.execution.AbstractAsyncExecutionStrategy;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.defer.DeferSupport;
import graphql.execution.defer.DeferredCall;
import graphql.execution.defer.DeferredErrorSupport;
import graphql.execution.instrumentation.DeferredFieldInstrumentationContext;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationDeferredFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AsyncExecutionStrategy
extends AbstractAsyncExecutionStrategy {
    public AsyncExecutionStrategy() {
        super(new SimpleDataFetcherExceptionHandler());
    }

    public AsyncExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext, parameters);
        ExecutionStrategyInstrumentationContext executionStrategyCtx = instrumentation.beginExecutionStrategy(instrumentationParameters);
        MergedSelectionSet fields = parameters.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
        ArrayList futures = new ArrayList();
        ArrayList<String> resolvedFields = new ArrayList<String>();
        for (String fieldName : fieldNames) {
            CompletableFuture<FieldValueInfo> future;
            MergedField currentField = fields.getSubField(fieldName);
            ExecutionPath fieldPath = parameters.getPath().segment(AsyncExecutionStrategy.mkNameForPath(currentField));
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.field(currentField).path(fieldPath).parent(parameters));
            resolvedFields.add(fieldName);
            if (this.isDeferred(executionContext, newParameters, currentField)) {
                executionStrategyCtx.onDeferredField(currentField);
                future = this.resolveFieldWithInfoToNull(executionContext, newParameters);
            } else {
                future = this.resolveFieldWithInfo(executionContext, newParameters);
            }
            futures.add(future);
        }
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        executionStrategyCtx.onDispatched(overallResult);
        ((CompletableFuture)Async.each(futures).whenComplete((completeValueInfos, throwable) -> {
            BiConsumer<List<ExecutionResult>, Throwable> handleResultsConsumer = this.handleResults(executionContext, resolvedFields, overallResult);
            if (throwable != null) {
                handleResultsConsumer.accept(null, throwable.getCause());
                return;
            }
            List executionResultFuture = completeValueInfos.stream().map(FieldValueInfo::getFieldValue).collect(Collectors.toList());
            executionStrategyCtx.onFieldValuesInfo((List<FieldValueInfo>)completeValueInfos);
            Async.each(executionResultFuture).whenComplete(handleResultsConsumer);
        })).exceptionally(ex -> {
            overallResult.completeExceptionally((Throwable)ex);
            return null;
        });
        overallResult.whenComplete(executionStrategyCtx::onCompleted);
        return overallResult;
    }

    private boolean isDeferred(ExecutionContext executionContext, ExecutionStrategyParameters parameters, MergedField currentField) {
        DeferSupport deferSupport = executionContext.getDeferSupport();
        if (deferSupport.checkForDeferDirective(currentField, executionContext.getVariables())) {
            DeferredErrorSupport errorSupport = new DeferredErrorSupport();
            LinkedHashMap<String, MergedField> fields = new LinkedHashMap<String, MergedField>();
            fields.put(currentField.getName(), currentField);
            ExecutionStrategyParameters callParameters = parameters.transform(builder -> {
                MergedSelectionSet mergedSelectionSet = MergedSelectionSet.newMergedSelectionSet().subFields(fields).build();
                builder.deferredErrorSupport(errorSupport).field(currentField).fields(mergedSelectionSet).parent(null).listSize(0).currentListIndex(0);
            });
            DeferredCall call = new DeferredCall(parameters.getPath(), this.deferredExecutionResult(executionContext, callParameters), errorSupport);
            deferSupport.enqueue(call);
            return true;
        }
        return false;
    }

    private Supplier<CompletableFuture<ExecutionResult>> deferredExecutionResult(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        return () -> {
            GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.getField().getSingleField());
            GraphQLObjectType fieldContainer = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
            Instrumentation instrumentation = executionContext.getInstrumentation();
            DeferredFieldInstrumentationContext fieldCtx = instrumentation.beginDeferredField(new InstrumentationDeferredFieldParameters(executionContext, parameters, fieldDef, this.createExecutionStepInfo(executionContext, parameters, fieldDef, fieldContainer)));
            CompletableFuture result = new CompletableFuture();
            fieldCtx.onDispatched(result);
            CompletableFuture<FieldValueInfo> fieldValueInfoFuture = this.resolveFieldWithInfo(executionContext, parameters);
            fieldValueInfoFuture.whenComplete((fieldValueInfo, throwable) -> {
                fieldCtx.onFieldValueInfo((FieldValueInfo)fieldValueInfo);
                CompletionStage<ExecutionResult> execResultFuture = fieldValueInfo.getFieldValue();
                execResultFuture = execResultFuture.whenComplete(fieldCtx::onCompleted);
                Async.copyResults(execResultFuture, result);
            });
            return result;
        };
    }
}

