/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import graphql.schema.CoercingSerializeException;
import java.util.List;
import java.util.Map;

@PublicApi
public class SerializationError
implements GraphQLError {
    private final String message;
    private final List<Object> path;
    private final CoercingSerializeException exception;

    public SerializationError(ExecutionPath path, CoercingSerializeException exception) {
        this.path = Assert.assertNotNull(path).toList();
        this.exception = Assert.assertNotNull(exception);
        this.message = this.mkMessage(path, exception);
    }

    private String mkMessage(ExecutionPath path, CoercingSerializeException exception) {
        return String.format("Can't serialize value (%s) : %s", path, exception.getMessage());
    }

    public CoercingSerializeException getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.exception.getLocations();
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.DataFetchingException;
    }

    @Override
    public List<Object> getPath() {
        return this.path;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.exception.getExtensions();
    }

    public String toString() {
        return "SerializationError{path=" + this.path + ", exception=" + this.exception + '}';
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }
}

