/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.Internal;
import graphql.ParseResult;
import graphql.PublicApi;
import graphql.execution.AbortExecutionException;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.Execution;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.ValueUnboxer;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.language.Document;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.util.LogKit;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class GraphQL {
    public static final String DEFERRED_RESULTS = "deferredResults";
    private static final Logger log = LoggerFactory.getLogger(GraphQL.class);
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(GraphQL.class);
    private static final Instrumentation DEFAULT_INSTRUMENTATION = new DataLoaderDispatcherInstrumentation();
    private final GraphQLSchema graphQLSchema;
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final ExecutionIdProvider idProvider;
    private final Instrumentation instrumentation;
    private final PreparsedDocumentProvider preparsedDocumentProvider;
    private final ValueUnboxer valueUnboxer;

    @Internal
    @Deprecated
    public GraphQL(GraphQLSchema graphQLSchema) {
        this(graphQLSchema, null, null);
    }

    @Internal
    @Deprecated
    public GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy) {
        this(graphQLSchema, queryStrategy, null);
    }

    @Internal
    @Deprecated
    public GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy) {
        this(graphQLSchema, queryStrategy, mutationStrategy, null, ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER, DEFAULT_INSTRUMENTATION, NoOpPreparsedDocumentProvider.INSTANCE, ValueUnboxer.DEFAULT);
    }

    @Internal
    @Deprecated
    public GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy) {
        this(graphQLSchema, queryStrategy, mutationStrategy, subscriptionStrategy, ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER, DEFAULT_INSTRUMENTATION, NoOpPreparsedDocumentProvider.INSTANCE, ValueUnboxer.DEFAULT);
    }

    private GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, ExecutionIdProvider idProvider, Instrumentation instrumentation, PreparsedDocumentProvider preparsedDocumentProvider, ValueUnboxer valueUnboxer) {
        this.graphQLSchema = Assert.assertNotNull(graphQLSchema, "graphQLSchema must be non null", new Object[0]);
        this.queryStrategy = queryStrategy != null ? queryStrategy : new AsyncExecutionStrategy();
        this.mutationStrategy = mutationStrategy != null ? mutationStrategy : new AsyncSerialExecutionStrategy();
        this.subscriptionStrategy = subscriptionStrategy != null ? subscriptionStrategy : new SubscriptionExecutionStrategy();
        this.idProvider = Assert.assertNotNull(idProvider, "idProvider must be non null", new Object[0]);
        this.instrumentation = Assert.assertNotNull(instrumentation);
        this.preparsedDocumentProvider = Assert.assertNotNull(preparsedDocumentProvider, "preparsedDocumentProvider must be non null", new Object[0]);
        this.valueUnboxer = valueUnboxer;
    }

    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public GraphQL transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this.graphQLSchema);
        builder.queryExecutionStrategy(GraphQL.nvl(this.queryStrategy, builder.queryExecutionStrategy)).mutationExecutionStrategy(GraphQL.nvl(this.mutationStrategy, builder.mutationExecutionStrategy)).subscriptionExecutionStrategy(GraphQL.nvl(this.subscriptionStrategy, builder.subscriptionExecutionStrategy)).executionIdProvider(GraphQL.nvl(this.idProvider, builder.idProvider)).instrumentation(GraphQL.nvl(this.instrumentation, builder.instrumentation)).preparsedDocumentProvider(GraphQL.nvl(this.preparsedDocumentProvider, builder.preparsedDocumentProvider));
        builderConsumer.accept(builder);
        return builder.build();
    }

    private static <T> T nvl(T obj, T elseObj) {
        return obj == null ? elseObj : obj;
    }

    public ExecutionResult execute(String query) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, Object context) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).context(context).root(context).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, String operationName, Object context) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).operationName(operationName).context(context).root(context).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, Object context, Map<String, Object> variables) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).context(context).root(context).variables(variables).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, String operationName, Object context, Map<String, Object> variables) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).operationName(operationName).context(context).root(context).variables(variables).build();
        return this.execute(executionInput);
    }

    public ExecutionResult execute(ExecutionInput.Builder executionInputBuilder) {
        return this.execute(executionInputBuilder.build());
    }

    public ExecutionResult execute(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.execute(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public ExecutionResult execute(ExecutionInput executionInput) {
        try {
            return this.executeAsync(executionInput).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput.Builder executionInputBuilder) {
        return this.executeAsync(executionInputBuilder.build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.executeAsync(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput executionInput) {
        try {
            logNotSafe.debug("Executing request. operation name: '{}'. query: '{}'. variables '{}'", new Object[]{executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables()});
            executionInput = this.ensureInputHasId(executionInput);
            InstrumentationState instrumentationState = this.instrumentation.createState(new InstrumentationCreateStateParameters(this.graphQLSchema, executionInput));
            InstrumentationExecutionParameters inputInstrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            executionInput = this.instrumentation.instrumentExecutionInput(executionInput, inputInstrumentationParameters);
            InstrumentationExecutionParameters instrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            InstrumentationContext<ExecutionResult> executionInstrumentation = this.instrumentation.beginExecution(instrumentationParameters);
            GraphQLSchema graphQLSchema = this.instrumentation.instrumentSchema(this.graphQLSchema, instrumentationParameters);
            CompletionStage<ExecutionResult> executionResult = this.parseValidateAndExecute(executionInput, graphQLSchema, instrumentationState);
            executionResult = ((CompletableFuture)executionResult).whenComplete(executionInstrumentation::onCompleted);
            executionResult = ((CompletableFuture)executionResult).thenCompose(result -> this.instrumentation.instrumentExecutionResult((ExecutionResult)result, instrumentationParameters));
            return executionResult;
        }
        catch (AbortExecutionException abortException) {
            return CompletableFuture.completedFuture(abortException.toExecutionResult());
        }
    }

    private ExecutionInput ensureInputHasId(ExecutionInput executionInput) {
        if (executionInput.getExecutionId() != null) {
            return executionInput;
        }
        String queryString = executionInput.getQuery();
        String operationName = executionInput.getOperationName();
        Object context = executionInput.getContext();
        return executionInput.transform((ExecutionInput.Builder builder) -> builder.executionId(this.idProvider.provide(queryString, operationName, context)));
    }

    private CompletableFuture<ExecutionResult> parseValidateAndExecute(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        AtomicReference<ExecutionInput> executionInputRef = new AtomicReference<ExecutionInput>(executionInput);
        Function<ExecutionInput, PreparsedDocumentEntry> computeFunction = transformedInput -> {
            executionInputRef.set((ExecutionInput)transformedInput);
            return this.parseAndValidate(executionInputRef, graphQLSchema, instrumentationState);
        };
        PreparsedDocumentEntry preparsedDoc = this.preparsedDocumentProvider.getDocument(executionInput, computeFunction);
        if (preparsedDoc.hasErrors()) {
            return CompletableFuture.completedFuture(new ExecutionResultImpl(preparsedDoc.getErrors()));
        }
        return this.execute(executionInputRef.get(), preparsedDoc.getDocument(), graphQLSchema, instrumentationState);
    }

    private PreparsedDocumentEntry parseAndValidate(AtomicReference<ExecutionInput> executionInputRef, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        ExecutionInput executionInput = executionInputRef.get();
        String query = executionInput.getQuery();
        logNotSafe.debug("Parsing query: '{}'...", (Object)query);
        ParseResult parseResult = this.parse(executionInput, graphQLSchema, instrumentationState);
        if (parseResult.isFailure()) {
            logNotSafe.warn("Query failed to parse : '{}'", (Object)executionInput.getQuery());
            return new PreparsedDocumentEntry(parseResult.getException().toInvalidSyntaxError());
        }
        Document document = parseResult.getDocument();
        executionInput = executionInput.transform((ExecutionInput.Builder builder) -> builder.variables(parseResult.getVariables()));
        executionInputRef.set(executionInput);
        logNotSafe.debug("Validating query: '{}'", (Object)query);
        List<ValidationError> errors = this.validate(executionInput, document, graphQLSchema, instrumentationState);
        if (!errors.isEmpty()) {
            logNotSafe.warn("Query failed to validate : '{}'", (Object)query);
            return new PreparsedDocumentEntry(errors);
        }
        return new PreparsedDocumentEntry(document);
    }

    private ParseResult parse(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        DocumentAndVariables documentAndVariables;
        InstrumentationExecutionParameters parameters = new InstrumentationExecutionParameters(executionInput, graphQLSchema, instrumentationState);
        InstrumentationContext<Document> parseInstrumentation = this.instrumentation.beginParse(parameters);
        Parser parser = new Parser();
        try {
            Document document = parser.parseDocument(executionInput.getQuery());
            documentAndVariables = DocumentAndVariables.newDocumentAndVariables().document(document).variables(executionInput.getVariables()).build();
            documentAndVariables = this.instrumentation.instrumentDocumentAndVariables(documentAndVariables, parameters);
        }
        catch (InvalidSyntaxException e) {
            parseInstrumentation.onCompleted(null, e);
            return ParseResult.ofError(e);
        }
        parseInstrumentation.onCompleted(documentAndVariables.getDocument(), null);
        return ParseResult.of(documentAndVariables);
    }

    private List<ValidationError> validate(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        InstrumentationContext<List<ValidationError>> validationCtx = this.instrumentation.beginValidation(new InstrumentationValidationParameters(executionInput, document, graphQLSchema, instrumentationState));
        Validator validator = new Validator();
        List<ValidationError> validationErrors = validator.validateDocument(graphQLSchema, document);
        validationCtx.onCompleted(validationErrors, null);
        return validationErrors;
    }

    private CompletableFuture<ExecutionResult> execute(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        Execution execution = new Execution(this.queryStrategy, this.mutationStrategy, this.subscriptionStrategy, this.instrumentation, this.valueUnboxer);
        ExecutionId executionId = executionInput.getExecutionId();
        logNotSafe.debug("Executing '{}'. operation name: '{}'. query: '{}'. variables '{}'", new Object[]{executionId, executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables()});
        CompletionStage<ExecutionResult> future = execution.execute(document, graphQLSchema, executionId, executionInput, instrumentationState);
        future = future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                logNotSafe.error(String.format("Execution '%s' threw exception when executing : query : '%s'. variables '%s'", executionId, executionInput.getQuery(), executionInput.getVariables()), throwable);
            } else {
                int errorCount = result.getErrors().size();
                if (errorCount > 0) {
                    log.debug("Execution '{}' completed with '{}' errors", (Object)executionId, (Object)errorCount);
                } else {
                    log.debug("Execution '{}' completed with zero errors", (Object)executionId);
                }
            }
        });
        return future;
    }

    private static Instrumentation checkInstrumentationDefaultState(Instrumentation instrumentation, boolean doNotAddDefaultInstrumentations) {
        if (doNotAddDefaultInstrumentations) {
            return instrumentation == null ? SimpleInstrumentation.INSTANCE : instrumentation;
        }
        if (instrumentation instanceof DataLoaderDispatcherInstrumentation) {
            return instrumentation;
        }
        if (instrumentation == null) {
            return new DataLoaderDispatcherInstrumentation();
        }
        ArrayList<Instrumentation> instrumentationList = new ArrayList<Instrumentation>();
        if (instrumentation instanceof ChainedInstrumentation) {
            instrumentationList.addAll(((ChainedInstrumentation)instrumentation).getInstrumentations());
        } else {
            instrumentationList.add(instrumentation);
        }
        boolean containsDLInstrumentation = instrumentationList.stream().anyMatch(instr -> instr instanceof DataLoaderDispatcherInstrumentation);
        if (!containsDLInstrumentation) {
            instrumentationList.add(new DataLoaderDispatcherInstrumentation());
        }
        return new ChainedInstrumentation(instrumentationList);
    }

    @PublicApi
    public static class Builder {
        private GraphQLSchema graphQLSchema;
        private ExecutionStrategy queryExecutionStrategy = new AsyncExecutionStrategy();
        private ExecutionStrategy mutationExecutionStrategy = new AsyncSerialExecutionStrategy();
        private ExecutionStrategy subscriptionExecutionStrategy = new SubscriptionExecutionStrategy();
        private ExecutionIdProvider idProvider = ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
        private Instrumentation instrumentation = null;
        private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;
        private boolean doNotAddDefaultInstrumentations = false;
        private ValueUnboxer valueUnboxer = ValueUnboxer.DEFAULT;

        public Builder(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = graphQLSchema;
        }

        public Builder schema(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = Assert.assertNotNull(graphQLSchema, "GraphQLSchema must be non null", new Object[0]);
            return this;
        }

        public Builder queryExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.queryExecutionStrategy = Assert.assertNotNull(executionStrategy, "Query ExecutionStrategy must be non null", new Object[0]);
            return this;
        }

        public Builder mutationExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.mutationExecutionStrategy = Assert.assertNotNull(executionStrategy, "Mutation ExecutionStrategy must be non null", new Object[0]);
            return this;
        }

        public Builder subscriptionExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.subscriptionExecutionStrategy = Assert.assertNotNull(executionStrategy, "Subscription ExecutionStrategy must be non null", new Object[0]);
            return this;
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentation = Assert.assertNotNull(instrumentation, "Instrumentation must be non null", new Object[0]);
            return this;
        }

        public Builder preparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
            this.preparsedDocumentProvider = Assert.assertNotNull(preparsedDocumentProvider, "PreparsedDocumentProvider must be non null", new Object[0]);
            return this;
        }

        public Builder executionIdProvider(ExecutionIdProvider executionIdProvider) {
            this.idProvider = Assert.assertNotNull(executionIdProvider, "ExecutionIdProvider must be non null", new Object[0]);
            return this;
        }

        public Builder doNotAddDefaultInstrumentations() {
            this.doNotAddDefaultInstrumentations = true;
            return this;
        }

        public Builder valueUnboxer(ValueUnboxer valueUnboxer) {
            this.valueUnboxer = valueUnboxer;
            return this;
        }

        public GraphQL build() {
            Assert.assertNotNull(this.graphQLSchema, "graphQLSchema must be non null", new Object[0]);
            Assert.assertNotNull(this.queryExecutionStrategy, "queryStrategy must be non null", new Object[0]);
            Assert.assertNotNull(this.idProvider, "idProvider must be non null", new Object[0]);
            Instrumentation augmentedInstrumentation = GraphQL.checkInstrumentationDefaultState(this.instrumentation, this.doNotAddDefaultInstrumentations);
            return new GraphQL(this.graphQLSchema, this.queryExecutionStrategy, this.mutationExecutionStrategy, this.subscriptionExecutionStrategy, this.idProvider, augmentedInstrumentation, this.preparsedDocumentProvider, this.valueUnboxer);
        }
    }
}

