/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class DeferredService {
    private static final TraceComponent tc = Tr.register(DeferredService.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    public static final String RESOURCE_ADAPTER_DOMAIN = "Resource Adapter";
    private final AtomicReference<Object> serviceReg = new AtomicReference();
    static final long serialVersionUID = -3053025264360780873L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void registerDeferredService(BundleContext bundleContext, Class<?> providedService, Dictionary dict) {
        block10: {
            Object obj = this.serviceReg.get();
            if (obj instanceof ServiceRegistration) {
                return;
            }
            if (obj instanceof CountDownLatch) {
                try {
                    ((CountDownLatch)obj).await();
                    if (this.serviceReg.get() instanceof ServiceRegistration) {
                        return;
                    }
                    break block10;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.jca.internal.DeferredService", (String)"58", (Object)this, (Object[])new Object[]{bundleContext, providedService, dict});
                    if (tc.isDebugEnabled()) {
                        void swallowed;
                        Tr.debug((TraceComponent)tc, (String)"Count down interrrupted", (Object[])new Object[]{swallowed});
                    }
                    break block10;
                }
            }
            CountDownLatch latch = new CountDownLatch(1);
            if (this.serviceReg.compareAndSet(null, latch)) {
                try {
                    this.serviceReg.set(bundleContext.registerService(providedService.getName(), (Object)this, dict));
                    return;
                }
                finally {
                    this.serviceReg.compareAndSet(latch, null);
                    latch.countDown();
                }
            }
        }
        this.registerDeferredService(bundleContext, providedService, dict);
    }

    public void deregisterDeferredService() {
        CountDownLatch latch;
        Object obj = this.serviceReg.get();
        if (obj == null) {
            return;
        }
        if (obj instanceof CountDownLatch) {
            return;
        }
        if (obj instanceof ServiceRegistration && this.serviceReg.compareAndSet(obj, latch = new CountDownLatch(1))) {
            try {
                ((ServiceRegistration)obj).unregister();
                return;
            }
            finally {
                this.serviceReg.compareAndSet(latch, obj);
                latch.countDown();
            }
        }
    }
}

