/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.ExtensionUtils;
import com.ibm.ws.kernel.boot.cmdline.LaunchManifest;
import com.ibm.ws.kernel.boot.cmdline.PackageDelegateClassLoader;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.AbstractResourceRepository;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.NameBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.tools.ToolProvider;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class UtilityMain {
    private static final String DEFAULT_BUNDLE_VERSION = "0.0.0";

    public static void main(String[] args) {
        try {
            UtilityMain.internal_main(args);
        }
        catch (InvocationTargetException e) {
            Throwable ite = e.getTargetException();
            if (ite != null) {
                ite.printStackTrace();
            } else {
                e.printStackTrace();
            }
            System.exit(32);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void internal_main(String[] args) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, PrivilegedActionException {
        String jarName = System.getProperty("java.class.path");
        JarFile jarFile = new JarFile(new File(jarName));
        Attributes a = jarFile.getManifest().getMainAttributes();
        jarFile.close();
        String commandClass = a.getValue("Command-Class");
        String requiredBundles = a.getValue("Require-Bundle");
        String parentCL = a.getValue("Parent-ClassLoader");
        String parentLastPackages = a.getValue("Parent-Last-Package");
        String requireCompiler = a.getValue("Require-Compiler");
        boolean bootstrapCLParent = false;
        boolean compilerTools = false;
        if ("bootstrap".equals(parentCL)) {
            bootstrapCLParent = true;
        }
        if ("true".equals(requireCompiler)) {
            compilerTools = true;
        }
        List<LaunchManifest.RequiredBundle> rbs = LaunchManifest.parseRequireBundle(requiredBundles);
        BundleRepositoryRegistry.initializeDefaults(null, false);
        List<AbstractResourceRepository> repos = UtilityMain.getAllRepositories();
        List<URL> urls = new ArrayList<URL>();
        urls = UtilityMain.selectResources(repos, rbs, urls);
        String extensions = a.getValue("IBM-RequiredExtensions");
        if (extensions != null && !extensions.isEmpty()) {
            for (String extension : extensions.split(",")) {
                List<LaunchManifest.RequiredBundle> rbsExt = ExtensionUtils.findExtensionBundles(extension.trim());
                if (rbsExt == null || rbsExt.isEmpty()) continue;
                urls = UtilityMain.selectResources(repos, rbsExt, urls);
            }
        }
        LinkedList<URL> embeddedLibUrls = new LinkedList<URL>();
        for (URL jarFileUrl : urls) {
            embeddedLibUrls.addAll(UtilityMain.getBundleEmbeddedLibs(jarFileUrl));
        }
        urls.addAll(embeddedLibUrls);
        if (compilerTools) {
            File toolsFile = Utils.getJavaTools();
            if (toolsFile != null) {
                urls.add(toolsFile.toURI().toURL());
            } else if (!UtilityMain.isCompilerAvailable()) {
                if (UtilityMain.javaVersion() <= 8) {
                    UtilityMain.error("error.sdkRequired", System.getProperty("java.home"));
                } else {
                    UtilityMain.error("error.compilerMissing", new Object[0]);
                }
                System.exit(30);
                return;
            }
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextLoader = currentThread.getContextClassLoader();
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        List<String> parentLastPackageList = LaunchManifest.parseHeaderList(parentLastPackages);
        ClassLoader parentLoader = bootstrapCLParent ? null : UtilityMain.class.getClassLoader();
        PackageDelegateClassLoader cl = new PackageDelegateClassLoader(urlArray, parentLoader, parentLastPackageList);
        currentThread.setContextClassLoader(cl);
        try {
            Class<?> clazz = cl.loadClass(commandClass);
            Method m = clazz.getMethod("main", args.getClass());
            m.invoke(null, new Object[]{args});
        }
        finally {
            currentThread.setContextClassLoader(originalContextLoader);
        }
    }

    private static String format(String key, Object ... args) {
        String string = Utils.getResourceBundleString(key);
        return args == null || args.length == 0 ? string : MessageFormat.format(string, args);
    }

    private static void error(String key, Object ... args) {
        System.err.println(UtilityMain.format(key, args));
    }

    private static List<URL> getBundleEmbeddedLibs(final URL jarFileUrl) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<List<URL>>(){

            @Override
            public List<URL> run() throws Exception {
                JarFile jarFile = new JarFile(URLDecoder.decode(jarFileUrl.getFile(), "utf-8"));
                LinkedList<URL> libs = new LinkedList<URL>();
                Attributes manifest = jarFile.getManifest().getMainAttributes();
                String rawBundleClasspath = manifest.getValue("Bundle-ClassPath");
                if (rawBundleClasspath != null) {
                    String[] bundleClassPaths;
                    HashSet<String> allValidBundleClassPaths = new HashSet<String>();
                    for (String bundleClassPath : bundleClassPaths = rawBundleClasspath.split(",")) {
                        if ((bundleClassPath = bundleClassPath.trim()).equals(".") || !bundleClassPath.endsWith(".jar")) continue;
                        allValidBundleClassPaths.add(bundleClassPath);
                    }
                    Enumeration<JarEntry> entries = jarFile.entries();
                    File tempDir = UtilityMain.createTempDir("was-cmdline");
                    tempDir.deleteOnExit();
                    int MAX_READ_SIZE = 512;
                    int offset = 0;
                    int read = 0;
                    byte[] buff = new byte[MAX_READ_SIZE];
                    while (entries.hasMoreElements()) {
                        int index;
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        if (!allValidBundleClassPaths.contains(entryName)) continue;
                        String fileName = entryName;
                        while ((index = fileName.indexOf("/")) != -1) {
                            fileName = fileName.substring(index + 1);
                        }
                        InputStream stream = jarFile.getInputStream(jarEntry);
                        File file = new File(tempDir, fileName);
                        file.deleteOnExit();
                        FileOutputStream fileStream = new FileOutputStream(file);
                        while ((read = stream.read(buff, offset, MAX_READ_SIZE)) > 0) {
                            fileStream.write(buff, 0, read);
                        }
                        fileStream.flush();
                        fileStream.close();
                        stream.close();
                        libs.add(file.toURI().toURL());
                    }
                }
                jarFile.close();
                return libs;
            }
        });
    }

    public static File createTempDir(String baseName) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        baseName = baseName + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 1000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 1000 attempts (tried " + baseName + "0 to " + baseName + 999 + ')');
    }

    private static boolean isValidJavaSpecVersion(LaunchManifest.RequiredBundle rb) {
        String vrString = rb.getAttribute("java.specification.version");
        if (vrString == null) {
            return true;
        }
        VersionRange vr = new VersionRange(vrString);
        Version v = new Version(System.getProperty("java.specification.version"));
        return vr.includes(v);
    }

    private static List<URL> selectResources(List<AbstractResourceRepository> repos, List<LaunchManifest.RequiredBundle> rbs, List<URL> urls) throws MalformedURLException {
        for (LaunchManifest.RequiredBundle rb : rbs) {
            Object url;
            AbstractResourceRepository repo;
            String bundleVersion = rb.getAttribute("version");
            String string = bundleVersion = null != bundleVersion ? bundleVersion : DEFAULT_BUNDLE_VERSION;
            if (!UtilityMain.isValidJavaSpecVersion(rb)) continue;
            File f = null;
            Iterator<AbstractResourceRepository> iterator = repos.iterator();
            while (iterator.hasNext() && (f = (repo = iterator.next()).selectResource(rb.getAttribute("location"), rb.getSymbolicName(), VersionUtility.stringToVersionRange(bundleVersion))) == null) {
            }
            if (f != null && !urls.contains(url = f.toURI().toURL())) {
                urls.add((URL)url);
            }
            f = null;
            url = repos.iterator();
            while (url.hasNext() && (f = (repo = (AbstractResourceRepository)url.next()).selectResource(rb.getAttribute("location"), rb.getSymbolicName() + ".nls", VersionUtility.stringToVersionRange(bundleVersion))) == null) {
            }
            if (f == null || urls.contains(url = f.toURI().toURL())) continue;
            urls.add((URL)url);
        }
        return urls;
    }

    private static List<AbstractResourceRepository> getAllRepositories() {
        ArrayList<AbstractResourceRepository> repos = new ArrayList<AbstractResourceRepository>();
        repos.add(new NameBasedLocalBundleRepository(Utils.getInstallDir()));
        List<File> extDirs = ExtensionUtils.listProductExtensionDirectories();
        for (File extDir : extDirs) {
            repos.add(new NameBasedLocalBundleRepository(extDir));
        }
        return repos;
    }

    private static boolean isCompilerAvailable() {
        try {
            return ToolProvider.getSystemJavaCompiler() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int javaVersion() {
        String version = System.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        return Integer.valueOf(versionElements[i]);
    }
}

