/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.saml2.Saml20Attribute;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.util.XMLObjectHelper;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Saml20AttributeImpl
implements Saml20Attribute {
    private static final long serialVersionUID = -862850937499495720L;
    private static transient TraceComponent tc = Tr.register(Saml20AttributeImpl.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    String seializedAttribute = null;
    transient Attribute attribute = null;
    List<QName> namespaces = new ArrayList<QName>();
    QName schemaType = null;
    List<String> stringValues = new ArrayList<String>();
    List<String> simpleStringValues = new ArrayList<String>();
    String name = null;
    String friendlyName = null;
    String format = null;

    public Saml20AttributeImpl(Attribute attribute) {
        attribute.detach();
        this.attribute = attribute;
        this.seializedAttribute = XMLHelper.nodeToString((Node)attribute.getDOM());
        this.init();
    }

    public Saml20AttributeImpl(String attribute) {
        this.seializedAttribute = attribute;
        this.deserialize();
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    protected void deserialize() {
        block4: {
            StaticBasicParserPool ppMgr = (StaticBasicParserPool)Configuration.getParserPool();
            try {
                StringReader reader = new StringReader(this.seializedAttribute);
                this.attribute = (Attribute)XMLObjectHelper.unmarshallFromReader((ParserPool)ppMgr, (Reader)reader);
            }
            catch (XMLParserException reader) {
                FFDCFilter.processException((Throwable)reader, (String)"com.ibm.ws.security.saml.sso20.token.Saml20AttributeImpl", (String)"79", (Object)this, (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    void xpe;
                    Tr.debug((TraceComponent)tc, (String)"Fail to deserialize Attribute", (Object[])new Object[]{xpe.toString()});
                }
            }
            catch (UnmarshallingException xpe) {
                void ue;
                FFDCFilter.processException((Throwable)xpe, (String)"com.ibm.ws.security.saml.sso20.token.Saml20AttributeImpl", (String)"83", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Fail to deserialize Attribute", (Object[])new Object[]{ue.toString()});
            }
        }
    }

    protected void init() {
        this.name = this.attribute.getName();
        this.format = this.attribute.getNameFormat();
        this.friendlyName = this.attribute.getFriendlyName();
        this.initSchemaType();
        this.initNameSpaces();
        this.serializeValue();
    }

    public List<QName> getNameSpaces() {
        return Collections.unmodifiableList(this.namespaces);
    }

    protected void initNameSpaces() {
        Set nsset = this.attribute.getNamespaces();
        if (!nsset.isEmpty()) {
            for (Namespace ns : nsset) {
                String uri = ns.getNamespaceURI();
                String prefix = ns.getNamespacePrefix();
                QName qn = prefix == null ? new QName(uri, "") : new QName(uri, "", prefix);
                this.namespaces.add(qn);
            }
        }
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    protected void initSchemaType() {
        block0: {
            List attributevalues = this.attribute.getAttributeValues();
            ListIterator it = attributevalues.listIterator();
            if (!it.hasNext()) break block0;
            XMLObject xml = (XMLObject)it.next();
            this.schemaType = xml.getSchemaType();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNameFormat() {
        return this.format;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public List<String> getValuesAsString() {
        return Collections.unmodifiableList(this.simpleStringValues);
    }

    public List<String> getSerializedValues() {
        return Collections.unmodifiableList(this.stringValues);
    }

    protected void serializeValue() {
        List valueXmls = this.attribute.getAttributeValues();
        for (XMLObject valueXml : valueXmls) {
            String stringValue = XMLHelper.nodeToString((Node)valueXml.getDOM());
            this.stringValues.add(stringValue);
            this.simpleStringValues.add(valueXml.getDOM().getTextContent());
        }
    }

    public String getSerializedAttribute() {
        return this.seializedAttribute;
    }

    public String toString() {
        String result = "Attribute\n name:" + this.name + "\n format:" + this.format + "\n friendlyName:" + this.friendlyName + "\n schemaType:" + this.schemaType + "\n value:" + this.stringValues;
        return result;
    }
}

