/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.slo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder;
import com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.sso.common.saml.propagation.SamlCommonUtil;
import com.ibm.wsspi.security.tai.TAIResult;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml2.core.impl.LogoutRequestMarshaller;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SPInitiatedSLO {
    public static final TraceComponent tc = Tr.register(SPInitiatedSLO.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoSamlService ssoService = null;
    Subject subject = null;
    static final String SINDEX = "sessionIndex";
    static final long serialVersionUID = -2078822354329024931L;

    public SPInitiatedSLO(SsoSamlService service, Subject sub) {
        this.ssoService = service;
        this.subject = sub;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SLOSolicited(" + service.getProviderId() + ")"), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={SamlException.class})
    public void buildandSendSLORequest(HttpServletRequest req, HttpServletResponse resp) throws SamlException {
        BasicMessageContext<?, ?, ?> basicMsgCtx = BasicMessageContextBuilder.getInstance().buildIdp(req, resp, this.ssoService);
        String idpSLOUrl = this.handleIdpMetadataAndLogoutUrl(basicMsgCtx);
        if (this.ssoService.getConfig() != null && idpSLOUrl != null && this.ssoService.getConfig().isHttpsRequired() && !idpSLOUrl.startsWith("https")) {
            throw new SamlException("SAML20_IDP_PROTOCOL_NOT_HTTPS", null, new Object[]{idpSLOUrl});
        }
        HttpRequestInfo cachingRequestInfo = new HttpRequestInfo(req);
        req.setAttribute("SpSLOInProgress", (Object)"true");
        cachingRequestInfo.restorePostParams(req);
        LogoutRequest logoutRequest = this.buildLogoutRequest(cachingRequestInfo.getInResponseToId(), req, basicMsgCtx);
        String sloRequestStr = null;
        if (basicMsgCtx.getSsoConfig().isAuthnRequestsSigned()) {
            this.signLogoutRequest((SAMLObject)logoutRequest, RequestUtil.getSigningCredential(this.ssoService));
        }
        sloRequestStr = this.getLogoutRequestString(logoutRequest);
        String shortRelayState = SamlUtil.generateRandom();
        String relayState = "sp_initial_" + shortRelayState;
        RequestUtil.cacheRequestInfo(shortRelayState, this.ssoService, cachingRequestInfo);
        basicMsgCtx.setCachedRequestInfo(cachingRequestInfo);
        TAIResult result = this.postIdp(req, resp, sloRequestStr, relayState, idpSLOUrl, cachingRequestInfo);
    }

    /*
     * WARNING - void declaration
     */
    String handleIdpMetadataAndLogoutUrl(BasicMessageContext<?, ?, ?> basicMsgCtx) throws SamlException {
        String idpUrl;
        block11: {
            idpUrl = null;
            MetadataProvider metadataProvider = basicMsgCtx.getMetadataProvider();
            if (metadataProvider == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("idp metadata file :" + basicMsgCtx.getSsoConfig().getIdpMetadata()), (Object[])new Object[0]);
                }
                SsoConfig ssoConfig = this.ssoService.getConfig();
                String idpMetadataFile = ssoConfig.getIdpMetadata();
                String providerId = this.ssoService.getProviderId();
                if (idpMetadataFile == null || idpMetadataFile.isEmpty()) {
                    throw new SamlException("SAML20_NO_IDP_URL_OR_METADATA", null, new Object[]{providerId});
                }
                throw new SamlException("SAML20_NO_IDP_URL_ERROR", null, new Object[]{idpMetadataFile, providerId});
            }
            XMLObject metadata = null;
            try {
                metadata = metadataProvider.getMetadata();
                if (metadata instanceof EntityDescriptor) {
                    EntityDescriptor entityDescriptor = (EntityDescriptor)metadata;
                    String idpEntityId = entityDescriptor.getEntityID();
                    basicMsgCtx.setPeerEntityId(idpEntityId);
                    IDPSSODescriptor ssoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                    if (ssoDescriptor != null) {
                        List list = ssoDescriptor.getSingleLogoutServices();
                        for (SingleLogoutService sloService : list) {
                            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(sloService.getBinding())) continue;
                            basicMsgCtx.setPeerEntityEndpoint((Endpoint)sloService);
                            idpUrl = sloService.getLocation();
                            break;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("idpLogout url:" + idpUrl + "(" + "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST" + ")"), (Object[])new Object[0]);
                        }
                        break block11;
                    }
                    SsoConfig ssoConfig = this.ssoService.getConfig();
                    String idpMetadataFile = ssoConfig.getIdpMetadata();
                    String providerId = this.ssoService.getProviderId();
                    throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", null, new Object[]{idpMetadataFile, providerId, "No IDPSSODescriptor"});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: metadata is not an EntityDescriptor", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("idp metadata file :" + basicMsgCtx.getSsoConfig().getIdpMetadata()), (Object[])new Object[0]);
                }
                SsoConfig ssoConfig = this.ssoService.getConfig();
                String idpMetadaFile = ssoConfig.getIdpMetadata();
                String providerId = this.ssoService.getProviderId();
                throw new SamlException("SAML20_NO_IDP_URL_ERROR", null, new Object[]{idpMetadaFile, providerId});
            }
            catch (MetadataProviderException ssoConfig) {
                void e;
                FFDCFilter.processException((Throwable)ssoConfig, (String)"com.ibm.ws.security.saml.sso20.slo.SPInitiatedSLO", (String)"217", (Object)this, (Object[])new Object[]{basicMsgCtx});
                throw new SamlException((Exception)e);
            }
        }
        return idpUrl;
    }

    LogoutRequest buildLogoutRequest(String inResponseToId, HttpServletRequest req, BasicMessageContext<?, ?, ?> basicMsgCtx) throws SamlException {
        LogoutRequestBuilder lorBuilder = new LogoutRequestBuilder();
        LogoutRequest request = lorBuilder.buildObject();
        request.setID(inResponseToId);
        String acsEndpointUrl = RequestUtil.getAcsUrl(req, "/ibm/saml20/", this.ssoService.getProviderId(), this.ssoService.getConfig());
        request.setVersion(SAMLVersion.VERSION_20);
        String entityUrl = RequestUtil.getEntityUrl(req, "/ibm/saml20/", this.ssoService.getProviderId(), this.ssoService.getConfig());
        request.setIssuer(this.getIssuer(entityUrl));
        request.setIssueInstant(new DateTime());
        if (basicMsgCtx == null || basicMsgCtx.getPeerEntityEndpoint() == null || basicMsgCtx.getPeerEntityEndpoint().getLocation() == null) {
            throw new SamlException("SAML20_SLOENDPOINT_NOT_IN_METADATA", null, new Object[]{this.ssoService.getProviderId()});
        }
        request.setDestination(basicMsgCtx.getPeerEntityEndpoint().getLocation());
        NameIDBuilder nidBuilder = new NameIDBuilder();
        NameID nid = nidBuilder.buildObject();
        String session = null;
        Saml20Token saml20token = SamlCommonUtil.getSaml20TokenFromSubject((Subject)this.subject, (boolean)true);
        if (saml20token == null) {
            throw new SamlException("LOGOUT_CANNOT_FIND_SAMLTOKEN");
        }
        NameID originalnid = (NameID)saml20token.getProperties().get("NameID");
        nid.setFormat(saml20token.getSAMLNameIDFormat());
        nid.setValue(saml20token.getSAMLNameID());
        nid.setSPNameQualifier(originalnid.getSPNameQualifier());
        nid.setNameQualifier(originalnid.getNameQualifier());
        session = (String)saml20token.getProperties().get(SINDEX);
        request.setNameID(nid);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"session index = ", (Object[])new Object[]{session});
        }
        SessionIndexBuilder siBuilder = new SessionIndexBuilder();
        SessionIndex si = siBuilder.buildObject();
        si.setSessionIndex(session);
        request.getSessionIndexes().add(si);
        return request;
    }

    Issuer getIssuer(String acsEndpointUrl) {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(acsEndpointUrl);
        return issuer;
    }

    NameIDPolicy buildNameIdPolicy(SsoConfig samlConfig) {
        Boolean allowCreate;
        NameIDPolicyBuilder nameIDPolicyBuilder = new NameIDPolicyBuilder();
        NameIDPolicy nameIDPolicy = nameIDPolicyBuilder.buildObject();
        String strNameIDPolicy = samlConfig.getNameIDFormat();
        if (strNameIDPolicy != null && !strNameIDPolicy.isEmpty()) {
            nameIDPolicy.setFormat(strNameIDPolicy);
        }
        if ((allowCreate = samlConfig.getAllowCreate()) != null) {
            nameIDPolicy.setAllowCreate(allowCreate);
        }
        return nameIDPolicy;
    }

    /*
     * WARNING - void declaration
     */
    TAIResult postIdp(HttpServletRequest req, HttpServletResponse resp, String logoutRequest, String relayState, String idpUrl, HttpRequestInfo cachingRequestInfo) throws SamlException {
        byte[] logoutReqBytes = null;
        try {
            logoutReqBytes = logoutRequest.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e1;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.slo.SPInitiatedSLO", (String)"342", (Object)this, (Object[])new Object[]{req, resp, logoutRequest, relayState, idpUrl, cachingRequestInfo});
            SamlException samlException = new SamlException((Exception)e1);
            throw samlException;
        }
        String samlRequest = Base64.encodeBytes((byte[])logoutReqBytes, (int)8);
        if (relayState == null || samlRequest == null || idpUrl == null) {
            throw new SamlException("RelayState, Single-Sign-On URL, and Saml Logout Request must be provided");
        }
        resp.setStatus(200);
        ForwardRequestInfo requestInfo = new ForwardRequestInfo(idpUrl);
        requestInfo.setFragmentCookieId(cachingRequestInfo.getFragmentCookieId());
        requestInfo.setParameter("RelayState", new String[]{relayState});
        requestInfo.setParameter("SAMLRequest", new String[]{samlRequest});
        requestInfo.redirectPostRequest(req, resp, null, null);
        try {
            return TAIResult.create((int)403);
        }
        catch (WebTrustAssociationFailedException webTrustAssociationFailedException) {
            void e;
            FFDCFilter.processException((Throwable)webTrustAssociationFailedException, (String)"com.ibm.ws.security.saml.sso20.slo.SPInitiatedSLO", (String)"375", (Object)this, (Object[])new Object[]{req, resp, logoutRequest, relayState, idpUrl, cachingRequestInfo});
            throw new SamlException((Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    void signLogoutRequest(SAMLObject logoutRequest, Credential signingCredential) throws SamlException {
        SsoConfig samlConfig = this.ssoService.getConfig();
        if (logoutRequest instanceof SignableSAMLObject && signingCredential != null) {
            SignableSAMLObject signableMessage = (SignableSAMLObject)logoutRequest;
            XMLObjectBuilder signatureBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSignatureAlgorithm(samlConfig.getSignatureMethodAlgorithm());
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.setSigningCredential(signingCredential);
            try {
                SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null, null);
            }
            catch (SecurityException securityException) {
                void e;
                FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.security.saml.sso20.slo.SPInitiatedSLO", (String)"403", (Object)this, (Object[])new Object[]{logoutRequest, signingCredential});
                throw new SamlException((Exception)e, true);
            }
            signableMessage.setSignature(signature);
            try {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableMessage);
                if (marshaller == null) {
                    throw new SamlException("SAML20_AUTHENTICATION_FAIL", null, new Object[0]);
                }
                marshaller.marshall((XMLObject)signableMessage);
                Signer.signObject((Signature)signature);
            }
            catch (Exception marshaller) {
                void e;
                FFDCFilter.processException((Throwable)marshaller, (String)"com.ibm.ws.security.saml.sso20.slo.SPInitiatedSLO", (String)"421", (Object)this, (Object[])new Object[]{logoutRequest, signingCredential});
                throw new SamlException((Exception)e, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    String getLogoutRequestString(LogoutRequest logoutRequest) throws SamlException {
        String result = null;
        if (logoutRequest != null) {
            try {
                LogoutRequestMarshaller marshaller = new LogoutRequestMarshaller();
                Element element = marshaller.marshall((XMLObject)logoutRequest);
                result = XMLHelper.nodeToString((Node)element);
            }
            catch (MarshallingException marshaller) {
                void e;
                FFDCFilter.processException((Throwable)marshaller, (String)"com.ibm.ws.security.saml.sso20.slo.SPInitiatedSLO", (String)"434", (Object)this, (Object[])new Object[]{logoutRequest});
                throw new SamlException((Exception)e, true);
            }
        }
        return result;
    }
}

