/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletRequest;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpRequestInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient TraceComponent tc = Tr.register(HttpRequestInfo.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String COOKIE_NAME_SAVED_PARAMS = "WASSamlParams_";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    static final Cache postCache = new Cache(0, 0L);
    String requestURL;
    String requestURLWithFragments = null;
    String queryString;
    String reqUrl;
    String method;
    HashMap<String, String[]> parameters;
    String strInResponseToId;
    String fragement = null;
    String fragmentCookieId = null;
    String formLogoutExitPage = null;
    DateTime birthTime = new DateTime();
    Map savedPostParams = null;

    HttpRequestInfo() {
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequestInfo(HttpServletRequest request) throws SamlException {
        this.reqUrl = request.getRequestURL().toString();
        this.requestURL = HttpRequestInfo.getRequestURL(request);
        this.method = request.getMethod();
        this.strInResponseToId = SamlUtil.generateRandomID();
        this.formLogoutExitPage = (String)request.getAttribute("FormLogoutExitPage");
        if (METHOD_POST.equalsIgnoreCase(this.method) && this.formLogoutExitPage == null) {
            IServletRequest extRequest = (IServletRequest)request;
            try {
                this.savedPostParams = extRequest.getInputStreamData();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo", (String)"95", (Object)this, (Object[])new Object[]{request});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"An exception getting InputStreamData : ", (Object[])new Object[]{e});
                }
                throw new SamlException((Exception)e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Request: method (" + this.method + ") savedParams:" + this.savedPostParams), (Object[])new Object[0]);
        }
    }

    public HttpRequestInfo(String reqUrl, String requestURL, String method, String strInResponseToId, String formlogout, HashMap postParams) {
        this.reqUrl = reqUrl;
        this.requestURL = requestURL;
        this.method = method;
        this.strInResponseToId = strInResponseToId;
        this.formLogoutExitPage = formlogout;
        if (METHOD_POST.equalsIgnoreCase(this.method) && this.formLogoutExitPage == null) {
            this.savedPostParams = postParams;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Request: method (" + this.method + ") savedParams:" + this.savedPostParams), (Object[])new Object[0]);
        }
    }

    public String getFormLogoutExitPage() {
        return this.formLogoutExitPage;
    }

    public String getInResponseToId() {
        return this.strInResponseToId;
    }

    public HttpRequestInfo(String requestUrl, String queryString) {
        this.method = METHOD_GET;
        this.reqUrl = requestUrl;
        this.queryString = queryString;
        this.requestURL = queryString != null && !queryString.isEmpty() ? requestUrl + "?" + queryString : requestUrl;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getReqUrl() {
        return this.reqUrl;
    }

    public String getRequestUrl() {
        return this.requestURL;
    }

    public Map getSavedPostParams() {
        return this.savedPostParams;
    }

    public String getFragmentCookieId() {
        if (this.fragmentCookieId == null) {
            this.fragmentCookieId = SamlUtil.generateRandom(8);
        }
        return this.fragmentCookieId;
    }

    public void setFragmentCookieId(String fragmentCookieId) {
        this.fragmentCookieId = fragmentCookieId;
    }

    /*
     * WARNING - void declaration
     */
    public void redirectCachedHttpRequest(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue) throws SamlException {
        String redirectUrl;
        if (cookieName != null && cookieValue != null) {
            RequestUtil.createCookie(request, response, cookieName, cookieValue);
        }
        if (METHOD_POST.equalsIgnoreCase(this.method)) {
            String savePostId = SamlUtil.generateRandom(12);
            String cacheKey = SamlUtil.hash(savePostId);
            String postCookieName = this.getPostCookieName(cookieName);
            RequestUtil.createCookie(request, response, postCookieName, savePostId);
            postCache.put(cacheKey, (Object)this);
        }
        String string = redirectUrl = this.requestURLWithFragments == null || this.requestURLWithFragments.isEmpty() ? this.requestURL : this.requestURLWithFragments;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("... expect sendRedirect to '" + redirectUrl + "'"), (Object[])new Object[0]);
        }
        try {
            response.sendRedirect(redirectUrl);
        }
        catch (IOException cacheKey) {
            void e;
            FFDCFilter.processException((Throwable)cacheKey, (String)"com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo", (String)"220", (Object)this, (Object[])new Object[]{request, response, cookieName, cookieValue});
            throw new SamlException((Exception)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setWithFragmentUrl(HttpServletRequest request, HttpServletResponse response) throws SamlException {
        String encodedUrlCookieName = "WASSamlReq_" + this.fragmentCookieId;
        String encodedUrl = RequestUtil.getCookieId((IExtendedRequest)request, response, encodedUrlCookieName);
        try {
            if (encodedUrl != null && !encodedUrl.isEmpty()) {
                this.requestURLWithFragments = URLDecoder.decode(encodedUrl, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo", (String)"249", (Object)this, (Object[])new Object[]{request, response});
            throw new SamlException((Exception)e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Original RequestUrl:" + this.reqUrl + "\n  requestURLWithFragments:" + this.requestURLWithFragments), (Object[])new Object[0]);
        }
    }

    String getPostCookieName(String cookieName) {
        String hashProviderId = cookieName.substring("WASSamlACS_".length());
        return COOKIE_NAME_SAVED_PARAMS + hashProviderId;
    }

    public DateTime getBirthTime() {
        return this.birthTime;
    }

    public static String getRequestURL(HttpServletRequest req) {
        StringBuffer reqURL = req.getRequestURL();
        String queryString = req.getQueryString();
        if (queryString != null) {
            reqURL.append("?");
            reqURL.append(HttpRequestInfo.encodeQuery(queryString));
        }
        return reqURL.toString();
    }

    public static String encodeQuery(String query) {
        String[] queryParams;
        if (query == null) {
            return null;
        }
        StringBuilder rebuiltQuery = new StringBuilder();
        for (String param : queryParams = query.split("&")) {
            String rebuiltParam = HttpRequestInfo.encode(param);
            int equalIndex = param.indexOf("=");
            if (equalIndex > -1) {
                String name = param.substring(0, equalIndex);
                String value = equalIndex < param.length() - 1 ? param.substring(equalIndex + 1) : "";
                rebuiltParam = HttpRequestInfo.encode(name) + "=" + HttpRequestInfo.encode(value);
            }
            if (rebuiltParam.isEmpty()) continue;
            rebuiltQuery.append(rebuiltParam + "&");
        }
        if (rebuiltQuery.length() > 0 && rebuiltQuery.charAt(rebuiltQuery.length() - 1) == '&') {
            rebuiltQuery.deleteCharAt(rebuiltQuery.length() - 1);
        }
        return rebuiltQuery.toString();
    }

    public static String encode(String value) {
        if (value == null) {
            return value;
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo", (String)"334", null, (Object[])new Object[]{value});
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static void restoreSavedParametersIfAny(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest) throws SamlException {
        IExtendedRequest extRequest = (IExtendedRequest)request;
        String postCookieName = COOKIE_NAME_SAVED_PARAMS + SamlUtil.hash(samlRequest.getProviderName());
        byte[] savePostIdBytes = extRequest.getCookieValueAsBytes(postCookieName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"savePostIdBytes:", (Object[])new Object[]{savePostIdBytes});
        }
        if (savePostIdBytes == null || savePostIdBytes.length < 8) {
            return;
        }
        String savePostId = null;
        try {
            savePostId = new String(savePostIdBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo", (String)"354", null, (Object[])new Object[]{request, response, samlRequest});
            throw new SamlException((Exception)e);
        }
        String cacheKey = SamlUtil.hash(savePostId);
        HttpRequestInfo requestInfo = (HttpRequestInfo)postCache.get(cacheKey);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"requestInfo is:", (Object[])new Object[]{requestInfo});
        }
        if (requestInfo != null) {
            String callingUrl = request.getRequestURL().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"callingUrl:", (Object[])new Object[]{callingUrl});
                Tr.debug((TraceComponent)tc, (String)"reqUrl:", (Object[])new Object[]{requestInfo.reqUrl});
            }
            if (callingUrl.equals(requestInfo.reqUrl)) {
                extRequest.setMethod(METHOD_POST);
                try {
                    extRequest.setInputStreamData((HashMap)requestInfo.savedPostParams);
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo", (String)"375", null, (Object[])new Object[]{request, response, samlRequest});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"An exception setting InputStreamData : ", (Object[])new Object[]{e});
                    }
                    throw new SamlException((Exception)e);
                }
                RequestUtil.removeCookie(request, response, postCookieName);
                postCache.remove((Object)cacheKey);
            }
        }
    }

    public void restorePostParams(HttpServletRequest request) {
        if (this.savedPostParams != null) {
            try {
                ((IExtendedRequest)request).setInputStreamData((HashMap)this.savedPostParams);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo", (String)"399", (Object)this, (Object[])new Object[]{request});
            }
        }
    }
}

