/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.binding;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.impl.Saml20HTTPPostDecoder;
import com.ibm.ws.security.saml.sso20.acs.AcsSecurityPolicy;
import com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.security.MetadataCredentialResolverFactory;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.InlineX509DataProvider;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BasicMessageContextBuilder<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(BasicMessageContextBuilder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static BasicMessageContextBuilder<?, ?, ?> instance = new BasicMessageContextBuilder();
    static final long serialVersionUID = 4571816687003785982L;

    public static void setInstance(BasicMessageContextBuilder<?, ?, ?> instance) {
        BasicMessageContextBuilder.instance = instance;
    }

    public static BasicMessageContextBuilder<?, ?, ?> getInstance() {
        return instance;
    }

    BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> getBasicMessageContext(SsoSamlService ssoService) {
        return new BasicMessageContext(ssoService);
    }

    BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> getBasicMessageContext(SsoSamlService ssoService, HttpServletRequest request, HttpServletResponse response) {
        return new BasicMessageContext(ssoService, request, response);
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> buildAcs(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String externalRelayState, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> basicMessageContext = this.getBasicMessageContext(ssoService, req, res);
        basicMessageContext.setAndRemoveCachedRequestInfo(externalRelayState, samlRequest);
        basicMessageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(req));
        this.setIdpMetadaProvider(basicMessageContext);
        this.decodeSamlResponse(basicMessageContext);
        return basicMessageContext;
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> buildSLO(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String externalRelayState, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> basicMessageContext = this.getBasicMessageContext(ssoService);
        basicMessageContext.setAndRemoveCachedRequestInfo(externalRelayState, samlRequest);
        basicMessageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(req));
        this.setIdpMetadaProvider(basicMessageContext);
        this.decodeSamlLogoutMessage(basicMessageContext);
        return basicMessageContext;
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> buildRsSaml(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String headerCpontent, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> basicMessageContext = this.getBasicMessageContext(ssoService);
        basicMessageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(req));
        return basicMessageContext;
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> buildIdp(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> basicMessageContext = this.getBasicMessageContext(ssoService);
        this.setIdpMetadaProvider(basicMessageContext);
        return basicMessageContext;
    }

    /*
     * WARNING - void declaration
     */
    public boolean decodeSamlResponse(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> basicMessageContext) throws SamlException {
        String acsUrl = RequestUtil.getAcsUrl(basicMessageContext.getHttpServletRequest(), "/ibm/saml20/", basicMessageContext.getSsoService().getProviderId(), basicMessageContext.getSsoConfig());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"acsUrl:", (Object[])new Object[]{acsUrl});
        }
        HTTPPostDecoder samlMessageDecoder = this.getSamlHttpPostDecoder(acsUrl);
        try {
            samlMessageDecoder.decode(basicMessageContext);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder", (String)"158", (Object)this, (Object[])new Object[]{basicMessageContext});
            throw BasicMessageContextBuilder.decodeError((Exception)e, basicMessageContext);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean decodeSamlLogoutMessage(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> basicMessageContext) throws SamlException {
        String sloUrl = RequestUtil.getSloUrl(basicMessageContext.getHttpServletRequest(), "/ibm/saml20/", basicMessageContext.getSsoService().getProviderId(), basicMessageContext.getSsoConfig());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SLO Url:", (Object[])new Object[]{sloUrl});
        }
        HTTPPostDecoder samlMessageDecoder = this.getSamlHttpPostDecoder(sloUrl);
        try {
            samlMessageDecoder.decode(basicMessageContext);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder", (String)"181", (Object)this, (Object[])new Object[]{basicMessageContext});
            throw BasicMessageContextBuilder.decodeError((Exception)e, basicMessageContext);
        }
        return true;
    }

    HTTPPostDecoder getSamlHttpPostDecoder(String acsUrl) {
        return new Saml20HTTPPostDecoder(acsUrl);
    }

    /*
     * WARNING - void declaration
     */
    boolean verifySignatureWithIdpMetadata(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> basicMessageContext) throws SamlException {
        try {
            SecurityPolicyResolver idpPolicyResolver = basicMessageContext.getIdpSecurityPolicyResolver();
            if (idpPolicyResolver != null) {
                Iterable securityPolicies = idpPolicyResolver.resolve(basicMessageContext);
                if (securityPolicies != null) {
                    for (SecurityPolicy policy : securityPolicies) {
                        if (policy == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Evaluating security policy of type '{}' for decoded message", (Object[])new Object[]{policy.getClass().getName()});
                        }
                        policy.evaluate(basicMessageContext);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No security policy resolved for this message context, no security policy evaluation attempted", (Object[])new Object[0]);
                }
            }
        }
        catch (SecurityException idpPolicyResolver) {
            void e;
            FFDCFilter.processException((Throwable)idpPolicyResolver, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder", (String)"217", (Object)this, (Object[])new Object[]{basicMessageContext});
            throw new SamlException((Exception)e);
        }
        return true;
    }

    void setSecurityPolicyResolver(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> messageContext) {
        AcsSecurityPolicy acsSecurityPolicy = new AcsSecurityPolicy();
        MetadataProvider metadataProvider = messageContext.getMetadataProvider();
        MetadataCredentialResolverFactory factory = MetadataCredentialResolverFactory.getFactory();
        InlineX509DataProvider x509DataProvider = new InlineX509DataProvider();
        ArrayList<InlineX509DataProvider> providers = new ArrayList<InlineX509DataProvider>();
        providers.add(x509DataProvider);
        BasicProviderKeyInfoCredentialResolver keyInfoCredResolver = new BasicProviderKeyInfoCredentialResolver(providers);
        ExplicitKeySignatureTrustEngine engine = new ExplicitKeySignatureTrustEngine((CredentialResolver)factory.getInstance((Object)metadataProvider), (KeyInfoCredentialResolver)keyInfoCredResolver);
        acsSecurityPolicy.add((SecurityPolicyRule)new SAMLMessageXMLSignatureSecurityPolicyRule((TrustEngine<Signature>)engine));
        messageContext.setIdpSecurityPolicyResolver((SecurityPolicyResolver)new StaticSecurityPolicyResolver((SecurityPolicy)acsSecurityPolicy));
    }

    BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> setIdpMetadaProvider(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> messageContext) throws SamlException {
        SsoConfig samlConfig = messageContext.getSsoConfig();
        AcsDOMMetadataProvider acsIdpMetadataProvider = samlConfig.getIdpMetadataProvider();
        messageContext.setMetadataProvider((MetadataProvider)acsIdpMetadataProvider);
        return messageContext;
    }

    public static SamlException decodeError(Exception e, SAMLMessageContext<?, ?, ?> msgContext) {
        String msg = e.getMessage();
        String className = e.getClass().getName();
        SamlException result = new SamlException("SAML20_DECODE_SAML_RESPONSE_FAILURE_LOG", e, new Object[]{msg, className});
        return result;
    }
}

