/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.saml2.PropagationHelper;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule;
import com.ibm.ws.security.saml.sso20.acs.StatusBuilderUtil;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResponseValidator<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(ResponseValidator.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> context;
    Response samlResponse;
    LogoutResponse samlLogoutResponse;
    LogoutRequest samlLogoutRequest;
    String issuer;
    long clockSkewAllowed = 0L;
    StatusBuilderUtil statusBuilderUtil;
    static final String SINDEX = "sessionIndex";
    static final long serialVersionUID = -8476555863916546419L;

    public ResponseValidator(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> context, Response samlResponse) {
        this.context = context;
        this.samlResponse = samlResponse;
        this.issuer = samlResponse.getIssuer().getValue();
        this.clockSkewAllowed = context.getSsoConfig().getClockSkew();
    }

    public ResponseValidator(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> context, LogoutResponse samlLogoutResponse) {
        this.context = context;
        this.samlLogoutResponse = samlLogoutResponse;
        this.issuer = samlLogoutResponse.getIssuer().getValue();
        this.clockSkewAllowed = context.getSsoConfig().getClockSkew();
        this.statusBuilderUtil = new StatusBuilderUtil();
    }

    public ResponseValidator(BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> context, LogoutRequest samlLogoutRequest) {
        this.context = context;
        this.samlLogoutRequest = samlLogoutRequest;
        this.issuer = samlLogoutRequest.getIssuer().getValue();
        this.clockSkewAllowed = context.getSsoConfig().getClockSkew();
        this.statusBuilderUtil = new StatusBuilderUtil();
    }

    public boolean validate() throws SamlException {
        boolean valid = true;
        this.validateStatus();
        if (this.samlResponse.getAssertions().isEmpty() && this.samlResponse.getEncryptedAssertions().isEmpty()) {
            throw new SamlException("SAML20_SP_NO_ASSERTION_ERROR", null, new Object[]{this.issuer});
        }
        this.validateVersion();
        this.validateInResponseTo();
        this.validateIssueInstant();
        this.validateDestination();
        this.validateIssuer();
        this.validateResponseSignature();
        return valid;
    }

    public boolean validateLogoutResponse() throws SamlException {
        boolean valid = true;
        this.validateVersion();
        this.validateInResponseTo();
        this.validateIssueInstant();
        this.validateDestination();
        this.validateIssuer();
        this.validateResponseSignature();
        return valid;
    }

    public boolean validateLogoutRequest() {
        boolean valid = true;
        if (!this.validateNameID()) {
            return false;
        }
        if (!this.validateSessionIndex()) {
            return false;
        }
        try {
            if (!this.validateVersion()) {
                return false;
            }
            this.validateIssueInstant();
            this.validateDestination();
            this.validateIssuer();
            this.validateResponseSignature();
        }
        catch (SamlException samlException) {
            FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.acs.ResponseValidator", (String)"202", (Object)this, (Object[])new Object[0]);
            this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Requester");
            return false;
        }
        return valid;
    }

    private boolean validateSessionIndex() {
        boolean valid = false;
        if (this.samlLogoutRequest != null) {
            List list;
            Saml20Token saml20token = PropagationHelper.getSaml20Token();
            if (saml20token == null) {
                this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Responder");
                return false;
            }
            String session = (String)saml20token.getProperties().get(SINDEX);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionIndex in the current saml token  = ", (Object[])new Object[]{session});
            }
            if ((list = this.samlLogoutRequest.getSessionIndexes()).isEmpty() || session == null) {
                if (list.isEmpty() && session == null) {
                    return true;
                }
                this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Requester");
                return false;
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (!session.equals(((SessionIndex)it.next()).getSessionIndex())) continue;
                valid = true;
                break;
            }
            if (!valid) {
                this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Requester");
            }
        }
        return valid;
    }

    private boolean validateNameID() {
        boolean valid = true;
        if (this.samlLogoutRequest != null) {
            String principal = this.getNameIDValue();
            Saml20Token saml20token = PropagationHelper.getSaml20Token();
            if (saml20token == null) {
                try {
                    this.validateResponseSignature();
                }
                catch (SamlException samlException) {
                    FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.acs.ResponseValidator", (String)"265", (Object)this, (Object[])new Object[0]);
                    this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Requester");
                    return false;
                }
                this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Success");
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"NameID in the saml logout request = ", (Object[])new Object[]{principal});
                Tr.debug((TraceComponent)tc, (String)"NameID in the current saml token  = ", (Object[])new Object[]{saml20token.getSAMLNameID()});
            }
            if (principal == null || !principal.equals(saml20token.getSAMLNameID())) {
                this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Requester");
                return false;
            }
        }
        return valid;
    }

    private String getNameIDValue() {
        String nameId = null;
        if (this.isNameIDEncrypted()) {
            try {
                nameId = this.decryptNameID();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.acs.ResponseValidator", (String)"294", (Object)this, (Object[])new Object[0]);
            }
        } else {
            nameId = this.samlLogoutRequest.getNameID().getValue();
        }
        return nameId;
    }

    private String decryptNameID() throws SamlException, DecryptionException {
        Decrypter decrypter = this.context.getDecrypter();
        SAMLObject samlobj = decrypter.decrypt(this.samlLogoutRequest.getEncryptedID());
        if (samlobj != null && samlobj instanceof NameID) {
            return ((NameID)samlobj).getValue();
        }
        return null;
    }

    private boolean isNameIDEncrypted() {
        return this.samlLogoutRequest.getEncryptedID() != null;
    }

    void validateInResponseTo() throws SamlException {
        if (this.samlResponse != null) {
            RequestUtil.validateInResponseTo(this.context, this.samlResponse.getInResponseTo());
        } else if (this.samlLogoutResponse != null) {
            RequestUtil.validateInResponseTo(this.context, this.samlLogoutResponse.getInResponseTo());
        }
    }

    protected boolean validateStatus() throws SamlException {
        boolean valid = true;
        StatusCode requiredStatusCode = this.samlResponse.getStatus().getStatusCode();
        String statusCode = requiredStatusCode.getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
            valid = false;
            String message = statusCode;
            StatusMessage statusMessage = this.samlResponse.getStatus().getStatusMessage();
            if (statusMessage != null) {
                message = statusMessage.getMessage();
            } else {
                StatusCode subStatusCode = requiredStatusCode.getStatusCode();
                if (subStatusCode != null) {
                    message = subStatusCode.getValue();
                }
            }
            throw new SamlException("SAML20_SP_BAD_SAML_RESPONSE_ERROR", null, new Object[]{this.issuer, statusCode, message});
        }
        return valid;
    }

    public Status validateLogoutStatus() throws SamlException {
        StatusCode requiredStatusCode = this.samlLogoutResponse.getStatus().getStatusCode();
        String statusCode = requiredStatusCode.getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
            String message = statusCode;
            StatusMessage statusMessage = this.samlLogoutResponse.getStatus().getStatusMessage();
            if (statusMessage != null) {
                message = statusMessage.getMessage();
            } else {
                StatusCode subStatusCode = requiredStatusCode.getStatusCode();
                if (subStatusCode != null) {
                    String string = subStatusCode.getValue();
                }
            }
        }
        return this.samlLogoutResponse.getStatus();
    }

    boolean validateVersion() throws SamlException {
        SAMLVersion version = null;
        boolean isLogoutMessage = false;
        if (this.samlResponse != null) {
            version = this.samlResponse.getVersion();
        } else if (this.samlLogoutResponse != null) {
            version = this.samlLogoutResponse.getVersion();
            isLogoutMessage = true;
        } else if (this.samlLogoutRequest != null) {
            version = this.samlLogoutRequest.getVersion();
            isLogoutMessage = true;
        }
        int majorVersion = 0;
        int minorVersion = 0;
        if (version != null) {
            majorVersion = version.getMajorVersion();
            minorVersion = version.getMinorVersion();
        }
        if (majorVersion != 2 || minorVersion != 0) {
            if (isLogoutMessage) {
                this.statusBuilderUtil.setStatus(this.context.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Requester");
                return false;
            }
            throw new SamlException("SAML20_SP_BAD_VERSION_ERROR", null, new Object[]{version.toString()});
        }
        return true;
    }

    protected boolean validateDestination() throws SamlException {
        String destination = null;
        if (this.samlResponse != null) {
            destination = this.samlResponse.getDestination();
        } else if (this.samlLogoutResponse != null) {
            destination = this.samlLogoutResponse.getDestination();
        } else if (this.samlLogoutRequest != null) {
            destination = this.samlLogoutRequest.getDestination();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destination is '" + destination + "'"), (Object[])new Object[0]);
        }
        if (destination == null) {
            return true;
        }
        String urlString = null;
        if (this.samlResponse != null) {
            urlString = RequestUtil.getAcsUrl(this.context.getHttpServletRequest(), "/ibm/saml20/", this.context.getSsoService().getProviderId(), this.context.getSsoConfig());
        } else if (this.samlLogoutResponse != null || this.samlLogoutRequest != null) {
            urlString = RequestUtil.getSloUrl(this.context.getHttpServletRequest(), "/ibm/saml20/", this.context.getSsoService().getProviderId(), this.context.getSsoConfig());
        }
        if (urlString.equals(destination)) {
            return true;
        }
        throw new SamlException("SAML20_RESPONSE_BAD_DESTINATION", null, new Object[]{destination, urlString});
    }

    protected boolean validateIssuer() throws SamlException {
        Issuer samlIssuer = null;
        if (this.samlResponse != null) {
            samlIssuer = this.samlResponse.getIssuer();
        } else if (this.samlLogoutResponse != null) {
            samlIssuer = this.samlLogoutResponse.getIssuer();
        } else if (this.samlLogoutRequest != null) {
            samlIssuer = this.samlLogoutRequest.getIssuer();
        }
        return MsgCtxUtil.validateIssuer(samlIssuer, this.context, false);
    }

    protected boolean validateIssueInstant() throws SamlException {
        DateTime jodaTime = null;
        if (this.samlResponse != null) {
            jodaTime = this.samlResponse.getIssueInstant();
        } else if (this.samlLogoutResponse != null) {
            jodaTime = this.samlLogoutResponse.getIssueInstant();
        } else if (this.samlLogoutRequest != null) {
            jodaTime = this.samlLogoutRequest.getIssueInstant();
        }
        if (jodaTime != null && jodaTime.plus(this.clockSkewAllowed).isAfterNow() && jodaTime.minus(this.clockSkewAllowed).isBeforeNow()) {
            return true;
        }
        DateTime currentTime = new DateTime();
        throw new SamlException("SAML20_RESPONSE_BAD_ISSUE_TIME", null, new Object[]{jodaTime, currentTime, this.clockSkewAllowed / 1000L});
    }

    protected void validateResponseSignature() throws SamlException {
        if (this.samlResponse != null && this.samlResponse.getSignature() != null || this.samlLogoutResponse != null && this.samlLogoutResponse.getSignature() != null || this.samlLogoutRequest != null && this.samlLogoutRequest.getSignature() != null) {
            this.verifyResponseSignature();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void verifyResponseSignature() throws SamlException {
        try {
            TrustEngine<Signature> trustEngine = MsgCtxUtil.getTrustedEngine(this.context);
            SAMLMessageXMLSignatureSecurityPolicyRule signatureRule = new SAMLMessageXMLSignatureSecurityPolicyRule(trustEngine);
            signatureRule.evaluateProtocol((SAMLMessageContext<?, ?, ?>)this.context);
            if (!this.context.isInboundSAMLMessageAuthenticated()) {
                throw new SamlException("SAML20_SIGNATURE_NOT_VERIFIED_ERR", null, new Object[0]);
            }
        }
        catch (SecurityPolicyException trustEngine) {
            void e;
            FFDCFilter.processException((Throwable)trustEngine, (String)"com.ibm.ws.security.saml.sso20.acs.ResponseValidator", (String)"553", (Object)this, (Object[])new Object[0]);
            throw new SamlException((Exception)e);
        }
    }
}

