/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Condition;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.OneTimeUse;
import org.opensaml.saml2.core.ProxyRestriction;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AssertionValidator {
    private static TraceComponent tc = Tr.register(AssertionValidator.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    protected BasicMessageContext context = null;
    protected Assertion assertion = null;
    protected long clockSkewAllowed = 0L;
    static final long serialVersionUID = -1684717858640142480L;

    public AssertionValidator(BasicMessageContext<?, ?, ?> context, Assertion assertion) {
        this.assertion = assertion;
        this.context = context;
        this.clockSkewAllowed = context.getSsoConfig().getClockSkew();
    }

    public void validateAssertion() throws SamlException {
        this.validateIssuer(false);
        this.validateSignature();
        this.verifySubject();
        this.verifyConditions();
        this.verifyAuthnStatement();
    }

    protected void validateIssuer(boolean isRsSaml) throws SamlException {
        Issuer samlIssuer = this.assertion.getIssuer();
        MsgCtxUtil.validateIssuer(samlIssuer, this.context, isRsSaml);
    }

    protected void validateSignature() throws SamlException {
        this.context.setInboundSAMLMessageAuthenticated(false);
        if (this.assertion.getSignature() != null) {
            this.verifyAssertionSignature();
        }
        if (this.context.getSsoConfig().isWantAssertionsSigned() && !this.context.isInboundSAMLMessageAuthenticated()) {
            throw new SamlException("SAML20_ASSERTION_SIGNATURE_NOT_VERIFIED_ERR", null, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void verifyAssertionSignature() throws SamlException {
        try {
            TrustEngine<Signature> trustEngine = MsgCtxUtil.getTrustedEngine(this.context);
            SAMLMessageXMLSignatureSecurityPolicyRule signatureRule = new SAMLMessageXMLSignatureSecurityPolicyRule(trustEngine);
            signatureRule.evaluateAssertion((SAMLMessageContext<?, ?, ?>)this.context, this.assertion);
        }
        catch (SecurityPolicyException trustEngine) {
            void e;
            FFDCFilter.processException((Throwable)trustEngine, (String)"com.ibm.ws.security.saml.sso20.acs.AssertionValidator", (String)"111", (Object)this, (Object[])new Object[0]);
            throw new SamlException("SAML20_ASSERTION_SIGNATURE_FAIL_ERR", (Exception)e, new Object[]{e});
        }
    }

    protected void verifySubject() throws SamlException {
        Subject subject = this.assertion.getSubject();
        String method = null;
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            if ("urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod())) {
                SubjectConfirmationData data;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject Confirmation:", (Object[])new Object[]{confirmation.getMethod()});
                }
                if ((data = confirmation.getSubjectConfirmationData()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is no SubjectConfirmationData", (Object[])new Object[0]);
                    }
                    throw new SamlException("SAML20_ELEMENT_ERR", null, new Object[]{"SubjectConfirmationData"});
                }
                if (data.getNotBefore() != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is a NotBefore", (Object[])new Object[0]);
                    }
                    throw new SamlException("SAML20_SUBJECT_NOTBEFORE_ERR", null, new Object[0]);
                }
                if (data.getNotOnOrAfter() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"NotOnOrAfter attribute is required inside SubjectConfirmationData element.", (Object[])new Object[0]);
                    }
                    throw new SamlException("SAML20_ELEMENT_ATTR_ERR", null, new Object[]{"NotOnOrAfter", "SubjectConfirmationData"});
                }
                if (data.getNotOnOrAfter().plus(this.clockSkewAllowed).isBeforeNow()) {
                    throw new SamlException("SAML20_SUBJECT_NOTONAFTER_ERR", null, new Object[]{data.getNotOnOrAfter(), new Date(), this.clockSkewAllowed / 1000L});
                }
                RequestUtil.validateInResponseTo(this.context, data.getInResponseTo());
                String acsEndpointUrl = RequestUtil.getAcsUrl(this.context.getHttpServletRequest(), "/ibm/saml20/", this.context.getSsoService().getProviderId(), this.context.getSsoConfig());
                if (data.getRecipient() == null) {
                    throw new SamlException("SAML20_ELEMENT_ATTR_ERR", null, new Object[]{"Recipient", "SubjectConfirmationData"});
                }
                if (!acsEndpointUrl.equals(data.getRecipient())) {
                    throw new SamlException("SAML20_SUBJECT_NO_REC_MATCH_ERR", null, new Object[]{data.getRecipient(), acsEndpointUrl});
                }
                this.context.setSubjectNameIdentifier((SAMLObject)subject.getNameID());
                return;
            }
            method = confirmation.getMethod();
        }
        throw new SamlException("SAML20_NO_BEARER_FOUND", null, new Object[]{method});
    }

    protected void verifyConditions() throws SamlException {
        Conditions conditions = this.assertion.getConditions();
        if (conditions == null || conditions.getAudienceRestrictions().size() == 0) {
            throw new SamlException("SAML20_ELEMENT_ERR", null, new Object[]{"AudienceRestriction"});
        }
        if (conditions.getNotBefore() != null && conditions.getNotBefore().minus(this.clockSkewAllowed).isAfterNow()) {
            throw new SamlException("SAML20_SUBJECT_NOBEFORE_ERR", null, new Object[]{conditions.getNotBefore(), new Date(), this.clockSkewAllowed / 1000L});
        }
        if (conditions.getNotOnOrAfter() != null && conditions.getNotOnOrAfter().plus(this.clockSkewAllowed).isBeforeNow()) {
            throw new SamlException("SAML20_SUBJECT_NOAFTER_ERR", null, new Object[]{conditions.getNotOnOrAfter(), new Date(), this.clockSkewAllowed / 1000L});
        }
        for (Condition condition : conditions.getConditions()) {
            QName conditionQName = condition.getElementQName();
            if (conditionQName.equals(AudienceRestriction.DEFAULT_ELEMENT_NAME)) {
                this.verifyAudience(conditions.getAudienceRestrictions());
                continue;
            }
            if (conditionQName.equals(OneTimeUse.DEFAULT_ELEMENT_NAME) || conditionQName.equals(ProxyRestriction.DEFAULT_ELEMENT_NAME)) continue;
            throw new SamlException("SAML20_CONDITION_UNKNOWN_ERR", null, new Object[]{conditionQName});
        }
    }

    protected void verifyAudience(List<AudienceRestriction> audienceRestrictions) throws SamlException {
        String audienceUrl = RequestUtil.getEntityUrl(this.context.getHttpServletRequest(), "/ibm/saml20/", this.context.getSsoService().getProviderId(), this.context.getSsoConfig());
        SamlException lastException = null;
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            for (Audience aud : audienceRestriction.getAudiences()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Audience=" + aud.getAudienceURI()), (Object[])new Object[0]);
                }
                if (audienceUrl.equals(aud.getAudienceURI())) {
                    return;
                }
                lastException = new SamlException("SAML20_AUDIENCE_UNKNOWN_ERR", null, new Object[]{aud.getAudienceURI(), audienceUrl});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invalid audience", (Object[])new Object[0]);
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new SamlException("SAML20_ELEMENT_ATTR_ERR", null, new Object[]{"Audience", "Conditions"});
    }

    protected void verifyAuthnStatement() throws SamlException {
        List authns = this.assertion.getAuthnStatements();
        for (AuthnStatement statement : authns) {
            if (statement.getSessionNotOnOrAfter() == null || !statement.getSessionNotOnOrAfter().plus(this.clockSkewAllowed).isBeforeNow()) continue;
            throw new SamlException("SAML20_SESSION_ERR", null, new Object[]{statement.getSessionNotOnOrAfter(), new Date(), this.clockSkewAllowed / 1000L});
        }
    }
}

