/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.Jsp2Dom;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.ws.util.WSUtil;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspDocumentParser
extends DefaultHandler
implements LexicalHandler {
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String DTD_FOUND_MESSAGE = "dtd has been found";
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.document.JspDocumentParser";
    protected Locator locator;
    protected int textLineNum;
    protected int textColNum;
    protected int lastLineNum;
    protected int lastColNum;
    protected Document document;
    protected JspCoreContext ctxt;
    protected SAXParser saxParser;
    protected Stack elementStack;
    protected Stack directoryStack;
    protected Stack dependencyStack;
    protected List dependencyList;
    protected Map cdataJspIdMap;
    protected Map implicitTagLibMap;
    protected HashMap tagPrefixes;
    protected JspConfiguration jspConfiguration;
    protected JspOptions jspOptions;
    protected JspInputSource inputSource;
    protected String resolvedRelativeURL;
    protected String encodedRelativeURL;
    protected String encoding;
    protected Stack charsBuffers;
    protected boolean inDTD;
    protected List preRootCommentList;
    protected boolean pageEncodingSpecified;
    protected String jspPrefix;
    protected boolean isValidating;
    protected boolean isBomPresent;
    protected boolean isEncodingSpecifiedInProlog;
    protected String sourceEnc;
    static final long serialVersionUID = -2331505191678491475L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspDocumentParser(JspInputSource inputSource, String resolvedRelativeURL, JspCoreContext ctxt, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack directoryStack, Stack dependencyStack, List dependencyList, Map cdataJspIdMap, Map implicitTagLibMap, boolean isBomPresent, boolean isEncodingSpecifiedInProlog, String sourceEnc) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{inputSource, resolvedRelativeURL, ctxt, jspConfiguration, jspOptions, directoryStack, dependencyStack, dependencyList, cdataJspIdMap, implicitTagLibMap, isBomPresent, isEncodingSpecifiedInProlog, sourceEnc});
        }
        this.textLineNum = 0;
        this.textColNum = 0;
        this.lastLineNum = 1;
        this.lastColNum = 1;
        this.document = null;
        this.ctxt = null;
        this.saxParser = null;
        this.elementStack = new Stack();
        this.directoryStack = null;
        this.dependencyStack = null;
        this.dependencyList = null;
        this.cdataJspIdMap = null;
        this.implicitTagLibMap = null;
        this.tagPrefixes = new HashMap();
        this.jspConfiguration = null;
        this.jspOptions = null;
        this.inputSource = null;
        this.resolvedRelativeURL = null;
        this.encodedRelativeURL = null;
        this.encoding = null;
        this.charsBuffers = new Stack();
        this.inDTD = false;
        this.preRootCommentList = new ArrayList();
        this.pageEncodingSpecified = false;
        this.jspPrefix = "jsp";
        this.isValidating = false;
        this.isBomPresent = false;
        this.isEncodingSpecifiedInProlog = false;
        this.sourceEnc = null;
        this.inputSource = inputSource;
        this.ctxt = ctxt;
        this.directoryStack = directoryStack;
        this.dependencyStack = dependencyStack;
        this.dependencyList = dependencyList;
        this.cdataJspIdMap = cdataJspIdMap;
        this.implicitTagLibMap = implicitTagLibMap;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.resolvedRelativeURL = resolvedRelativeURL;
        this.isBomPresent = isBomPresent;
        this.isEncodingSpecifiedInProlog = isEncodingSpecifiedInProlog;
        this.sourceEnc = sourceEnc;
        try {
            this.encodedRelativeURL = URLEncoder.encode(resolvedRelativeURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JspCoreException(e);
        }
        if (this.implicitTagLibMap != null && this.implicitTagLibMap.size() > 0) {
            this.tagPrefixes.putAll(implicitTagLibMap);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Document parse(InputSource is) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parse", new Object[]{is});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "is =[" + is + "]");
        }
        try {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "getting new document...");
            }
            this.document = ParserFactory.newDocument(false, false);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "got new document: [" + this.document + "]");
            }
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        this.elementStack.push(this.document);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "about to call parse(false,is), is: [" + is + "]");
        }
        if (this.parse(false, is)) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "about to call parse(true,is)), is: [" + is + "]");
            }
            InputStream is2 = null;
            try {
                is2 = this.getInputStream(this.inputSource);
                InputSource inputSource = new InputSource(is2);
                this.parse(true, inputSource);
            }
            finally {
                if (is2 != null) {
                    try {
                        is2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Document document = this.document;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            document = document;
            logger.exiting(CLASS_NAME, "parse", document);
        }
        return document;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean parse(boolean validating, InputSource is) throws JspCoreException {
        boolean reparseWithValidation;
        block17: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "parse", new Object[]{validating, is});
            }
            this.isValidating = validating;
            reparseWithValidation = false;
            ClassLoader oldLoader = ThreadContextHelper.getContextClassLoader();
            ThreadContextHelper.setClassLoader((ClassLoader)JspDocumentParser.class.getClassLoader());
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " validating: [" + validating + "] is: [" + is + "]");
            }
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                saxFactory.setNamespaceAware(true);
                saxFactory.setValidating(validating);
                saxFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this.saxParser = saxFactory.newSAXParser();
                XMLReader xmlReader = this.saxParser.getXMLReader();
                xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY, this);
                xmlReader.setErrorHandler(this);
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " about to call ParserFactory.parseDocument");
                }
                ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " back from ParserFactory.parseDocument");
                }
            }
            catch (ParserConfigurationException e) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " caught ParserConfigurationException e: [" + e.getMessage() + "]");
                }
                throw new JspCoreException(e);
            }
            catch (SAXException e) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " caught SAXException e: [" + e.getMessage() + "]");
                }
                if (e.getMessage().equals(DTD_FOUND_MESSAGE)) {
                    reparseWithValidation = true;
                    break block17;
                }
                if (e.getCause() != null) {
                    throw new JspCoreException(this.buildLineNumberMessage(e.getCause().getLocalizedMessage()));
                }
                throw new JspCoreException(this.buildLineNumberMessage(e.getLocalizedMessage()));
            }
            catch (IOException e) {
                throw new JspCoreException(this.buildLineNumberMessage(e.getLocalizedMessage()));
            }
            finally {
                ThreadContextHelper.setClassLoader((ClassLoader)oldLoader);
            }
        }
        boolean bl = reparseWithValidation;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "parse", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private InputStream getInputStream(JspInputSource jspInputSource) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getInputStream", new Object[]{jspInputSource});
        }
        InputStream is = null;
        try {
            is = jspInputSource.getInputStream();
        }
        catch (IOException e) {
            String msg = JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{jspInputSource.getRelativeURL()});
            throw new JspCoreException(msg, new FileNotFoundException(msg));
        }
        InputStream inputStream = is;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            logger.exiting(CLASS_NAME, "getInputStream", inputStream);
        }
        return inputStream;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "startElement", new Object[]{uri, localName, qName, attrs});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "uri =[" + uri + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "localName =[" + localName + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "qName =[" + qName + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "attrs =[" + attrs + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "encoding =[" + this.encoding + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "jspConfiguration.getPageEncoding() =[" + this.jspConfiguration.getPageEncoding() + "]");
        }
        if (this.encoding == null && this.sourceEnc != null) {
            this.encoding = this.sourceEnc;
            if (this.jspConfiguration.getPageEncoding() != null && (this.isEncodingSpecifiedInProlog || this.isBomPresent)) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "startElement", "comparing encodings configuration: =[" + this.jspConfiguration.getPageEncoding() + "] returned encoding: [" + this.encoding + "]");
                }
                if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), this.encoding)) {
                    throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.xml", new Object[]{this.jspConfiguration.getPageEncoding(), this.encoding}));
                }
            }
        }
        if (localName.equals("directive.include") && uri.equals("http://java.sun.com/JSP/Page")) {
            try {
                String attrLocalName;
                String includePath = null;
                boolean seenIncludePath = false;
                if (attrs.getLength() > 0 && !(attrLocalName = attrs.getLocalName(0)).equals("")) {
                    if (!attrLocalName.equals("file")) {
                        throw new JspCoreException("jsp.error.include.directive.attribute.invalid", new Object[]{attrLocalName});
                    }
                    includePath = attrs.getValue("file");
                    seenIncludePath = true;
                }
                if (!seenIncludePath || includePath.equals("")) {
                    throw new JspCoreException("jsp.error.static.include.value.missing");
                }
                this.insertInclude(includePath);
            }
            catch (JspCoreException e) {
                throw new SAXException(e.getLocalizedMessage());
            }
        }
        Node parentNode = (Node)this.elementStack.peek();
        if (this.charsBuffers.size() > 0) {
            CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.peek();
            this.createJspTextElement(parentNode, chars.charsBuffer);
            chars.charsBuffer.delete(0, chars.charsBuffer.length());
            chars.clearNonWhiteSpaceFound();
        }
        StringBuffer attrNames = new StringBuffer();
        Element jspElement = this.document.createElementNS(uri, qName);
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrs.getQName(i).startsWith("xmlns")) {
                jspElement.setAttributeNS("http://www.w3.org/2000/xmlns/", attrs.getQName(i), attrs.getValue(i));
                if (attrs.getValue(i).equals("http://java.sun.com/JSP/Page")) {
                    this.jspPrefix = attrs.getQName(i).substring(attrs.getQName(i).indexOf("xmlns:") + 6);
                    continue;
                }
                String thisPrefix = attrs.getQName(i).substring(attrs.getQName(i).indexOf("xmlns:") + 6);
                if (thisPrefix.equals("")) continue;
                this.tagPrefixes.put(thisPrefix, attrs.getValue(i));
                continue;
            }
            jspElement.setAttributeNS(attrs.getURI(i), attrs.getQName(i), attrs.getValue(i));
            if (!attrs.getURI(i).equals("")) {
                attrNames.append(attrs.getURI(i) + ":" + attrs.getQName(i) + "~");
                continue;
            }
            attrNames.append(attrs.getQName(i) + "~");
        }
        String jspId = null;
        jspId = !uri.equals("http://java.sun.com/JSP/Page") && attrNames.length() > 0 ? "{" + attrNames.toString() + "}" + this.encodedRelativeURL + "[" + this.lastLineNum + "," + this.lastColNum + "," + (this.locator.getLineNumber() - (this.lastLineNum - 1)) + "]" : this.encodedRelativeURL + "[" + this.lastLineNum + "," + this.lastColNum + "," + (this.locator.getLineNumber() - (this.lastLineNum - 1)) + "]";
        jspElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
        if (uri.equals("http://java.sun.com/JSP/Page") && localName.equals("directive.page") && jspElement.hasAttribute("pageEncoding")) {
            if (!this.pageEncodingSpecified) {
                this.pageEncodingSpecified = true;
                if (this.jspConfiguration.getPageEncoding() != null) {
                    if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), this.encoding)) {
                        throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.xml", new Object[]{this.jspConfiguration.getPageEncoding(), this.encoding}));
                    }
                    if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), jspElement.getAttribute("pageEncoding"))) {
                        throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.pageencoding", new Object[]{this.jspConfiguration.getPageEncoding(), jspElement.getAttribute("pageEncoding")}));
                    }
                }
                if (!this.compareEncoding(jspElement.getAttribute("pageEncoding"), this.encoding)) {
                    throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.pageencoding.xml", new Object[]{jspElement.getAttribute("pageEncoding"), this.encoding}));
                }
                if (this.jspConfiguration.getPageEncoding() == null) {
                    this.jspConfiguration.setPageEncoding(this.encoding);
                }
            } else {
                throw new SAXException(JspCoreException.getMsg("jsp.error.page.pageencoding.dup", new Object[]{this.resolvedRelativeURL}));
            }
        }
        parentNode.appendChild(jspElement);
        this.elementStack.push(jspElement);
        if (parentNode instanceof Document) {
            for (Element commentElement : this.preRootCommentList) {
                jspElement.appendChild(commentElement);
            }
            if (this.jspConfiguration.getPreludeList().size() > 0) {
                try {
                    this.insertImplictIncludes(this.jspConfiguration.getPreludeList());
                }
                catch (JspCoreException e) {
                    throw new SAXException(e.getLocalizedMessage());
                }
            }
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        this.charsBuffers.push(new CharacterBuffer());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "startElement");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void characters(char[] ch, int start, int length) throws SAXException {
        Element e;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "characters", new Object[]{ch, start, length});
        }
        Node n = (Node)this.elementStack.peek();
        boolean keepWhitespace = false;
        if (n instanceof Element && (e = (Element)n).getNamespaceURI() != null && e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && e.getLocalName().equals("text")) {
            keepWhitespace = true;
        }
        StringBuffer characters = new StringBuffer();
        this.textLineNum = this.locator.getLineNumber();
        this.textColNum = this.locator.getColumnNumber();
        CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.peek();
        for (int i = 0; i < length; ++i) {
            characters.append(ch[start + i]);
            if (ch[start + i] == '\n' || ch[start + i] == ' ' || ch[start + i] == '\r' || ch[start + i] == '\t') continue;
            chars.setNonWhiteSpaceFound();
        }
        if (chars.isNonWhiteSpaceFound() || keepWhitespace) {
            chars.charsBuffer.append(characters);
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "characters");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "endElement", new Object[]{uri, localName, qName});
        }
        Node node = null;
        CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.pop();
        if (uri.equals("http://java.sun.com/JSP/Page")) {
            if (localName.equals("declaration") || localName.equals("expression") || localName.equals("scriptlet")) {
                String jspText = chars.charsBuffer.toString();
                CDATASection cdata = this.document.createCDATASection(jspText);
                node = (Node)this.elementStack.pop();
                node.appendChild(cdata);
            } else if (!localName.equals("directive.include")) {
                node = this.getJspElement();
                this.createJspTextElement(node, chars.charsBuffer);
            }
        } else {
            node = this.getJspElement();
            this.createJspTextElement(node, chars.charsBuffer);
        }
        if (node != null && node.getParentNode() instanceof Document) {
            this.elementStack.push(node);
            if (this.jspConfiguration.getCodaList().size() > 0) {
                try {
                    this.insertImplictIncludes(this.jspConfiguration.getCodaList());
                }
                catch (JspCoreException e) {
                    throw new SAXException(e.getLocalizedMessage());
                }
            }
            this.elementStack.pop();
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        chars = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "endElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void createJspTextElement(Node node, StringBuffer chars) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createJspTextElement", new Object[]{node, chars});
        }
        String jspText = chars.toString();
        if (chars.length() > 0) {
            CDATASection cdata = this.document.createCDATASection(jspText);
            node.appendChild(cdata);
            String jspId = this.encodedRelativeURL + "[" + this.textLineNum + "," + this.textColNum + "," + this.getLineCount(jspText) + "]";
            this.cdataJspIdMap.put(new Integer(cdata.hashCode()), jspId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "createJspTextElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Node getJspElement() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspElement", new Object[0]);
        }
        Node node = (Node)this.elementStack.pop();
        if (node.hasChildNodes()) {
            Element jspElement = (Element)node;
            String jspId = jspElement.getAttributeNS("http://java.sun.com/JSP/Page", "id");
            jspId = jspId + "[" + this.lastLineNum + "," + this.lastColNum + "]";
            jspElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
        }
        Node node2 = node;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            node2 = node2;
            logger.exiting(CLASS_NAME, "getJspElement", node2);
        }
        return node2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void comment(char[] buf, int offset, int len) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "comment", new Object[]{buf, offset, len});
        }
        if (!this.inDTD) {
            // empty if block
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "comment");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDocumentLocator(Locator locator) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setDocumentLocator", new Object[]{locator});
        }
        this.locator = locator;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setDocumentLocator");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void startCDATA() throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "startCDATA", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "startCDATA");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void endCDATA() throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "endCDATA", new Object[0]);
        }
        CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.peek();
        chars.clearNonWhiteSpaceFound();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "endCDATA");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void startEntity(String name) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "startEntity", new Object[]{name});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "startEntity");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void endEntity(String name) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "endEntity", new Object[]{name});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "endEntity");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "startDTD", new Object[]{name, publicId, systemId});
        }
        this.inDTD = true;
        if (!this.isValidating) {
            throw new SAXException(DTD_FOUND_MESSAGE);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "startDTD");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void endDTD() throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "endDTD", new Object[0]);
        }
        this.inDTD = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "endDTD");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void fatalError(SAXParseException e) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "fatalError", new Object[]{e});
        }
        throw e;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void error(SAXParseException e) throws SAXException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "error", new Object[]{e});
        }
        throw e;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void insertInclude(String includePath) throws JspCoreException {
        String fullPath;
        block19: {
            Container container;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "insertInclude", new Object[]{includePath});
            }
            fullPath = null;
            if (!includePath.startsWith("/")) {
                int lastLocation = this.resolvedRelativeURL.lastIndexOf("/");
                includePath = lastLocation > 0 ? WSUtil.resolveURI((String)(this.resolvedRelativeURL.substring(0, lastLocation + 1) + includePath)) : WSUtil.resolveURI((String)("/" + includePath));
            }
            if ((container = this.ctxt.getServletContext().getModuleContainer()) != null) {
                Entry e = container.getEntry(includePath);
                if (e != null) {
                    fullPath = e.getPath();
                    try {
                        Container convertedContainer = (Container)e.adapt(Container.class);
                        if (convertedContainer != null && e.getSize() == 0L && !WCCustomProperties.ALLOW_DIRECTORY_INCLUDE) {
                            if (logger != null && logger.isLoggable(Level.FINER)) {
                                logger.exiting(CLASS_NAME, "insertInclude");
                            }
                            return;
                        }
                        break block19;
                    }
                    catch (UnableToAdaptException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.exiting(CLASS_NAME, "insertInclude");
                }
                return;
            }
            fullPath = this.ctxt.getRealPath(includePath);
            if (new File(fullPath).isDirectory() && !WCCustomProperties.ALLOW_DIRECTORY_INCLUDE) {
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.exiting(CLASS_NAME, "insertInclude");
                }
                return;
            }
        }
        if (this.dependencyStack.contains(fullPath)) {
            throw new JspCoreException("jsp.error.static.include.circular.dependency", new Object[]{fullPath});
        }
        this.dependencyStack.push(fullPath);
        URL absoluteURL = this.inputSource.getAbsoluteURL();
        if (absoluteURL == null || absoluteURL.getProtocol().equals("file")) {
            this.dependencyList.add(includePath);
        }
        JspConfiguration includeConfiguration = this.jspConfiguration.getConfigManager().getConfigurationForStaticInclude(includePath, this.jspConfiguration);
        JspInputSource includePathInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.inputSource, includePath);
        HashMap mergedTagLibMap = new HashMap(this.implicitTagLibMap);
        mergedTagLibMap.putAll(this.tagPrefixes);
        Jsp2Dom jsp2Dom = new Jsp2Dom(includePathInputSource, this.ctxt, this.directoryStack, includeConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, mergedTagLibMap, true);
        Document includeDocument = jsp2Dom.getJspDocument();
        Node parentNode = (Node)this.elementStack.peek();
        if (includeDocument.getDocumentElement().getNamespaceURI() != null && includeDocument.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/JSP/Page") && includeDocument.getDocumentElement().getLocalName().equals("root")) {
            for (int i = 0; i < includeDocument.getDocumentElement().getChildNodes().getLength(); ++i) {
                Integer nodeHashCode;
                Node nodeToBeCopied = includeDocument.getDocumentElement().getChildNodes().item(i);
                Node n = this.document.importNode(nodeToBeCopied, true);
                if (nodeToBeCopied.getNodeType() == 4 && this.cdataJspIdMap.containsKey(nodeHashCode = new Integer(nodeToBeCopied.hashCode()))) {
                    String jspId = (String)this.cdataJspIdMap.remove(nodeHashCode);
                    this.cdataJspIdMap.put(new Integer(n.hashCode()), jspId);
                }
                parentNode.appendChild(n);
            }
        } else {
            for (int i = 0; i < includeDocument.getChildNodes().getLength(); ++i) {
                Node n = this.document.importNode(includeDocument.getChildNodes().item(i), true);
                parentNode.appendChild(n);
            }
        }
        this.dependencyStack.pop();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "insertInclude");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private int getLineCount(String s) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getLineCount", new Object[]{s});
        }
        int lineCount = 1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++lineCount;
        }
        int n = lineCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getLineCount", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean compareEncoding(String enc1, String enc2) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "compareEncoding", new Object[]{enc1, enc2});
        }
        boolean equal = false;
        if (enc1.equalsIgnoreCase(enc2)) {
            equal = true;
        } else if (enc1.toUpperCase().startsWith("UTF-16") && enc2.toUpperCase().startsWith("UTF-16")) {
            equal = true;
        }
        boolean bl = equal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "compareEncoding", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String buildLineNumberMessage(String msg) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "buildLineNumberMessage", new Object[]{msg});
        }
        String string = msg = this.resolvedRelativeURL + "(" + this.lastLineNum + "," + this.lastColNum + ") " + msg;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "buildLineNumberMessage", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void insertImplictIncludes(ArrayList implicitIncludeList) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "insertImplictIncludes", new Object[]{implicitIncludeList});
        }
        for (String includePath : implicitIncludeList) {
            this.insertInclude(includePath);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "insertImplictIncludes");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private class CharacterBuffer {
        StringBuffer charsBuffer = new StringBuffer();
        private boolean nonWhiteSpaceFound = false;
        static final long serialVersionUID = 4839165460128561446L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CharacterBuffer() {
        }

        public boolean isNonWhiteSpaceFound() {
            return this.nonWhiteSpaceFound;
        }

        public void setNonWhiteSpaceFound() {
            this.nonWhiteSpaceFound = true;
        }

        public void clearNonWhiteSpaceFound() {
            this.nonWhiteSpaceFound = false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.document.JspDocumentParser$CharacterBuffer", CharacterBuffer.class, null, null);
        }
    }
}

